/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats.actorcentrality;

import sim.field.network.Network;
import sim.field.network.stats.NetworkStatistics;
import sim.field.network.stats.UnitEdgeMetric;
import sim.field.network.stats.actorcentrality.FreemanNodeIndex;

public class ClosenessCentrality
extends FreemanNodeIndex {
    final double[][] allDistances;

    public ClosenessCentrality(Network network) {
        super(network);
        this.allDistances = NetworkStatistics.getShortestPathsMatrix(network, UnitEdgeMetric.defaultInstance);
    }

    public double getValue(Object node) {
        double[] distances = this.allDistances[this.network.getNodeIndex(node)];
        double sum = 0.0;
        int n = distances.length;
        for (int i = 0; i < distances.length; ++i) {
            sum += distances[i];
        }
        return 1.0 / sum;
    }

    public double getMaxCummulativeDifference() {
        int n = this.network.allNodes.numObjs;
        return (double)(n - 2) / (double)(2 * n - 3);
    }

    public double getMaxValue() {
        return 1.0 / (double)(this.network.allNodes.numObjs - 1);
    }
}

