/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats.actorcentrality;

import java.util.Iterator;
import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.EdgeMetric;
import sim.field.network.stats.actorcentrality.NodeIndex;
import sim.util.mantissa.linalg.GeneralSquareMatrix;
import sim.util.mantissa.linalg.SingularMatrixException;
import sim.util.mantissa.linalg.SquareMatrix;

public class InformationCentrality
extends NodeIndex {
    final double normalizationDenominator;
    final double[] ci;

    public InformationCentrality(Network network, EdgeMetric weightFn) {
        super(network);
        int n = network.allNodes.numObjs;
        int[] indirect = new int[n];
        for (int i = 0; i < n; ++i) {
            indirect[i] = i;
        }
        int isolated = 0;
        Iterator nodeIO = network.indexOutInHash.values().iterator();
        for (int k = 0; k < n; ++k) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)nodeIO.next();
            int index = ioi.index;
            if (ioi.out != null) continue;
            indirect[n - ++isolated] = indirect[index];
            indirect[index] = n - isolated;
        }
        int nonIsolatedN = n - isolated;
        GeneralSquareMatrix a = new GeneralSquareMatrix(nonIsolatedN);
        for (int i = 0; i < nonIsolatedN; ++i) {
            for (int j = 0; j < nonIsolatedN; ++j) {
                a.setElement(i, j, 1.0);
            }
        }
        nodeIO = network.indexOutInHash.values().iterator();
        for (int k = 0; k < n; ++k) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)nodeIO.next();
            int index = ioi.index;
            if (ioi.out == null) continue;
            int outDegree = ioi.out.numObjs;
            int indirectIndex = indirect[index];
            Object nodeObj = network.allNodes.objs[ioi.index];
            for (int i = 0; i < outDegree; ++i) {
                Edge e = (Edge)ioi.out.objs[i];
                int j = ((Network.IndexOutIn)network.indexOutInHash.get((Object)e.getOtherNode((Object)nodeObj))).index;
                a.setElement(indirectIndex, indirect[j], 1.0 - weightFn.getWeight(e));
            }
            a.setElement(indirectIndex, indirectIndex, 1 + outDegree);
        }
        double R = 0.0;
        double T = 0.0;
        this.ci = new double[n];
        try {
            int i;
            SquareMatrix c = a.getInverse(0.0);
            for (i = 0; i < nonIsolatedN; ++i) {
                T += c.getElement(i, i);
                R += c.getElement(0, i);
            }
            for (i = 0; i < n; ++i) {
                int indirectI = indirect[i];
                this.ci[i] = indirectI >= nonIsolatedN ? Double.POSITIVE_INFINITY : c.getElement(indirectI, indirectI);
            }
        }
        catch (SingularMatrixException ex) {
            throw new RuntimeException("Singular Matrix");
        }
        double k = (T - 2.0 * R) / (double)nonIsolatedN;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            this.ci[i] = 1.0 / (this.ci[i] + k);
            sum += this.ci[i];
        }
        this.normalizationDenominator = sum;
    }

    public double getValue(Object node) {
        return this.ci[this.network.getNodeIndex(node)];
    }

    public double getValue(int nodeIndex) {
        return this.ci[nodeIndex];
    }

    public double getMaxValue() {
        return this.normalizationDenominator;
    }
}

