/*
 * Decompiled with CFR 0.152.
 */
package sim.field.network.stats.actorcentrality;

import sim.field.network.Edge;
import sim.field.network.Network;
import sim.field.network.stats.EdgeMetric;
import sim.field.network.stats.actorcentrality.NodeIndex;
import sim.util.mantissa.linalg.GeneralSquareMatrix;
import sim.util.mantissa.linalg.SingularMatrixException;
import sim.util.mantissa.linalg.SquareMatrix;

public class PowerPrestige
extends NodeIndex {
    final double[] prestige;
    final double scalingDenominator;

    public PowerPrestige(Network network, EdgeMetric metric) {
        this(network, 1.0, metric);
    }

    public PowerPrestige(Network network, double beta, EdgeMetric metric) {
        super(network);
        int n = network.allNodes.numObjs;
        this.prestige = new double[n];
        Edge[][] adjM = network.getAdjacencyMatrix();
        GeneralSquareMatrix I_bR = new GeneralSquareMatrix(n);
        double[] Rsum = new double[n];
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            Edge[] adjMi = adjM[i];
            for (int j = 0; j < n; ++j) {
                Edge e = adjMi[j];
                double val = e == null ? 0.0 : metric.getWeight(e);
                sum += val;
                I_bR.setElement(i, j, (double)(i == j ? 1 : 0) - beta * val);
            }
            Rsum[i] = sum;
        }
        try {
            SquareMatrix I_bR_1 = I_bR.getInverse(0.0);
            double sumsq = 0.0;
            for (int i = 0; i < n; ++i) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += I_bR_1.getElement(i, k) * Rsum[k];
                }
                this.prestige[i] = sum;
                sumsq += sum * sum;
            }
            this.scalingDenominator = Math.sqrt(sumsq / (double)n);
        }
        catch (SingularMatrixException ex) {
            throw new RuntimeException("Singular Matrix");
        }
    }

    public double getValue(Object node) {
        Network.IndexOutIn inout = (Network.IndexOutIn)this.network.indexOutInHash.get(node);
        return this.prestige[inout.index];
    }

    public double getValue(int nodeIndex) {
        return this.prestige[nodeIndex];
    }

    public double getMaxValue() {
        return this.scalingDenominator;
    }
}

