/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.network.stats;

import java.util.Iterator;
import sim.field.network.Network;
import sim.field.network.stats.DegreeStatistics;
import sim.field.network.stats.EdgeMetric;
import sim.field.network.stats.NetworkStatistics;
import sim.field.network.stats.UnitEdgeMetric;
import sim.field.network.stats.WeightedEdgeMetric;
import sim.util.Bag;
import sim.util.gui.MiniHistogram;

public class DisplayableNetworkStatistics {
    public final Network net;
    int maxDegree;

    public DisplayableNetworkStatistics(Network net) {
        this.net = net;
    }

    public double getClusteringCoefficient() {
        return NetworkStatistics.getClusteringCoefficient(this.net);
    }

    public double getDensity() {
        return NetworkStatistics.getDensity(this.net);
    }

    public double getDiameterByEdge() {
        return NetworkStatistics.getDiameter(this.net, new WeightedEdgeMetric());
    }

    public double getDiameterByWeight() {
        return NetworkStatistics.getDiameter(this.net, new UnitEdgeMetric());
    }

    public double getSymmetryCoefficient() {
        return NetworkStatistics.getSymmetryCoefficient(this.net);
    }

    public double[] nodeEccentricityDistribution(EdgeMetric metric) {
        int n = this.net.allNodes.numObjs;
        double[] eccentricities = new double[n];
        for (int i = 0; i < n; ++i) {
            eccentricities[i] = NetworkStatistics.getNodeEccentricity(this.net, this.net.allNodes.objs[i], metric);
        }
        return eccentricities;
    }

    public String[] nodeEccentricityLabels() {
        int n = this.net.allNodes.numObjs;
        String[] labels = new String[n];
        for (int i = 0; i < n; ++i) {
            labels[i] = this.net.allNodes.objs[i].toString();
        }
        return labels;
    }

    public double[] degreeDistribution(boolean out) {
        int n = this.net.allNodes.numObjs;
        double[] data = new double[n];
        Iterator i = this.net.indexOutInHash.values().iterator();
        this.maxDegree = 0;
        for (int k = 0; k < n; ++k) {
            Network.IndexOutIn ioi = (Network.IndexOutIn)i.next();
            Bag b = out ? ioi.out : ioi.in;
            int d = b == null ? 0 : b.numObjs;
            data[k] = d;
            if (d <= this.maxDegree) continue;
            this.maxDegree = d;
        }
        return MiniHistogram.makeBuckets((double[])data, (int)this.maxDegree, (double)0.0, (double)this.maxDegree, (boolean)false);
    }

    public String[] degreeDistributionLabels() {
        String[] labels = new String[this.maxDegree + 1];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = "" + i;
        }
        return labels;
    }

    public double[] loglogScaleDegreeCCDF(boolean out) {
        int maxSize;
        double[] data = DegreeStatistics.getDegreeCCDF(this.net, out);
        for (maxSize = data.length - 1; maxSize >= 0 && data[maxSize] == 0.0; --maxSize) {
        }
        double[] histogram = new double[maxSize + 1];
        System.arraycopy(data, 0, histogram, 0, maxSize + 1);
        this.maxDegree = maxSize;
        return histogram;
    }

    public String[] loglogScaleDegreeCCDFLabels() {
        return MiniHistogram.makeBucketLabels((int)(this.maxDegree + 1), (double)0.0, (double)this.maxDegree, (boolean)false);
    }
}

