/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.network.stats;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import sim.display.GUIState;
import sim.field.network.Network;
import sim.field.network.stats.UnitEdgeMetric;
import sim.field.network.stats.WeightedEdgeMetric;
import sim.portrayal.Inspector;
import sim.portrayal.SimpleInspector;
import sim.portrayal.network.stats.DisplayableNetworkStatistics;
import sim.util.gui.LabelledList;
import sim.util.gui.MiniHistogram;
import sim.util.gui.NumberTextField;

public class SocialNetworkInspector
extends Inspector {
    MiniHistogram ecc = new MiniHistogram();
    MiniHistogram eccw = new MiniHistogram();
    MiniHistogram out = new MiniHistogram();
    MiniHistogram in = new MiniHistogram();
    MiniHistogram logout = new MiniHistogram();
    MiniHistogram login = new MiniHistogram();
    SimpleInspector properties;
    Network net;
    DisplayableNetworkStatistics stat;
    boolean created = false;

    public SocialNetworkInspector() {
        this.setVolatile(false);
    }

    public void setField(Network field, GUIState state) {
        this.net = field;
        this.removeAll();
        this.revalidate();
        this.createInspector(state);
    }

    void createInspector(GUIState state) {
        this.stat = new DisplayableNetworkStatistics(this.net);
        this.properties = new SimpleInspector((Object)this.stat, state, "Network Properties");
        LabelledList l = new LabelledList("Network Distributions");
        l.addLabelled("Node Eccentricity (by edge)", (Component)this.ecc);
        l.addLabelled("Node Eccentricity (by weight)", (Component)this.eccw);
        l.addLabelled("In-Degree", (Component)this.in);
        l.addLabelled("Out-Degree", (Component)this.out);
        l.addLabelled("Log-Log In-Degree CCDF", (Component)this.login);
        l.addLabelled("Log-Log Out-Degree CCDF", (Component)this.logout);
        this.reloadHistograms();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        Box b = new Box(0);
        JButton updateButton = (JButton)this.makeUpdateButton();
        b.add(updateButton);
        b.add(b.createGlue());
        p.add((Component)b, "North");
        NumberTextField sacrificial = new NumberTextField(1.0, true);
        Dimension d = sacrificial.getPreferredSize();
        d.width = updateButton.getPreferredSize().width;
        updateButton.setPreferredSize(d);
        d = sacrificial.getMinimumSize();
        d.width = updateButton.getMinimumSize().width;
        updateButton.setMinimumSize(d);
        p.add((Component)this.properties, "Center");
        this.add(p, "North");
        this.add((Component)l, "Center");
        this.setVolatile(false);
        this.created = true;
    }

    void reloadHistograms() {
        this.ecc.setBucketsAndLabels(this.stat.nodeEccentricityDistribution(new UnitEdgeMetric()), this.stat.nodeEccentricityLabels());
        this.eccw.setBucketsAndLabels(this.stat.nodeEccentricityDistribution(new WeightedEdgeMetric()), this.stat.nodeEccentricityLabels());
        this.out.setBucketsAndLabels(this.stat.degreeDistribution(true), this.stat.degreeDistributionLabels());
        this.in.setBucketsAndLabels(this.stat.degreeDistribution(false), this.stat.degreeDistributionLabels());
        this.logout.setBucketsAndLabels(this.stat.loglogScaleDegreeCCDF(true), this.stat.loglogScaleDegreeCCDFLabels());
        this.login.setBucketsAndLabels(this.stat.loglogScaleDegreeCCDF(false), this.stat.loglogScaleDegreeCCDFLabels());
    }

    public void updateInspector() {
        if (this.net == null) {
            return;
        }
        this.properties.updateInspector();
        this.reloadHistograms();
    }
}

