/*
 * Decompiled with CFR 0.152.
 */
package sim.util.mantissa.linalg;

import java.io.Serializable;
import sim.util.mantissa.linalg.Matrix;
import sim.util.mantissa.linalg.NonNullRange;

public class GeneralMatrix
extends Matrix
implements Serializable {
    public GeneralMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public GeneralMatrix(int rows, int columns, double[] data) {
        super(rows, columns, data);
    }

    public GeneralMatrix(Matrix m) {
        super(m);
    }

    public Matrix duplicate() {
        return new GeneralMatrix(this);
    }

    public void selfAdd(Matrix m) {
        if (this.rows != m.rows || this.columns != m.columns) {
            throw new IllegalArgumentException("cannot add a " + m.rows + 'x' + m.columns + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int index = 0; index < this.rows * this.columns; ++index) {
            int n = index;
            this.data[n] = this.data[n] + m.data[index];
        }
    }

    public void selfSub(Matrix m) {
        if (this.rows != m.rows || this.columns != m.columns) {
            throw new IllegalArgumentException("cannot substract a " + m.rows + 'x' + m.columns + " matrix from a " + this.rows + 'x' + this.columns + " matrix");
        }
        for (int index = 0; index < this.rows * this.columns; ++index) {
            int n = index;
            this.data[n] = this.data[n] - m.data[index];
        }
    }

    protected NonNullRange getRangeForRow(int i) {
        return new NonNullRange(0, this.columns);
    }

    protected NonNullRange getRangeForColumn(int j) {
        return new NonNullRange(0, this.rows);
    }
}

