/*
 * Decompiled with CFR 0.152.
 */
package sim.util.mantissa.linalg;

import java.io.Serializable;
import sim.util.mantissa.linalg.MatrixFactory;
import sim.util.mantissa.linalg.NonNullRange;

public abstract class Matrix
implements Serializable {
    protected final int rows;
    protected final int columns;
    protected final double[] data;

    protected Matrix(int rows, int columns) {
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException("cannot build a matrix with negative or null dimension");
        }
        this.rows = rows;
        this.columns = columns;
        this.data = new double[rows * columns];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0;
        }
    }

    public Matrix(int rows, int columns, double[] data) {
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException("cannot build a matrix with negative or null dimension");
        }
        this.rows = rows;
        this.columns = columns;
        this.data = data;
    }

    protected Matrix(Matrix m) {
        this.rows = m.rows;
        this.columns = m.columns;
        this.data = new double[this.rows * this.columns];
        System.arraycopy(m.data, 0, this.data, 0, m.data.length);
    }

    public abstract Matrix duplicate();

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public double getElement(int i, int j) {
        if (i < 0 || i >= this.rows || j < 0 || j >= this.columns) {
            throw new IllegalArgumentException("cannot get element (" + i + ", " + j + ") from a " + this.rows + 'x' + this.columns + " matrix");
        }
        return this.data[i * this.columns + j];
    }

    public void setElement(int i, int j, double value) {
        if (i < 0 || i >= this.rows || j < 0 || j >= this.columns) {
            throw new IllegalArgumentException("cannot set element (" + i + ", " + j + ") in a " + this.rows + 'x' + this.columns + " matrix");
        }
        this.data[i * this.columns + j] = value;
    }

    public Matrix add(Matrix m) {
        if (this.rows != m.rows || this.columns != m.columns) {
            throw new IllegalArgumentException("cannot add a " + m.rows + 'x' + m.columns + " matrix to a " + this.rows + 'x' + this.columns + " matrix");
        }
        double[] resultData = new double[this.rows * this.columns];
        int resultIndex = 0;
        int lowerElements = 0;
        int upperElements = 0;
        for (int i = 0; i < this.rows; ++i) {
            int j;
            NonNullRange r = NonNullRange.reunion(this.getRangeForRow(i), m.getRangeForRow(i));
            for (j = 0; j < r.begin; ++j) {
                resultData[resultIndex] = 0.0;
                ++resultIndex;
            }
            while (j < r.end) {
                resultData[resultIndex] = this.data[resultIndex] + m.data[resultIndex];
                if (j < i) {
                    ++lowerElements;
                } else if (i < j) {
                    ++upperElements;
                }
                ++resultIndex;
                ++j;
            }
            while (j < this.columns) {
                resultData[resultIndex++] = 0.0;
                ++resultIndex;
                ++j;
            }
        }
        return MatrixFactory.buildMatrix(this.rows, this.columns, resultData, lowerElements, upperElements);
    }

    public Matrix sub(Matrix m) {
        if (this.rows != m.rows || this.columns != m.columns) {
            throw new IllegalArgumentException("cannot substract a " + m.rows + 'x' + m.columns + " matrix from a " + this.rows + 'x' + this.columns + " matrix");
        }
        double[] resultData = new double[this.rows * this.columns];
        int resultIndex = 0;
        int lowerElements = 0;
        int upperElements = 0;
        for (int i = 0; i < this.rows; ++i) {
            int j;
            NonNullRange r = NonNullRange.reunion(this.getRangeForRow(i), m.getRangeForRow(i));
            for (j = 0; j < r.begin; ++j) {
                resultData[resultIndex] = 0.0;
                ++resultIndex;
            }
            while (j < r.end) {
                resultData[resultIndex] = this.data[resultIndex] - m.data[resultIndex];
                if (j < i) {
                    ++lowerElements;
                } else if (i < j) {
                    ++upperElements;
                }
                ++resultIndex;
                ++j;
            }
            while (j < this.columns) {
                resultData[resultIndex++] = 0.0;
                ++resultIndex;
                ++j;
            }
        }
        return MatrixFactory.buildMatrix(this.rows, this.columns, resultData, lowerElements, upperElements);
    }

    public Matrix mul(Matrix m) {
        if (this.columns != m.rows) {
            throw new IllegalArgumentException("cannot multiply a " + this.rows + 'x' + this.columns + " matrix by a " + m.rows + 'x' + m.columns + " matrix");
        }
        double[] resultData = new double[this.rows * m.columns];
        int resultIndex = 0;
        int lowerElements = 0;
        int upperElements = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < m.columns; ++j) {
                double value = 0.0;
                NonNullRange r = NonNullRange.intersection(this.getRangeForRow(i), m.getRangeForColumn(j));
                if (r.begin < r.end) {
                    int k = r.begin;
                    int idx = i * this.columns + k;
                    int midx = k * m.columns + j;
                    while (k++ < r.end) {
                        value += this.data[idx++] * m.data[midx];
                        midx += m.columns;
                    }
                    if (j < i) {
                        ++lowerElements;
                    } else if (i < j) {
                        ++upperElements;
                    }
                }
                resultData[resultIndex++] = value;
            }
        }
        return MatrixFactory.buildMatrix(this.rows, m.columns, resultData, lowerElements, upperElements);
    }

    public Matrix mul(double a) {
        Matrix copy = this.duplicate();
        copy.selfMul(a);
        return copy;
    }

    public void selfMul(double a) {
        for (int i = 0; i < this.rows; ++i) {
            NonNullRange r = this.getRangeForRow(i);
            int index = i * this.columns + r.begin;
            for (int j = r.begin; j < r.end; ++j) {
                int n = index++;
                this.data[n] = this.data[n] * a;
            }
        }
    }

    public Matrix getTranspose() {
        double[] resultData = new double[this.columns * this.rows];
        int resultIndex = 0;
        int upperElements = 0;
        int lowerElements = 0;
        for (int i = 0; i < this.columns; ++i) {
            int j;
            NonNullRange range = this.getRangeForColumn(i);
            int index = i;
            for (j = 0; j < range.begin; ++j) {
                resultData[resultIndex++] = 0.0;
                index += this.columns;
            }
            while (j < range.end) {
                resultData[resultIndex] = this.data[index];
                if (j < i) {
                    ++lowerElements;
                } else if (i < j) {
                    ++upperElements;
                }
                index += this.columns;
                ++resultIndex;
                ++j;
            }
            while (j < this.rows) {
                resultData[resultIndex] = 0.0;
                ++resultIndex;
                ++j;
            }
        }
        return MatrixFactory.buildMatrix(this.columns, this.rows, resultData, lowerElements, upperElements);
    }

    protected abstract NonNullRange getRangeForRow(int var1);

    protected abstract NonNullRange getRangeForColumn(int var1);

    public String toString() {
        String separator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        for (int index = 0; index < this.rows * this.columns; ++index) {
            if (index > 0) {
                if (index % this.columns == 0) {
                    buf.append(separator);
                } else {
                    buf.append(' ');
                }
            }
            buf.append(Double.toString(this.data[index]));
        }
        return buf.toString();
    }
}

