package sim.app.wcss;

import sim.engine.*;
import ec.util.*;
import sim.util.*;
import sim.field.grid.*;

public class Schelling extends SimState
    {
    public int neighborhood = 1;
    public double threshold = 3;
    public int gridHeight = 100;
    public int gridWidth = 100;
	
	public int getNeighborhood() { return neighborhood; }
    public void setNeighborhood(int val) { if (val > 0) neighborhood = val; }
    public double getThreshold() { return threshold; }
    public void setThreshold(double val) { if (val >= 0) threshold = val; }
    public double getRedProbability() { return redProbability; }
    public void setRedProbability(double val) 
        { if (val >= 0 && val + blueProbability <= 1) redProbability = val; }
    public double getBlueProbability() { return blueProbability; }
    public void setBlueProbability(double val) 
        { if (val >= 0 && val + redProbability <= 1) blueProbability = val; }

    public DoubleBag getHappinessDistribution()
        {
        DoubleBag happinesses = new DoubleBag();
        for(int x=0;x < gridWidth;x++)
            for(int y=0;y < gridHeight;y++)
                if (grid.get(x,y)!=null)
                    happinesses.add(((Agent)(grid.get(x,y))).getHappiness());
        return happinesses;
        }  
        
    public ObjectGrid2D grid = new ObjectGrid2D(gridWidth, gridHeight);  // a dummy one to start
    public Bag emptySpaces = new Bag();

    public Schelling(long seed)
        {
        super(new MersenneTwisterFast(seed), new Schedule());
        }
    
    public double redProbability = 0.333;
    public double blueProbability = 0.333;

    public void start()
        {
        super.start();  // clear out the schedule
        
        // clear out the grid and empty space list
        emptySpaces = new Bag();
        grid = new ObjectGrid2D(gridWidth, gridHeight);  // first, all are null ("EMPTY")
                
        // add the agents to the grid and schedule them in the schedule
        for(int x=0 ; x<gridWidth ; x++)
            for(int y=0 ; y<gridHeight ; y++)
                {
                Steppable agent = null;
                double d = random.nextDouble();
                if (d < redProbability) 
                    {
                    agent = new Red(new Int2D(x,y));
                    schedule.scheduleRepeating(agent);
                    }
                else if (d < redProbability + blueProbability)
                    {
                    agent = new Blue(new Int2D(x,y));
                    schedule.scheduleRepeating(agent);
                    }
                else  // add this location to empty spaces list
                    {
                    emptySpaces.add(new Int2D(x,y));
                    }
                                        
                grid.set(x,y,agent);
                }
        }
    
    public static void main(String[] args)
        {
        doLoop(Schelling.class, args);
        System.exit(0);
        }        
    }

