package sim.app.wcss;
import sim.engine.*;
import sim.display.*;

import sim.portrayal.*;
import sim.portrayal.grid.*;
import sim.portrayal.simple.*;
import java.awt.*;
import javax.swing.*;

public class SchellingWithUI extends GUIState
    {
    public SchellingWithUI() { super(new Schelling(System.currentTimeMillis())); }
    public SchellingWithUI(SimState state) { super(state); }
	
    public static String getName() { return "Schelling Segregation WCSS2006 Tutorial"; }
    
    public Object getSimulationInspectedObject() { return state; }

    public Display2D display;
    public JFrame displayFrame;
    ObjectGridPortrayal2D gridPortrayal = new ObjectGridPortrayal2D();

    public void init(Controller c)
        {
        super.init(c);
        
        // Make the Display2D.  We'll have it display stuff later.
        Schelling sch = (Schelling)state;
        display = new Display2D(sch.gridWidth * 4, sch.gridHeight * 4,this,1);
        displayFrame = display.createFrame();
        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list

        // attach the portrayals
        display.attach(gridPortrayal,"Agents");

        // specify the backdrop color  -- what gets painted behind the displays
        display.setBackdrop(Color.black);

        displayFrame.setVisible(true);
        }

    public void setupPortrayals()
        {
        // tell the portrayals what to portray and how to portray them
        gridPortrayal.setField(((Schelling)state).grid);
        gridPortrayal.setPortrayalForClass(Red.class, new OvalPortrayal2D(Color.red));
        gridPortrayal.setPortrayalForClass(Blue.class, new RectanglePortrayal2D(Color.blue));
        gridPortrayal.setPortrayalForNull(new SimplePortrayal2D());  // empty

        display.reset();    // reschedule the displayer
        display.repaint();  // redraw the display
        }

    public void start()
        {
        super.start();      
        setupPortrayals();  // set up our portrayals
        }
    
    public void load(SimState state)
        {
        super.load(state);
        setupPortrayals();  // we now have new grids.  Set up the portrayals to reflect this
        }

    public static void main(String[] args)
        {
        SchellingWithUI schUI = new SchellingWithUI();
        Console c = new Console(schUI);
        c.setVisible(true);
        }
    }
