package sim.app.wcss;
import sim.util.*;
import sim.engine.*;

public abstract class Agent implements Steppable
    {
    Int2D loc;
    
    public Agent(Int2D loc) 
        {
        this.loc = loc;
        }
        
    public abstract boolean isInMyGroup(Agent obj);

    IntBag neighborsX = new IntBag(9);
    IntBag neighborsY = new IntBag(9);
    double happiness = 0;

	public double getHappiness() { return happiness; }

    public void step( final SimState state )
        {
        Schelling sch = (Schelling)state;
        if (sch.emptySpaces.size() == 0) return;  // nowhere to move to!
        
        // get all the places I can go.  This will be slow as we have to rely on grabbing neighbors.
        sch.grid.getNeighborsMaxDistance(loc.x,loc.y,sch.neighborhood,false,neighborsX,neighborsY);
        
        // compute happiness
        happiness = 0;
        int len = neighborsX.size();

        for(int i = 0; i < len; i++)
            {
            int x = neighborsX.get(i);
            int y = neighborsY.get(i);
            Agent agent = (Agent)sch.grid.get(x,y);
            if (agent != this && isInMyGroup(agent)) // if he's just like me, but he's NOT me
                {
                // increment happiness by the linear distance to the guy
                happiness += 1.0/Math.sqrt((loc.x-x)*(loc.x-x) + (loc.y-y)*(loc.y-y));
                }
            }
                
        if (happiness >= sch.threshold) return;  // I'm happy -- we're not moving

        // Okay, so I'm unhappy.  First let's pull up roots.
        sch.grid.set(loc.x,loc.y,null);
                
        // Now where to go?  Pick a random spot from the empty spaces list.
        int newLocIndex = state.random.nextInt(sch.emptySpaces.size());
                
        // Swap the location in the list with my internal location
        Int2D newLoc = (Int2D)(sch.emptySpaces.get(newLocIndex));
        sch.emptySpaces.set(newLocIndex,loc);
        loc = newLoc;
                
        // Last, put down roots again
        sch.grid.set(loc.x,loc.y,this);
        }
    }

