package sim.app.webtutorial2;
import ec.util.*;
import java.io.*;
import sim.app.heatbugs.*;

public /*strictfp*/ class ParameterizedHeatBugs extends HeatBugs
    {
    public static final String P_SEED =                     "seed";
    public static final String V_TIME =                     "time";
    public static final String P_WIDTH =                    "width";
    public static final String P_HEIGHT =                   "height";
    public static final String P_BUG_COUNT =                "bugs";

    public static final String P_MIN_IDEAL_HEAT =   "min-ideal-heat";
    public static final String P_MAX_IDEAL_HEAT =   "max-ideal-heat";
    public static final String P_MIN_OUT_HEAT =     "min-output-heat";
    public static final String P_MAX_OUT_HEAT =     "max-output-heat";

    public static final String P_EVAPORATION =      "evaporation-rate";
    public static final String P_DIFFUSION =        "diffusion-rate";
    public static final String P_RAND_PROB =        "random-move-probability";
        
    ParameterDatabase paramDB;
       
    void loadParams()
	{
	if(paramDB==null)
	    return;
	Parameter param;
                
	long seed;
	String s = paramDB.getString(param = new Parameter(P_SEED), null);
	if(s.equalsIgnoreCase(V_TIME))
	    seed = System.currentTimeMillis();
	else
	    seed = paramDB.getLong(param);
	random.setSeed(seed);

	gridWidth = paramDB.getInt(param = new Parameter(P_WIDTH), null, 1);
	if(gridWidth<1)
	    throw new RuntimeException("Invalid value for "+param);
	gridHeight = paramDB.getInt(param = new Parameter(P_HEIGHT), null, 1);
	if(gridHeight<1)
	    throw new RuntimeException("Invalid value for "+param);
                        
	bugCount = paramDB.getInt(param = new Parameter(P_BUG_COUNT), null, 0);
	if(bugCount<0)
	    throw new RuntimeException("Invalid value for "+param);
                                
	randomMovementProbability = paramDB.getDouble(param = new Parameter(P_RAND_PROB), null, 0, 1);
	if(randomMovementProbability<0)
	    throw new RuntimeException("Invalid value for "+param);
                
	evaporationRate = paramDB.getDouble(param = new Parameter(P_EVAPORATION), null, 0, 1);
	if(evaporationRate<0)
	    throw new RuntimeException("Invalid value for "+param);
        
	diffusionRate = paramDB.getDouble(param = new Parameter(P_DIFFUSION), null, 0, 1);
	if(diffusionRate<0)
	    throw new RuntimeException("Invalid value for "+param);

	minIdealTemp = paramDB.getDouble(param = new Parameter(P_MIN_IDEAL_HEAT), null, 0);
	if(minIdealTemp<0)
	    throw new RuntimeException("Invalid value for "+param);         
	maxIdealTemp = paramDB.getDouble(param = new Parameter(P_MAX_IDEAL_HEAT), null, minIdealTemp);
	if(maxIdealTemp<minIdealTemp)
	    throw new RuntimeException("Invalid value for "+param);
	minOutputHeat = paramDB.getDouble(param = new Parameter(P_MIN_OUT_HEAT), null, 0);
	if(minOutputHeat<0)
	    throw new RuntimeException("Invalid value for "+param);         
	maxOutputHeat = paramDB.getDouble(param = new Parameter(P_MAX_OUT_HEAT), null, minOutputHeat);
	if(maxOutputHeat<minOutputHeat)
	    throw new RuntimeException("Invalid value for "+param);         
	}

    public ParameterizedHeatBugs(ParameterDatabase paramDB)
	{
	super(1);//some bogus seed, we'll use the right one as soon as we load the parmaters from DB
	this.paramDB = paramDB;
	loadParams();
	createGrids();
	}
        
    public void start()
	{
	loadParams();
	super.start();
	}
                
    public static void main(String[] args)
        {
        ParameterizedHeatBugs heatbugs = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        ParameterDatabase parameters = null; 
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-file"))
                {
		try
		    {
		    parameters=new ParameterDatabase(
			new File(args[x+1]).getAbsoluteFile(),
			args);
		    }catch(IOException ex){ex.printStackTrace();}
		break;
                }
        
        heatbugs = new ParameterizedHeatBugs(parameters); 
        heatbugs.start();  // prep the bugs!
        System.out.println("Starting HeatBugs.  Running for 500 steps.");
        
        long time;
        while((time = heatbugs.schedule.time()) < 500)
            {
            // step the schedule.  This is where everything happens.
            if (!heatbugs.schedule.step(heatbugs)) break;   // it won't happen that we end prematurely,
                                                            // but it's worth checking for!
            if (time%100==0 && time!=0) 
                System.out.println("Time Step " + time);
            }
        heatbugs.finish();
        if(parameters != null)
	    {
	    PrintWriter pw = new PrintWriter(System.out, true); 
	    parameters.listGotten(pw);
	    }
        }
    }
    
    
    
    
    
