package sim.app.webtutorial2;
import ec.util.*;
import java.io.*;
import sim.util.*;
import sim.app.heatbugs.*;

public /*strictfp*/ class ParameterizedHeatBugs2 extends HeatBugs
    {
    ParameterDatabase paramDB;
        
    public static final String P_SEED =                     "seed";
    public static final String V_TIME =                     "time";
        
    /** Creates a HeatBugs simulation with the given random number seed. */
    public ParameterizedHeatBugs2(ParameterDatabase paramDB)
	{
	super(1);//some bogus seed, we'll use the right one as soon as we load the parmaters from DB
	this.paramDB = paramDB;
	loadParams();
	createGrids();
	}
        
    public void start()
	{
	loadParams();
	super.start();
	}
                
    void loadParams()
	{
	if(paramDB==null)
	    return;
	Parameter param;
                
	long seed;
	String s = paramDB.getString(param = new Parameter(P_SEED), null);
	if(s.equalsIgnoreCase(V_TIME))
	    seed = System.currentTimeMillis();
	else
	    seed = paramDB.getLong(param);
	random.setSeed(seed);

                                
	Properties p = Properties.getProperties(this,false,true,false);
	for(int i=0; i< p.numProperties(); i++)
	    if (p.isReadWrite(i) && !p.isComposite(i) && paramDB.exists(new Parameter(p.getName(i))))
		{
		Parameter pa = new Parameter(p.getName(i));
		String value = paramDB.getString(pa,null);
		p.setValue(i,value);
		}
	}

//      public void setSeed(String s)

        
        

    

    
    
    public static void main(String[] args)
        {
        ParameterizedHeatBugs2 heatbugs = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        ParameterDatabase parameters = null; 
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-file"))
                {
		try
		    {
		    parameters=new ParameterDatabase(
			new File(args[x+1]).getAbsoluteFile(),
			args);
		    }catch(IOException ex){ex.printStackTrace();}
		break;
                }
        
        heatbugs = new ParameterizedHeatBugs2(parameters); 
        heatbugs.start();  // prep the bugs!
        System.out.println("Starting HeatBugs.  Running for 500 steps.");
        
        long time;
        while((time = heatbugs.schedule.time()) < 500)
            {
            // step the schedule.  This is where everything happens.
            if (!heatbugs.schedule.step(heatbugs)) break;   // it won't happen that we end prematurely,
                                                            // but it's worth checking for!
            if (time%100==0 && time!=0) 
                System.out.println("Time Step " + time);
            }
        heatbugs.finish();
        if(parameters != null)
	    {
	    PrintWriter pw = new PrintWriter(System.out, true); 
	    parameters.listGotten(pw);
	    }
        }
    }
    
    
    
    
    
