/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   AdjustmentValues.java

package ncsa.devices;

import java.util.Properties;
import javax.media.j3d.Transform3D;
import javax.vecmath.*;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.devices:
//            AdjustmentInterface, NCSAInputDevice

public class AdjustmentValues
    implements AdjustmentInterface
{

    public AdjustmentValues(String s, int i)
    {
        rotScale = 1.0F;
        posScale = 1.0F;
        name = s;
        sensorCount = i;
        setupOffsets();
        setupInversions();
        setupScale();
        buildTransforms();
    }

    public AdjustmentValues(NCSAInputDevice ncsainputdevice)
    {
        this(ncsainputdevice.getName(), ncsainputdevice.getSensorCount());
    }

    public void apply(int i, Vector3f vector3f)
    {
        vector3f.x *= posScale;
        vector3f.y *= posScale;
        vector3f.z *= posScale;
        vector3f.x = inversions[i][0] ? -((Tuple3f) (vector3f)).x : ((Tuple3f) (vector3f)).x;
        vector3f.y = inversions[i][1] ? -((Tuple3f) (vector3f)).y : ((Tuple3f) (vector3f)).y;
        vector3f.z = inversions[i][2] ? -((Tuple3f) (vector3f)).z : ((Tuple3f) (vector3f)).z;
        vector3f.x += offsets[i][0];
        vector3f.y += offsets[i][1];
        vector3f.z += offsets[i][2];
    }

    public void apply(Vector3f vector3f)
    {
        apply(0, vector3f);
    }

    public void applyR(int i, Vector3f vector3f)
    {
        vector3f.x *= rotScale;
        vector3f.y *= rotScale;
        vector3f.z *= rotScale;
        vector3f.x = inversions[i][3] ? -((Tuple3f) (vector3f)).x : ((Tuple3f) (vector3f)).x;
        vector3f.y = inversions[i][4] ? -((Tuple3f) (vector3f)).y : ((Tuple3f) (vector3f)).y;
        vector3f.z = inversions[i][5] ? -((Tuple3f) (vector3f)).z : ((Tuple3f) (vector3f)).z;
        vector3f.x += offsets[i][3];
        vector3f.y += offsets[i][4];
        vector3f.z += offsets[i][5];
    }

    public void applyR(Vector3f vector3f)
    {
        applyR(0, vector3f);
    }

    protected void buildTransforms()
    {
        Transform3D transform3d = new Transform3D();
        Transform3D transform3d1 = new Transform3D();
        Transform3D transform3d2 = new Transform3D();
        float af[] = new float[16];
        transforms = new Transform3D[sensorCount];
        for(int i = 0; i < sensorCount; i++)
            transforms[i] = new Transform3D();

        for(int j = 0; j < sensorCount; j++)
        {
            transform3d2.setIdentity();
            transform3d2.get(af);
            if(inversions[j][0])
                af[0] = -af[0];
            if(inversions[j][1])
                af[5] = -af[5];
            if(inversions[j][2])
                af[10] = -af[10];
            transform3d2.set(af);
            transforms[j].mul(transform3d2);
        }

    }

    public boolean getInversion(int i, int j)
    {
        return inversions[i][j];
    }

    public float getOffset(int i, int j)
    {
        return offsets[i][j];
    }

    public float getPositionScale()
    {
        return posScale;
    }

    public float getRotationScale()
    {
        return rotScale;
    }

    public Vector3d getVector(int i)
    {
        return new Vector3d(getOffset(i, 0), getOffset(i, 1), getOffset(i, 2));
    }

    public boolean getXInversion(int i)
    {
        return getInversion(i, 0);
    }

    public float getXOffset(int i)
    {
        return getOffset(i, 0);
    }

    public boolean getXRInversion(int i)
    {
        return getInversion(i, 3);
    }

    public float getXROffset(int i)
    {
        return getOffset(i, 3);
    }

    public boolean getYInversion(int i)
    {
        return getInversion(i, 1);
    }

    public float getYOffset(int i)
    {
        return getOffset(i, 1);
    }

    public boolean getYRInversion(int i)
    {
        return getInversion(i, 4);
    }

    public float getYROffset(int i)
    {
        return getOffset(i, 4);
    }

    public boolean getZInversion(int i)
    {
        return getInversion(i, 2);
    }

    public float getZOffset(int i)
    {
        return getOffset(i, 2);
    }

    public boolean getZRInversion(int i)
    {
        return getInversion(i, 5);
    }

    public float getZROffset(int i)
    {
        return getOffset(i, 5);
    }

    public void setInversion(int i, int j, boolean flag)
    {
        inversions[i][j] = flag;
    }

    public void setOffset(int i, int j, float f)
    {
        offsets[i][j] = f;
    }

    public void setPositionScale(float f)
    {
        posScale = f;
    }

    public void setRotationScale(float f)
    {
        rotScale = f;
    }

    public void setXInversion(int i, boolean flag)
    {
        setInversion(i, 0, flag);
    }

    public void setXOffset(int i, float f)
    {
        setOffset(i, 0, f);
    }

    public void setXRInversion(int i, boolean flag)
    {
        setInversion(i, 3, flag);
    }

    public void setXROffset(int i, float f)
    {
        setOffset(i, 3, f);
    }

    public void setYInversion(int i, boolean flag)
    {
        setInversion(i, 1, flag);
    }

    public void setYOffset(int i, float f)
    {
        setOffset(i, 1, f);
    }

    public void setYRInversion(int i, boolean flag)
    {
        setInversion(i, 4, flag);
    }

    public void setYROffset(int i, float f)
    {
        setOffset(i, 4, f);
    }

    public void setZInversion(int i, boolean flag)
    {
        setInversion(i, 2, flag);
    }

    public void setZOffset(int i, float f)
    {
        setOffset(i, 2, f);
    }

    public void setZRInversion(int i, boolean flag)
    {
        setInversion(i, 5, flag);
    }

    public void setZROffset(int i, float f)
    {
        setOffset(i, 5, f);
    }

    protected void setupInversions()
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        inversions = new boolean[sensorCount][];
        for(int i = 0; i < sensorCount; i++)
        {
            inversions[i] = new boolean[6];
            String s = portfolioproperties.getProperty(name + ".Sensor" + i + ".XInversion");
            if(s != null)
                inversions[i][0] = s.equalsIgnoreCase("true");
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".YInversion");
            if(s != null)
                inversions[i][1] = s.equalsIgnoreCase("true");
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".ZInversion");
            if(s != null)
                inversions[i][2] = s.equalsIgnoreCase("true");
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".XRInversion");
            if(s != null)
                inversions[i][3] = s.equalsIgnoreCase("true");
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".YRInversion");
            if(s != null)
                inversions[i][4] = s.equalsIgnoreCase("true");
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".ZRInversion");
            if(s != null)
                inversions[i][5] = s.equalsIgnoreCase("true");
        }

    }

    protected void setupOffsets()
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        offsets = new float[sensorCount][];
        for(int i = 0; i < sensorCount; i++)
        {
            offsets[i] = new float[6];
            String s = portfolioproperties.getProperty(name + ".Sensor" + i + ".XOffset");
            if(s != null)
                offsets[i][0] = Float.parseFloat(s);
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".YOffset");
            if(s != null)
                offsets[i][1] = Float.parseFloat(s);
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".ZOffset");
            if(s != null)
                offsets[i][2] = Float.parseFloat(s);
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".XROffset");
            if(s != null)
                offsets[i][3] = (float)((double)(Float.parseFloat(s) / 180F) * 1.5707963267948966D);
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".YROffset");
            if(s != null)
                offsets[i][4] = (float)((double)(Float.parseFloat(s) / 180F) * 1.5707963267948966D);
            s = portfolioproperties.getProperty(name + ".Sensor" + i + ".ZROffset");
            if(s != null)
                offsets[i][5] = (float)((double)(Float.parseFloat(s) / 180F) * 1.5707963267948966D);
        }

    }

    protected void setupScale()
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        String s = portfolioproperties.getProperty(name + ".RotationScale");
        if(s != null)
            rotScale = Float.parseFloat(s);
        s = portfolioproperties.getProperty(name + ".PositionScale");
        if(s != null)
            posScale = Float.parseFloat(s);
    }

    protected float offsets[][];
    protected boolean inversions[][];
    protected float rotScale;
    protected float posScale;
    protected String name;
    protected int sensorCount;
    protected Transform3D transforms[];
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int XR = 3;
    public static final int YR = 4;
    public static final int ZR = 5;
}
