/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   NCSAInputDevice.java

package ncsa.devices;

import java.util.Properties;
import javax.media.j3d.*;
import ncsa.j3d.ui.PortfolioProperties;

public class NCSAInputDevice
    implements InputDevice
{

    protected NCSAInputDevice()
    {
        processingMode = 5;
        name = generateUniqueName();
    }

    protected void buildSensorWithButtons(int i, int j)
    {
        buttons[i] = new int[j];
        sensors[i] = new Sensor(this, 30, j);
        sensorReads[i] = new SensorRead(j);
    }

    public void close()
    {
    }

    protected String generateUniqueName()
    {
        return "InputDevice" + count++;
    }

    public String getName()
    {
        return name;
    }

    public int getProcessingMode()
    {
        return processingMode;
    }

    public Sensor getSensor(int i)
    {
        return sensors[i];
    }

    public int getSensorCount()
    {
        return sensors.length;
    }

    public boolean initialize()
    {
        return true;
    }

    public void initializePortfolioDevice()
    {
        setupSensors();
        portfolioDeviceInitializing();
    }

    public void initializePortfolioDevice(String s)
    {
        if(s != null)
            name = s;
        initializePortfolioDevice();
    }

    public void pollAndProcessInput()
    {
    }

    protected void portfolioDeviceInitializing()
    {
    }

    public void processStreamInput()
    {
    }

    protected void setButtons(int i, int ai[])
    {
        for(int j = 0; j < buttons[i].length; j++)
            buttons[i][j] = ai[j];

    }

    public void setNominalPositionAndOrientation()
    {
    }

    public void setProcessingMode(int i)
    {
        switch(i)
        {
        case 3: // '\003'
        case 4: // '\004'
        case 5: // '\005'
            processingMode = i;
            break;

        default:
            throw new IllegalArgumentException("Processing mode must be one of DEMAND_DRIVEN, NON_BLOCKING, or BLOCKING");
        }
    }

    protected void setupSensors()
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        String s = portfolioproperties.getProperty(name + ".Sensors");
        int i = s != null ? Integer.parseInt(s) : 1;
        sensors = new Sensor[i];
        sensorReads = new SensorRead[i];
        buttons = new int[i][];
        for(int j = 0; j < i; j++)
        {
            String s1 = portfolioproperties.getProperty(name + ".Sensor" + j + ".Buttons");
            int k = s1 != null ? Integer.parseInt(s1) : 0;
            buildSensorWithButtons(j, k);
        }

    }

    protected Sensor sensors[];
    protected SensorRead sensorReads[];
    protected int buttons[][];
    private int processingMode;
    protected String name;
    static int count = 0;

}
