/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   BirdAngleDevice.java

package ncsa.devices.bird;

import java.io.*;
import java.util.Properties;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.media.j3d.*;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import ncsa.devices.*;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.devices.bird:
//            BirdDriver, intermediate

public class BirdAngleDevice extends NCSAInputDevice
    implements SerialPortEventListener, AdjustableInterface, ValuesWithRotation
{

    public BirdAngleDevice()
    {
        RECORD_SIZE = 0;
        count = 0;
        X = 0;
        Y = 1;
        Z = 2;
        XR = 3;
        YR = 4;
        ZR = 5;
        driver = null;
        inputStream = null;
        angleFormat = true;
        transform = new Transform3D();
        temp = new Transform3D();
        vector = new Vector3d();
        matrix = new float[16];
    }

    protected final void alignBoundary()
        throws IOException
    {
        boolean flag = false;
        for(int i = 0; inputStream.available() > 0 && !flag; i++)
        {
            inputStream.read(buffer, 0, 1);
            if((buffer[0] & 0x80) != 0)
            {
                flag = true;
                inputStream.unread(buffer, 0, 1);
            }
        }

    }

    protected void allocateSpace()
    {
        RECORD_SIZE = angleFormat ? 12 : 24;
        RECORD_SIZE += getSensorCount() <= 1 ? 0 : 1;
        buffer = new byte[RECORD_SIZE + 1];
        data = new float[getSensorCount()][];
        for(int i = 0; i < data.length; i++)
        {
            data[i] = new float[16];
            data[i][0] = 1.0F;
            data[i][5] = 1.0F;
            data[i][10] = 1.0F;
            data[i][15] = 1.0F;
        }

    }

    protected final float b2f(byte byte0, byte byte1)
    {
        int i = (short)((byte0 & 0x7f) << 9 | (byte1 & 0x7f) << 2);
        return (float)i / 32767F;
    }

    public AdjustmentInterface getAdjustmentInterface()
    {
        return new intermediate(adjust, this);
    }

    public float getValue(int i, int j)
    {
        return data[i][j];
    }

    public final float getX(int i)
    {
        float f = data[i][X] * adjust.getPositionScale();
        f = adjust.getInversion(i, 0) ? -f : f;
        f += adjust.getOffset(i, 0);
        return f;
    }

    public int getXIndex()
    {
        return X;
    }

    public final float getXR(int i)
    {
        float f = adjust.getInversion(i, 3) ? -data[i][XR] : data[i][XR];
        return f * adjust.getRotationScale() + adjust.getOffset(i, 3);
    }

    public int getXRIndex()
    {
        return XR;
    }

    public final float getY(int i)
    {
        float f = data[i][Y] * adjust.getPositionScale();
        f = adjust.getInversion(i, 1) ? -f : f;
        f += adjust.getOffset(i, 1);
        return f;
    }

    public int getYIndex()
    {
        return Y;
    }

    public final float getYR(int i)
    {
        float f = adjust.getInversion(i, 4) ? -data[i][YR] : data[i][YR];
        return f * adjust.getRotationScale() + adjust.getOffset(i, 4);
    }

    public int getYRIndex()
    {
        return YR;
    }

    public final float getZ(int i)
    {
        float f = data[i][Z] * adjust.getPositionScale();
        f = adjust.getInversion(i, 2) ? -f : f;
        f += adjust.getOffset(i, 2);
        return f;
    }

    public int getZIndex()
    {
        return Z;
    }

    public final float getZR(int i)
    {
        float f = adjust.getInversion(i, 5) ? -data[i][ZR] : data[i][ZR];
        return f * adjust.getRotationScale() + adjust.getOffset(i, 5);
    }

    public int getZRIndex()
    {
        return ZR;
    }

    public static void main(String args[])
    {
        BirdAngleDevice birdangledevice = new BirdAngleDevice();
        birdangledevice.initializePortfolioDevice("BirdAngleDevice");
        int i = 0;
        if(args.length > 0)
            i = Integer.parseInt(args[0]);
        int j = 0;
        if(args.length > 1)
            j = Integer.parseInt(args[1]);
        do
        {
            try
            {
                Thread.sleep(0L);
            }
            catch(Exception _ex) { }
            if(j == 0 || j == 1)
                System.out.print(birdangledevice.getX(i) + " ");
            if(j == 0 || j == 2)
                System.out.print(birdangledevice.getY(i) + " ");
            if(j == 0 || j == 3)
                System.out.print(birdangledevice.getZ(i) + " ");
            if(j == 0 || j == 4)
                System.out.print(birdangledevice.getXR(i) + " ");
            if(j == 0 || j == 5)
                System.out.print(birdangledevice.getYR(i) + " ");
            if(j == 0 || j == 6)
                System.out.print(birdangledevice.getZR(i) + " ");
            System.out.println();
        } while(true);
    }

    protected void parseProperties()
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        port = portfolioproperties.getProperty(super.name + ".Port");
        String s = portfolioproperties.getProperty(super.name + ".Bps");
        hemisphere = portfolioproperties.getProperty(super.name + ".Hemisphere");
        String s1 = portfolioproperties.getProperty(super.name + ".Filters");
        String s2 = portfolioproperties.getProperty(super.name + ".Streaming");
        String s3 = portfolioproperties.getProperty(super.name + ".ReportRate");
        if(portfolioproperties.getProperty(super.name + "Debug") != null)
            debug = true;
        port = port != null ? port : "com1";
        s = s != null ? s : "115200";
        hemisphere = hemisphere != null ? hemisphere : "LOWER";
        s1 = s1 != null ? s1 : "true";
        s2 = s2 != null ? s2 : "true";
        s3 = s3 != null ? s3 : "8";
        bps = Integer.parseInt(s);
        rate = Integer.parseInt(s3);
        filters = s1.equalsIgnoreCase("true");
        streaming = s2.equalsIgnoreCase("true");
        String s4;
        if((s4 = portfolioproperties.getProperty(super.name + "X")) != null)
            X = Integer.parseInt(s4);
        if((s4 = portfolioproperties.getProperty(super.name + "Y")) != null)
            Y = Integer.parseInt(s4);
        if((s4 = portfolioproperties.getProperty(super.name + "Z")) != null)
            Z = Integer.parseInt(s4);
        if((s4 = portfolioproperties.getProperty(super.name + "XR")) != null)
            XR = Integer.parseInt(s4);
        if((s4 = portfolioproperties.getProperty(super.name + "YR")) != null)
            YR = Integer.parseInt(s4);
        if((s4 = portfolioproperties.getProperty(super.name + "ZR")) != null)
            ZR = Integer.parseInt(s4);
    }

    public final void pollAndProcessInput()
    {
        for(int i = 0; i < getSensorCount(); i++)
        {
            prepareAngleData(i);
            super.sensorReads[i].setTime(System.currentTimeMillis());
            super.sensorReads[i].set(transform);
            super.sensors[i].setNextSensorRead(super.sensorReads[i]);
        }

    }

    public void portfolioDeviceInitializing()
    {
        parseProperties();
        allocateSpace();
        adjust = new AdjustmentValues(super.name, getSensorCount());
        if(debug)
            printDebug();
        driver = new BirdDriver(port, bps);
        inputStream = new PushbackInputStream(driver.getInputStream());
        driver.addEventListener(this);
        if(getSensorCount() > 1)
            driver.setGroupMode(getSensorCount());
        if(filters)
            driver.setFilters(true);
        else
            driver.setFilters(false);
        driver.setHemisphere(hemisphere);
        driver.setPositionAngles();
        if(streaming)
        {
            driver.setReportRate(rate);
            driver.setStreamMode();
        }
        if(PortfolioProperties.instance().getProperty(super.name + "RotationScale") == null)
            adjust.setRotationScale(1.570796F);
    }

    public final void prepareAngleData(int i)
    {
        vector.x = getX(i);
        vector.y = getY(i);
        vector.z = getZ(i);
        transform.set(vector);
        temp.rotX(getXR(i));
        transform.mul(temp);
        temp.rotY(getYR(i));
        transform.mul(temp);
        temp.rotZ(getZR(i));
        transform.mul(temp);
    }

    protected void printDebug()
    {
        System.out.println("Bird on port " + port);
        System.out.println("Bird running at " + bps + " bps");
        System.out.println("Bird is streaming " + streaming);
        System.out.println("Bird outputing angles " + angleFormat);
        System.out.println("Bird configured for " + hemisphere + " hemisphere");
        System.out.println("Bird filters are on " + filters);
        if(streaming)
            System.out.println("Bird sampling every " + rate + " clock cycles");
        System.out.println("X " + X + " Y " + Y + " Z " + Z + " XR " + XR + " YR " + YR + " ZR " + ZR);
    }

    protected final void processAngles()
    {
        if(count < 13)
        {
            return;
        } else
        {
            int i = buffer[12] - 1;
            data[i][0] = b2f(buffer[1], buffer[0]);
            data[i][1] = b2f(buffer[3], buffer[2]);
            data[i][2] = b2f(buffer[5], buffer[4]);
            data[i][3] = b2f(buffer[7], buffer[6]);
            data[i][4] = b2f(buffer[9], buffer[8]);
            data[i][5] = b2f(buffer[11], buffer[10]);
            return;
        }
    }

    public final void serialEvent(SerialPortEvent serialportevent)
    {
        switch(serialportevent.getEventType())
        {
        default:
            break;

        case 1: // '\001'
            try
            {
                while(inputStream.available() >= RECORD_SIZE) 
                {
                    count += inputStream.read(buffer, count, RECORD_SIZE - count);
                    if((buffer[0] & 0x80) == 0)
                    {
                        alignBoundary();
                        count = 0;
                    } else
                    {
                        processAngles();
                        count = 0;
                    }
                }
                break;
            }
            catch(IOException ioexception)
            {
                System.out.println("WandDriver.serialEvent");
                System.out.println(ioexception);
            }
            break;
        }
    }

    public void setXIndex(int i)
    {
        X = i;
    }

    public void setXRIndex(int i)
    {
        XR = i;
    }

    public void setYIndex(int i)
    {
        Y = i;
    }

    public void setYRIndex(int i)
    {
        YR = i;
    }

    public void setZIndex(int i)
    {
        Z = i;
    }

    public void setZRIndex(int i)
    {
        ZR = i;
    }

    int RECORD_SIZE;
    byte buffer[];
    int count;
    float data[][];
    int X;
    int Y;
    int Z;
    int XR;
    int YR;
    int ZR;
    BirdDriver driver;
    PushbackInputStream inputStream;
    String port;
    String hemisphere;
    int bps;
    int rate;
    boolean filters;
    boolean angleFormat;
    boolean streaming;
    boolean debug;
    Transform3D transform;
    Transform3D temp;
    Vector3d vector;
    float matrix[];
    AdjustmentValues adjust;
}
