/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   BirdDriver.java

package ncsa.devices.bird;

import java.io.*;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.*;

public class BirdDriver
{

    public BirdDriver(String s, int i)
    {
        serialPort = null;
        inputStream = null;
        outputStream = null;
        birds = 1;
        CommPortIdentifier commportidentifier = getPortId(s);
        setup(commportidentifier, i);
    }

    public void addEventListener(SerialPortEventListener serialporteventlistener)
    {
        try
        {
            serialPort.addEventListener(serialporteventlistener);
            serialPort.notifyOnDataAvailable(true);
        }
        catch(TooManyListenersException toomanylistenersexception)
        {
            System.out.println("BirdDriver.setup");
            System.out.println(toomanylistenersexception);
        }
    }

    protected void configureFlock()
    {
        byte abyte0[] = new byte[3];
        abyte0[0] = 80;
        abyte0[1] = 50;
        abyte0[2] = (byte)birds;
        write(abyte0);
    }

    public InputStream getInputStream()
    {
        return inputStream;
    }

    protected CommPortIdentifier getPortId(String s)
    {
        if(s == null)
            return null;
        for(Enumeration enumeration = CommPortIdentifier.getPortIdentifiers(); enumeration.hasMoreElements();)
        {
            CommPortIdentifier commportidentifier = (CommPortIdentifier)enumeration.nextElement();
            if(commportidentifier.getPortType() == 1 && commportidentifier.getName().equals(s))
                return commportidentifier;
        }

        System.out.println("BIRD_ERROR: could not find port " + s);
        System.out.println("Please change the BirdPort variable in portfolio.properties.");
        return null;
    }

    public byte lsb(float f)
    {
        short word0 = (short)(int)((f / 180F) * 32767F);
        return (byte)(word0 & 0xff);
    }

    public byte msb(float f)
    {
        short word0 = (short)(int)((f / 180F) * 32767F);
        return (byte)(word0 >> 8 & 0xff);
    }

    public void selectBird(int i)
    {
        byte abyte0[] = new byte[1];
        abyte0[0] = (byte)(240 + i);
        write(abyte0);
    }

    protected void sendFilters(boolean flag)
    {
        byte abyte0[] = new byte[4];
        abyte0[0] = 80;
        abyte0[1] = 4;
        abyte0[2] = (byte)(flag ? 0 : 7);
        abyte0[3] = 0;
        write(abyte0);
    }

    protected void sendGroupMode()
    {
        byte abyte0[] = new byte[3];
        abyte0[0] = 80;
        abyte0[1] = 35;
        abyte0[2] = 1;
        write(abyte0);
    }

    protected void sendHemisphere(String s)
    {
        byte abyte0[] = new byte[3];
        abyte0[0] = 76;
        if(s.equalsIgnoreCase("FRONT"))
        {
            abyte0[1] = 0;
            abyte0[2] = 0;
        }
        if(s.equalsIgnoreCase("AFT"))
        {
            abyte0[1] = 0;
            abyte0[2] = 1;
        }
        if(s.equalsIgnoreCase("UPPER"))
        {
            abyte0[1] = 12;
            abyte0[2] = 1;
        }
        if(s.equalsIgnoreCase("LOWER"))
        {
            abyte0[1] = 12;
            abyte0[2] = 0;
        }
        if(s.equalsIgnoreCase("LEFT"))
        {
            abyte0[1] = 6;
            abyte0[2] = 1;
        }
        if(s.equalsIgnoreCase("RIGHT"))
        {
            abyte0[1] = 6;
            abyte0[2] = 0;
        }
        write(abyte0);
    }

    public void sendPositionAngles()
    {
        byte abyte0[] = new byte[1];
        abyte0[0] = 89;
        write(abyte0);
    }

    public void sendPositionMatrix()
    {
        byte abyte0[] = new byte[1];
        abyte0[0] = 90;
        write(abyte0);
    }

    public void sendReferenceFrame(float f, float f1, float f2)
    {
        byte abyte0[] = new byte[7];
        abyte0[0] = 114;
        byte byte0 = msb(f2);
        byte byte1 = lsb(f2);
        byte _tmp = byte0;
        abyte0[1] = (byte)(0 | byte1 >> 2 | 0x80);
        abyte0[2] = (byte)(byte0 >> 1);
        byte0 = msb(f1);
        byte1 = lsb(f1);
        byte _tmp1 = byte0;
        abyte0[3] = (byte)(0 | byte1 >> 2);
        abyte0[4] = (byte)(byte0 >> 1);
        byte0 = msb(f);
        byte1 = lsb(f);
        byte _tmp2 = byte0;
        abyte0[5] = (byte)(0 | byte1 >> 2);
        abyte0[6] = (byte)(byte0 >> 1);
        write(abyte0);
    }

    public void sendReferenceFrameXYZ(boolean flag)
    {
        byte abyte0[] = new byte[3];
        abyte0[0] = 80;
        abyte0[1] = 17;
        abyte0[2] = 1;
        write(abyte0);
    }

    protected void sendReportRate(int i)
    {
        byte abyte0[] = new byte[1];
        switch(i)
        {
        case 2: // '\002'
            abyte0[0] = 82;
            break;

        case 8: // '\b'
            abyte0[0] = 83;
            break;

        case 32: // ' '
            abyte0[0] = 84;
            break;

        default:
            abyte0[0] = 81;
            break;
        }
        write(abyte0);
    }

    protected void sendStreamMode()
    {
        byte abyte0[] = new byte[1];
        abyte0[0] = 64;
        write(abyte0);
    }

    public void setFilters(boolean flag)
    {
        sendFilters(flag);
    }

    public void setGroupMode(int i)
    {
        birds = i;
        sendGroupMode();
        configureFlock();
    }

    public void setHemisphere(String s)
    {
        for(int i = 0; i < birds; i++)
        {
            selectBird(i + 1);
            sendHemisphere(s);
        }

    }

    public void setPositionAngles()
    {
        for(int i = 0; i < birds; i++)
        {
            selectBird(i + 1);
            sendPositionAngles();
        }

    }

    public void setPositionMatrix()
    {
        for(int i = 0; i < birds; i++)
        {
            selectBird(i + 1);
            sendPositionMatrix();
        }

    }

    public void setReportRate(int i)
    {
        selectBird(1);
        sendReportRate(i);
    }

    public void setStreamMode()
    {
        selectBird(1);
        sendStreamMode();
    }

    protected void setup(CommPortIdentifier commportidentifier, int i)
    {
        try
        {
            serialPort = (SerialPort)commportidentifier.open("BirdDriver", 2000);
            inputStream = serialPort.getInputStream();
            outputStream = serialPort.getOutputStream();
            serialPort.setSerialPortParams(i, 8, 1, 0);
        }
        catch(IOException ioexception)
        {
            System.out.println("BirdDriver.setup(CommPortIdentifier)");
            System.out.println(ioexception);
        }
        catch(PortInUseException portinuseexception)
        {
            System.out.println("BirdDriver.setup PORT IN USE");
            System.out.println(portinuseexception);
        }
        catch(UnsupportedCommOperationException unsupportedcommoperationexception)
        {
            System.out.println("BirdDriver.setup");
            System.out.println(unsupportedcommoperationexception);
        }
    }

    protected void write(byte abyte0[])
    {
        try
        {
            outputStream.write(abyte0);
            outputStream.flush();
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
            Thread.dumpStack();
        }
    }

    SerialPort serialPort;
    InputStream inputStream;
    OutputStream outputStream;
    int birds;
}
