/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Generic2DInputDevice.java

package ncsa.devices.generic2d;

import java.io.PrintStream;
import java.util.Properties;
import javax.media.j3d.*;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ncsa.devices.*;
import ncsa.j3d.ui.PortfolioProperties;

public class Generic2DInputDevice extends NCSAInputDevice
{

    public Generic2DInputDevice()
    {
        input = null;
        transform = new Transform3D();
        vector = new Vector3f();
        rotation = new Vector3f();
        mode = false;
    }

    protected boolean buttonTransition(int i)
    {
        if(lastbuttons == null)
            return false;
        else
            return super.buttons[0][i] != lastbuttons[i];
    }

    protected void computeXY()
    {
        if(mode)
            rotateXY();
        else
            translateXY();
    }

    protected void computeZ()
    {
        if(mode)
            rotateZ();
        else
            translateZ();
    }

    protected void maintainButtonList()
    {
        if(lastbuttons == null || super.buttons[0].length != lastbuttons.length)
            lastbuttons = new int[super.buttons[0].length];
        for(int i = 0; i < super.buttons[0].length; i++)
            lastbuttons[i] = super.buttons[0][i];

    }

    public void pollAndProcessInput()
    {
        setButtons(0, input.getButtons());
        if(buttonTransition(0) || buttonTransition(1))
            vector.set(input.getVector3f());
        if(buttonTransition(2) && super.buttons[0][2] != 0)
            mode = mode ^ true;
        if(super.buttons[0][0] != 0)
            computeXY();
        if(super.buttons[0][1] != 0)
            computeZ();
        maintainButtonList();
        super.sensorReads[0].setTime(System.currentTimeMillis());
        super.sensorReads[0].set(transform);
        super.sensorReads[0].setButtons(super.buttons[0]);
        super.sensors[0].setNextSensorRead(super.sensorReads[0]);
    }

    public void portfolioDeviceInitializing()
    {
        adjust = new AdjustmentValues(this);
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        Object obj = portfolioproperties.getObject(super.name + ".Input");
        if(obj == null)
        {
            System.out.println("Generic2DInputDevice: NOT PROPERLY CONSTRUCTED.");
            System.out.print("Please define " + super.name + ".Input in ");
            System.out.println("portfolio.properties file.");
            return;
        }
        if(obj instanceof Fake2DInputDevice)
        {
            input = (Fake2DInputDevice)obj;
            int ai[] = input.getButtons();
            if(ai.length > super.buttons[0].length)
                buildSensorWithButtons(0, ai.length);
        } else
        {
            System.out.println("Generic2DInputDevice: NOT PROPERLY CONSTRUCTED.");
            System.out.println(portfolioproperties.getProperty(super.name + ".Input") + " does not" + " implement ncsa.devices.Fake2DInputDevice");
        }
    }

    protected void rotateXY()
    {
        Vector3f vector3f = new Vector3f(input.getVector3f());
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f.sub(vector);
        vector3f.z = ((Tuple3f) (vector3f)).x;
        vector3f.x = ((Tuple3f) (vector3f)).y;
        vector3f.y = ((Tuple3f) (vector3f)).z;
        vector3f.z = 0.0F;
        adjust.applyR(vector3f);
        rotation.add(vector3f);
        transform.get(vector3f1);
        setRotation();
        transform.setTranslation(vector3f1);
        vector = vector3f2;
    }

    protected void rotateZ()
    {
        Vector3f vector3f = new Vector3f(input.getVector3f());
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f.sub(vector);
        vector3f.z = ((Tuple3f) (vector3f)).x;
        vector3f.x = 0.0F;
        vector3f.y = 0.0F;
        adjust.applyR(vector3f);
        rotation.add(vector3f);
        transform.get(vector3f1);
        setRotation();
        transform.setTranslation(vector3f1);
        vector = vector3f2;
    }

    protected void setRotation()
    {
        Transform3D transform3d = new Transform3D();
        transform.setIdentity();
        transform3d.rotX(((Tuple3f) (rotation)).x);
        transform.mul(transform3d);
        transform3d.rotY(((Tuple3f) (rotation)).y);
        transform.mul(transform3d);
        transform3d.rotZ(((Tuple3f) (rotation)).z);
        transform.mul(transform3d);
    }

    protected void translateXY()
    {
        Vector3f vector3f = new Vector3f(input.getVector3f());
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f.sub(vector);
        adjust.apply(vector3f);
        transform.get(vector3f1);
        vector3f.add(vector3f1);
        transform.setTranslation(vector3f);
        vector = vector3f2;
    }

    protected void translateZ()
    {
        Vector3f vector3f = new Vector3f(input.getVector3f());
        Vector3f vector3f1 = new Vector3f();
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f.sub(vector);
        vector3f.x = 0.0F;
        vector3f.z = ((Tuple3f) (vector3f)).y;
        vector3f.y = 0.0F;
        adjust.apply(vector3f);
        transform.get(vector3f1);
        vector3f.add(vector3f1);
        transform.setTranslation(vector3f);
        vector = vector3f2;
    }

    Fake2DInputDevice input;
    Transform3D transform;
    Vector3f vector;
    Vector3f rotation;
    int lastbuttons[];
    boolean mode;
    AdjustmentValues adjust;
}
