/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PCJoystickDevice.java

package ncsa.devices.joystick;

import java.io.PrintStream;
import javax.media.j3d.*;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ncsa.devices.Fake2DInputDevice;

public class PCJoystickDevice
    implements InputDevice, Runnable, Fake2DInputDevice
{

    public PCJoystickDevice()
    {
        rotationScale = 1.570796F;
        translationScale = 25F;
        transform = new Transform3D();
        working = new Transform3D();
        sensorRead = new SensorRead();
        vector = new Vector3f();
        button = new int[8];
        sensor = new Sensor(this, 30, 8);
        sensorRead = new SensorRead(8);
        thread = new Thread(this);
        thread.start();
    }

    public native void close();

    protected void computeTransform()
    {
        float f = -(((float)getR() - 32736F) / 32736F) * rotationScale;
        transform.rotY(f);
        Vector3f vector3f = getVector3f();
        vector3f.x = ((((Tuple3f) (vector3f)).x - 32736F) / 32736F) * translationScale;
        vector3f.y = -((((Tuple3f) (vector3f)).y - 32736F) / 32736F) * translationScale;
        vector3f.z = ((((Tuple3f) (vector3f)).z - 32736F) / 32736F + 0.5F) * translationScale;
        transform.setTranslation(vector3f);
    }

    protected int getButton()
    {
        return buttons;
    }

    public int[] getButtons()
    {
        button[0] = (buttons & 1) == 0 ? 0 : 1;
        button[1] = (buttons & 2) == 0 ? 0 : 1;
        button[2] = (buttons & 4) == 0 ? 0 : 1;
        button[3] = (buttons & 8) == 0 ? 0 : 1;
        button[4] = (buttons & 0x10) == 0 ? 0 : 1;
        button[5] = (buttons & 0x20) == 0 ? 0 : 1;
        button[6] = (buttons & 0x40) == 0 ? 0 : 1;
        button[7] = (buttons & 0x80) == 0 ? 0 : 1;
        return button;
    }

    protected int getPOV()
    {
        return pov;
    }

    public int getProcessingMode()
    {
        return 5;
    }

    protected int getR()
    {
        return r;
    }

    public Sensor getSensor(int i)
    {
        return sensor;
    }

    public int getSensorCount()
    {
        return 1;
    }

    protected int getU()
    {
        return u;
    }

    protected int getV()
    {
        return v;
    }

    public Vector3f getVector3f()
    {
        vector.x = x;
        vector.y = y;
        vector.z = z;
        return vector;
    }

    protected int getX()
    {
        return x;
    }

    protected int getY()
    {
        return y;
    }

    protected int getZ()
    {
        return z;
    }

    public boolean initialize()
    {
        return true;
    }

    public static void main(String args[])
    {
        PCJoystickDevice pcjoystickdevice = new PCJoystickDevice();
        do
        {
            try
            {
                Thread.sleep(0L);
            }
            catch(Exception exception)
            {
                System.out.println(exception);
            }
            System.out.println(pcjoystickdevice.getX() + " " + pcjoystickdevice.getY() + " " + pcjoystickdevice.getZ() + " " + pcjoystickdevice.getR() + " " + pcjoystickdevice.getU() + " " + pcjoystickdevice.getV() + " " + pcjoystickdevice.getPOV() + " " + pcjoystickdevice.getButton());
        } while(true);
    }

    public final void pollAndProcessInput()
    {
        computeTransform();
        sensorRead.setTime(System.currentTimeMillis());
        sensorRead.setButtons(getButtons());
        sensorRead.set(transform);
        sensor.setNextSensorRead(sensorRead);
    }

    public native void process();

    public void processStreamInput()
    {
    }

    public void run()
    {
        process();
    }

    public void setNominalPositionAndOrientation()
    {
    }

    public void setProcessingMode(int i)
    {
    }

    public void shutdown()
    {
    }

    protected Thread thread;
    public int x;
    public int y;
    public int z;
    public int r;
    public int u;
    public int v;
    public int pov;
    public int buttons;
    public float rotationScale;
    public float translationScale;
    public final int BUTTONS = 8;
    final float MAX_VALUE = 65472F;
    final float CENTER = 32736F;
    final float zero = 512F;
    protected Transform3D transform;
    protected Transform3D working;
    protected Sensor sensor;
    protected SensorRead sensorRead;
    protected Vector3f vector;
    protected int button[];

    static 
    {
        System.loadLibrary("ncsapcjoystick");
    }
}
