/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MouseDevice.java

package ncsa.devices.mouse;

import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ncsa.devices.Fake2DInputDevice;
import ncsa.j3d.ui.events.*;

public class MouseDevice
    implements PortfolioEventReceiver, Fake2DInputDevice
{

    public MouseDevice()
    {
        buttons = new int[3];
        vector = new Vector3f();
        EventManager eventmanager = EventManager.instance();
        eventmanager.addBehavior(new MouseDown(this));
        eventmanager.addBehavior(new MouseDrag(this));
        eventmanager.addBehavior(new MouseUp(this));
    }

    protected int buttonState(MouseEvent mouseevent)
    {
        return mouseevent.getID() != 501 && mouseevent.getID() != 506 ? 0 : 1;
    }

    public int[] getButtons()
    {
        return buttons;
    }

    public Vector3f getVector3f()
    {
        return vector;
    }

    protected boolean left(MouseEvent mouseevent)
    {
        return (0x10 & mouseevent.getModifiers()) > 0;
    }

    protected boolean middle(MouseEvent mouseevent)
    {
        return (8 & mouseevent.getModifiers()) > 0;
    }

    public boolean notify(EventObject eventobject)
    {
        if(eventobject instanceof MouseEvent)
        {
            MouseEvent mouseevent = (MouseEvent)eventobject;
            vector.x = mouseevent.getX();
            vector.y = mouseevent.getY();
            vector.z = 0.0F;
            buttons[0] = left(mouseevent) ? buttonState(mouseevent) : 0;
            buttons[1] = middle(mouseevent) ? buttonState(mouseevent) : 0;
            buttons[2] = right(mouseevent) ? buttonState(mouseevent) : 0;
            return true;
        } else
        {
            return false;
        }
    }

    protected boolean right(MouseEvent mouseevent)
    {
        return (4 & mouseevent.getModifiers()) > 0;
    }

    public static final int MAX_BUTTONS = 3;
    int buttons[];
    Vector3f vector;
}
