/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SpaceOrb.java

package ncsa.devices.spaceorb;

import javax.media.j3d.*;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

// Referenced classes of package ncsa.devices.spaceorb:
//            OrbData, SpaceOrbDriver

public class SpaceOrb
    implements InputDevice
{

    public SpaceOrb()
    {
        this("/dev/term/a");
    }

    public SpaceOrb(String s)
    {
        processingMode = 5;
        transform = new Transform3D();
        working = new Transform3D();
        vector = new Vector3d();
        buts = new int[BUTTONS];
        rotationScale = 1.0F;
        positionScale = 512F;
        sensor = new Sensor(this, 20, BUTTONS);
        sensorRead = new SensorRead(BUTTONS);
        driver = new SpaceOrbDriver(s);
        driver.addEventListener(driver);
        driver.begin();
    }

    public void close()
    {
    }

    public int getProcessingMode()
    {
        return processingMode;
    }

    public Sensor getSensor(int i)
    {
        if(i != 0)
            return null;
        else
            return sensor;
    }

    public int getSensorCount()
    {
        return 1;
    }

    public boolean initialize()
    {
        return true;
    }

    public final void pollAndProcessInput()
    {
        transform.setIdentity();
        float f = (float)(3.1415926535897931D / (double)rotationScale);
        vector.x = ((float)driver.handle.rot[0] / 512F) * f;
        vector.y = ((float)driver.handle.rot[1] / 512F) * f;
        vector.z = ((float)driver.handle.rot[2] / 512F) * f;
        working.rotX(((Tuple3d) (vector)).x);
        transform.mul(working);
        working.rotY(((Tuple3d) (vector)).y);
        transform.mul(working);
        working.rotZ(((Tuple3d) (vector)).z);
        transform.mul(working);
        vector.x = (float)driver.handle.trans[0] / positionScale;
        vector.y = (float)driver.handle.trans[1] / positionScale;
        vector.z = (float)driver.handle.trans[2] / positionScale;
        transform.setTranslation(vector);
        buts[0] = (driver.handle.buttons & 1) == 0 ? 0 : 1;
        buts[1] = (driver.handle.buttons & 2) == 0 ? 0 : 1;
        buts[2] = (driver.handle.buttons & 4) == 0 ? 0 : 1;
        buts[3] = (driver.handle.buttons & 8) == 0 ? 0 : 1;
        buts[4] = (driver.handle.buttons & 0x10) == 0 ? 0 : 1;
        buts[5] = (driver.handle.buttons & 0x20) == 0 ? 0 : 1;
        sensorRead.setButtons(buts);
        sensorRead.setTime(System.currentTimeMillis());
        sensorRead.set(transform);
        sensor.setNextSensorRead(sensorRead);
    }

    public void processStreamInput()
    {
    }

    public void setNominalPositionAndOrientation()
    {
    }

    public void setProcessingMode(int i)
    {
    }

    public void setRotationScale(float f)
    {
        rotationScale = f;
    }

    public void setTranslationScale(float f)
    {
        positionScale = f;
    }

    private int processingMode;
    Transform3D transform;
    Transform3D working;
    Vector3d vector;
    static int BUTTONS = 6;
    int buts[];
    Sensor sensor;
    SensorRead sensorRead;
    SpaceOrbDriver driver;
    float rotationScale;
    float positionScale;

}
