/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SpaceOrbDevice.java

package ncsa.devices.spaceorb;

import java.io.PrintStream;
import java.util.Properties;
import javax.media.j3d.*;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import ncsa.devices.AdjustmentValues;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.devices.spaceorb:
//            OrbData, SpaceOrbDriver

public class SpaceOrbDevice extends NCSAInputDevice
{

    public SpaceOrbDevice()
    {
        transform = new Transform3D();
        working = new Transform3D();
        vector = new Vector3d();
        buts = new int[6];
    }

    protected void parseProperties()
    {
        PortfolioProperties portfolioproperties = PortfolioProperties.instance();
        portName = portfolioproperties.getProperty(super.name + ".Port");
        System.out.println("SpaceOrb on port " + portName);
    }

    public final void pollAndProcessInput()
    {
        transform.setIdentity();
        vector.x = (double)((float)driver.handle.rot[0] / 512F) * 3.1415926535897931D;
        vector.y = (double)((float)driver.handle.rot[1] / 512F) * 3.1415926535897931D;
        vector.z = (double)((float)driver.handle.rot[2] / 512F) * 3.1415926535897931D;
        working.rotX(((Tuple3d) (vector)).x);
        transform.mul(working);
        working.rotY(((Tuple3d) (vector)).y);
        transform.mul(working);
        working.rotZ(((Tuple3d) (vector)).z);
        transform.mul(working);
        vector.x = (float)driver.handle.trans[0] / 22F;
        vector.y = (float)driver.handle.trans[1] / 22F;
        vector.z = (float)driver.handle.trans[2] / 22F;
        transform.setTranslation(vector);
        buts[0] = (driver.handle.buttons & 1) == 0 ? 0 : 1;
        buts[1] = (driver.handle.buttons & 2) == 0 ? 0 : 1;
        buts[2] = (driver.handle.buttons & 4) == 0 ? 0 : 1;
        buts[3] = (driver.handle.buttons & 8) == 0 ? 0 : 1;
        buts[4] = (driver.handle.buttons & 0x10) == 0 ? 0 : 1;
        buts[5] = (driver.handle.buttons & 0x20) == 0 ? 0 : 1;
        super.sensorReads[0].setButtons(buts);
        super.sensorReads[0].setTime(System.currentTimeMillis());
        super.sensorReads[0].set(transform);
        super.sensors[0].setNextSensorRead(super.sensorReads[0]);
    }

    public void portfolioDeviceInitializing()
    {
        buildSensorWithButtons(0, 6);
        parseProperties();
        adjust = new AdjustmentValues(super.name, getSensorCount());
        driver = new SpaceOrbDriver(portName);
        driver.addEventListener(driver);
        driver.begin();
    }

    Transform3D transform;
    Transform3D working;
    Vector3d vector;
    AdjustmentValues adjust;
    int buts[];
    SpaceOrbDriver driver;
    String portName;
}
