/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SpaceOrbDriver.java

package ncsa.devices.spaceorb;

import java.io.*;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.*;

// Referenced classes of package ncsa.devices.spaceorb:
//            OrbData

public class SpaceOrbDriver
    implements SerialPortEventListener
{

    public SpaceOrbDriver(String s)
    {
        serialPort = null;
        inputStream = null;
        outputStream = null;
        handle = new OrbData();
        buffer = new byte[1024];
        xorme = new byte[20];
        CommPortIdentifier commportidentifier = getPortId(s);
        setup(commportidentifier);
        setXorme();
    }

    public void addEventListener(SerialPortEventListener serialporteventlistener)
    {
        try
        {
            serialPort.notifyOnDataAvailable(true);
            serialPort.addEventListener(serialporteventlistener);
        }
        catch(TooManyListenersException toomanylistenersexception)
        {
            System.out.println("SpaceOrbDriver.addEventListener");
            System.out.println(toomanylistenersexception);
        }
    }

    public void begin()
    {
        start();
        rezero();
    }

    protected final void figurePackType(int i)
    {
        switch(buffer[i])
        {
        case 17: // '\021'
            handle.bufpos = 0;
            handle.packtype = 0;
            handle.packlen = 1;
            break;

        case 33: // '!'
            handle.bufpos = 0;
            handle.packtype = 82;
            handle.packlen = 83;
            break;

        case 68: // 'D'
            handle.packtype = 68;
            handle.packlen = 12;
            break;

        case 75: // 'K'
            handle.packtype = 75;
            handle.packlen = 5;
            break;

        case 78: // 'N'
            handle.packtype = 78;
            handle.packlen = 3;
            break;

        case 80: // 'P'
            handle.packtype = 80;
            handle.packlen = 4;
            break;

        case 82: // 'R'
            handle.packtype = 82;
            handle.packlen = 51;
            break;
        }
    }

    public InputStream getInputStream()
    {
        return inputStream;
    }

    protected CommPortIdentifier getPortId(String s)
    {
        if(s == null)
            return null;
        for(Enumeration enumeration = CommPortIdentifier.getPortIdentifiers(); enumeration.hasMoreElements();)
        {
            CommPortIdentifier commportidentifier = (CommPortIdentifier)enumeration.nextElement();
            if(commportidentifier.getPortType() == 1 && commportidentifier.getName().equals(s))
                return commportidentifier;
        }

        System.out.println("SpaceOrbDriver: could not find port " + s);
        return null;
    }

    protected final void handlePackType()
    {
        switch(handle.packtype)
        {
        case 69: // 'E'
        case 70: // 'F'
        case 71: // 'G'
        case 72: // 'H'
        case 73: // 'I'
        case 74: // 'J'
        case 76: // 'L'
        case 77: // 'M'
        case 78: // 'N'
        case 79: // 'O'
        case 80: // 'P'
        case 81: // 'Q'
        default:
            break;

        case 68: // 'D'
            int i = (handle.buf[2] & 0x7f) << 3 | (handle.buf[3] & 0x70) >> 4;
            int l = (handle.buf[3] & 0xf) << 6 | (handle.buf[4] & 0x7e) >> 1;
            int i1 = (handle.buf[4] & 1) << 9 | (handle.buf[5] & 0x7f) << 2 | (handle.buf[6] & 0x60) >> 5;
            int j1 = (handle.buf[6] & 0x1f) << 5 | (handle.buf[7] & 0x7c) >> 2;
            int k1 = (handle.buf[7] & 3) << 8 | (handle.buf[8] & 0x7f) << 1 | (handle.buf[9] & 0x40) >> 6;
            int l1 = (handle.buf[9] & 0x3f) << 4 | (handle.buf[10] & 0x78) >> 3;
            handle.timer = (handle.buf[10] & 7) << 7 | handle.buf[11] & 0x7f;
            handle.trans[0] = (i << 22) >> 22;
            handle.trans[1] = (l << 22) >> 22;
            handle.trans[2] = (i1 << 22) >> 22;
            handle.rot[0] = (j1 << 22) >> 22;
            handle.rot[1] = (k1 << 22) >> 22;
            handle.rot[2] = (l1 << 22) >> 22;
            break;

        case 75: // 'K'
            handle.buttons = handle.buf[2] & 0x7f;
            handle.timer = (handle.buf[1] & 0x7f) << 8 | handle.buf[4] & 0x7f;
            break;

        case 82: // 'R'
            for(int j = 0; j < handle.resetstring.length; j++)
                handle.resetstring[j] = 0;

            for(int k = 0; k < handle.bufpos; k++)
                handle.resetstring[k] = (byte)(handle.buf[k] & 0x7f);

            break;
        }
    }

    public static void main(String args[])
    {
        SpaceOrbDriver spaceorbdriver = new SpaceOrbDriver(args[0]);
        spaceorbdriver.addEventListener(spaceorbdriver);
        spaceorbdriver.begin();
        do
        {
            try
            {
                Thread.sleep(0L);
            }
            catch(Exception exception)
            {
                System.out.println(exception);
            }
            System.out.println(spaceorbdriver.handle.trans[0] + " " + spaceorbdriver.handle.trans[1] + " " + spaceorbdriver.handle.trans[2] + " " + spaceorbdriver.handle.rot[0] + " " + spaceorbdriver.handle.rot[1] + " " + spaceorbdriver.handle.rot[2]);
        } while(true);
    }

    protected void rezero()
    {
        byte abyte0[] = new byte[4];
        abyte0[0] = 10;
        abyte0[1] = 90;
        abyte0[2] = 10;
        abyte0[3] = 0;
        write(abyte0);
    }

    public final void serialEvent(SerialPortEvent serialportevent)
    {
        switch(serialportevent.getEventType())
        {
        default:
            break;

        case 1: // '\001'
            try
            {
                for(; inputStream.available() > 0; update());
                break;
            }
            catch(IOException ioexception)
            {
                System.out.println("WandDriver.serialEvent");
                System.out.println(ioexception);
            }
            break;
        }
    }

    protected void setXorme()
    {
        xorme[0] = 68;
        xorme[1] = 46;
        xorme[2] = 83;
        xorme[3] = 112;
        xorme[4] = 97;
        xorme[5] = 99;
        xorme[6] = 101;
        xorme[7] = 87;
        xorme[8] = 97;
        xorme[9] = 114;
        xorme[10] = 101;
        xorme[11] = 33;
        xorme[12] = 32;
        xorme[13] = 32;
        xorme[14] = 32;
        xorme[15] = 32;
        xorme[16] = 32;
        xorme[17] = 32;
        xorme[18] = 32;
        xorme[19] = 32;
    }

    protected void setup(CommPortIdentifier commportidentifier)
    {
        try
        {
            serialPort = (SerialPort)commportidentifier.open("SpaceOrbDriver", 2000);
            inputStream = serialPort.getInputStream();
            outputStream = serialPort.getOutputStream();
            serialPort.setSerialPortParams(9600, 8, 1, 0);
        }
        catch(IOException ioexception)
        {
            System.out.println("SpaceOrbDriver.setup(CommPortIdentifier)");
            System.out.println(ioexception);
        }
        catch(PortInUseException portinuseexception)
        {
            System.out.println("SpaceOrbDriver.setup PORT IN USE");
            System.out.println(portinuseexception);
        }
        catch(UnsupportedCommOperationException unsupportedcommoperationexception)
        {
            System.out.println("SpaceOrbDriver.setup");
            System.out.println(unsupportedcommoperationexception);
        }
    }

    protected void start()
    {
        byte abyte0[] = new byte[2];
        abyte0[0] = 10;
        abyte0[1] = 0;
        write(abyte0);
    }

    protected void update()
    {
        int i = 0;
        int j;
        try
        {
            j = inputStream.read(buffer);
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
            j = 0;
        }
        if(j < 1)
            return;
        for(int k = 0; k < j; k++)
            if(buffer[k] == 13 && handle.packtype != 82)
            {
                handle.bufpos = 0;
                handle.packtype = 0;
                handle.packlen = 1;
            } else
            {
                if(handle.bufpos == 0)
                    figurePackType(k);
                if(handle.packtype == 68)
                {
                    handle.buf[handle.bufpos] = (byte)(buffer[k] ^ xorme[handle.bufpos]);
                    handle.bufpos++;
                } else
                {
                    handle.buf[handle.bufpos++] = buffer[k];
                }
                if(handle.bufpos == handle.packlen)
                {
                    handlePackType();
                    handle.bufpos = 0;
                    handle.packtype = 0;
                    handle.packlen = 1;
                    i++;
                }
            }

    }

    protected void write(byte abyte0[])
    {
        try
        {
            outputStream.write(abyte0);
            outputStream.flush();
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
            Thread.dumpStack();
        }
    }

    SerialPort serialPort;
    InputStream inputStream;
    OutputStream outputStream;
    public OrbData handle;
    byte buffer[];
    byte xorme[];
}
