/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ButtonPositionControls.java

package ncsa.devices.virtual;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.media.j3d.InputDevice;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

// Referenced classes of package ncsa.devices.virtual:
//            PositionControls

public class ButtonPositionControls extends Panel
    implements PositionControls, MouseListener
{

    public ButtonPositionControls(float f, float f1, float f2)
    {
        mode = 0;
        position = new Vector3f();
        orig_position = new Vector3f();
        leftB = new Button("Move Left");
        rightB = new Button("Move Right");
        upB = new Button("Move Up");
        downB = new Button("Move Down");
        forwardB = new Button("Move Forward");
        backwardB = new Button("Move Back");
        reset = new Button("Reset");
        step_rate = 0.0023F;
        time_last_state_change = System.currentTimeMillis();
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", upB);
        panel.add("East", rightB);
        panel.add("South", downB);
        panel.add("West", leftB);
        Panel panel1 = new Panel();
        panel1.setLayout(new GridLayout(0, 1, 0, 0));
        panel1.add(forwardB);
        panel1.add(backwardB);
        panel1.add(reset);
        position.x = f;
        position.y = f1;
        position.z = f2;
        orig_position.set(position);
        upB.addMouseListener(this);
        downB.addMouseListener(this);
        leftB.addMouseListener(this);
        rightB.addMouseListener(this);
        forwardB.addMouseListener(this);
        backwardB.addMouseListener(this);
        reset.addMouseListener(this);
        setLayout(new BorderLayout());
        add("East", panel1);
        add("West", panel);
    }

    private void calculateMotion()
    {
        long l = System.currentTimeMillis();
        long l1 = l - time_last_state_change;
        switch(mode)
        {
        case 3: // '\003'
            position.x = ((Tuple3f) (orig_position)).x - step_rate * (float)l1;
            break;

        case 4: // '\004'
            position.x = ((Tuple3f) (orig_position)).x + step_rate * (float)l1;
            break;

        case 1: // '\001'
            position.y = ((Tuple3f) (orig_position)).y + step_rate * (float)l1;
            break;

        case 2: // '\002'
            position.y = ((Tuple3f) (orig_position)).y - step_rate * (float)l1;
            break;

        case 5: // '\005'
            position.z = ((Tuple3f) (orig_position)).z - step_rate * (float)l1;
            break;

        case 6: // '\006'
            position.z = ((Tuple3f) (orig_position)).z + step_rate * (float)l1;
            break;

        default:
            throw new RuntimeException("Unknown motion");

        case 0: // '\0'
            break;
        }
    }

    public void getPosition(Vector3f vector3f)
    {
        calculateMotion();
        vector3f.set(position);
    }

    public void mouseClicked(MouseEvent mouseevent)
    {
    }

    public void mouseEntered(MouseEvent mouseevent)
    {
    }

    public void mouseExited(MouseEvent mouseevent)
    {
    }

    public void mousePressed(MouseEvent mouseevent)
    {
        if(mouseevent.getSource() == leftB && mode != 3)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 3;
            orig_position.set(position);
        } else
        if(mouseevent.getSource() == rightB && mode != 4)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 4;
            orig_position.set(position);
        } else
        if(mouseevent.getSource() == upB && mode != 1)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 1;
            orig_position.set(position);
        } else
        if(mouseevent.getSource() == downB && mode != 2)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 2;
            orig_position.set(position);
        } else
        if(mouseevent.getSource() == forwardB && mode != 5)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 5;
            orig_position.set(position);
        } else
        if(mouseevent.getSource() == backwardB && mode != 6)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 6;
            orig_position.set(position);
        } else
        if(mouseevent.getSource() == reset)
            device.setNominalPositionAndOrientation();
    }

    public void mouseReleased(MouseEvent mouseevent)
    {
        mode = 0;
    }

    public void setDevice(InputDevice inputdevice)
    {
        device = inputdevice;
    }

    public void setPosition(Vector3f vector3f)
    {
        position.set(vector3f);
    }

    public void setStepRate(float f)
    {
        step_rate = f;
    }

    private static final int STILL = 0;
    private static final int MOVING_UP = 1;
    private static final int MOVING_DOWN = 2;
    private static final int MOVING_LEFT = 3;
    private static final int MOVING_RIGHT = 4;
    private static final int MOVING_FORWARD = 5;
    private static final int MOVING_BACK = 6;
    private int mode;
    Vector3f position;
    Vector3f orig_position;
    private Button leftB;
    private Button rightB;
    private Button upB;
    private Button downB;
    private Button forwardB;
    private Button backwardB;
    private Button reset;
    private InputDevice device;
    private float step_rate;
    private long time_last_state_change;
}
