/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ButtonRotationControls.java

package ncsa.devices.virtual;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.media.j3d.InputDevice;

// Referenced classes of package ncsa.devices.virtual:
//            RotationControls

public class ButtonRotationControls extends Panel
    implements RotationControls, MouseListener
{

    public ButtonRotationControls(float f, float f1, float f2)
    {
        mode = 0;
        XP = new Button("X+");
        XM = new Button("X-");
        YP = new Button("Y+");
        YM = new Button("Y-");
        ZP = new Button("Z+");
        ZM = new Button("Z-");
        step_rate = 0.001F;
        time_last_state_change = System.currentTimeMillis();
        setLayout(new GridLayout(3, 2));
        add(XP);
        add(XM);
        add(YP);
        add(YM);
        add(ZP);
        add(ZM);
        x = f;
        y = f1;
        z = f2;
        XP.addMouseListener(this);
        XM.addMouseListener(this);
        YP.addMouseListener(this);
        YM.addMouseListener(this);
        ZP.addMouseListener(this);
        ZM.addMouseListener(this);
    }

    public float getXAngle()
    {
        return x;
    }

    public float getYAngle()
    {
        return y;
    }

    public float getZAngle()
    {
        return z;
    }

    public void mouseClicked(MouseEvent mouseevent)
    {
    }

    public void mouseEntered(MouseEvent mouseevent)
    {
    }

    public void mouseExited(MouseEvent mouseevent)
    {
    }

    public void mousePressed(MouseEvent mouseevent)
    {
        if(mouseevent.getSource() == XP && mode != 1)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 1;
            tx = x;
        } else
        if(mouseevent.getSource() == XM && mode != 2)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 2;
            tx = x;
        } else
        if(mouseevent.getSource() == YP && mode != 3)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 3;
            ty = y;
        } else
        if(mouseevent.getSource() == YM && mode != 4)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 4;
            ty = y;
        } else
        if(mouseevent.getSource() == ZP && mode != 5)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 5;
            tz = z;
        } else
        if(mouseevent.getSource() == ZM && mode != 6)
        {
            time_last_state_change = System.currentTimeMillis();
            mode = 6;
            tz = z;
        }
    }

    public void mouseReleased(MouseEvent mouseevent)
    {
        mode = 0;
    }

    public void reset()
    {
        x = y = z = 0.0F;
    }

    public void setDevice(InputDevice inputdevice)
    {
        device = inputdevice;
    }

    public void setStepRate(float f)
    {
        step_rate = f;
    }

    public void update()
    {
        long l = System.currentTimeMillis();
        long l1 = l - time_last_state_change;
        switch(mode)
        {
        case 2: // '\002'
            x = tx - step_rate * (float)l1;
            break;

        case 1: // '\001'
            x = tx + step_rate * (float)l1;
            break;

        case 3: // '\003'
            y = ty + step_rate * (float)l1;
            break;

        case 4: // '\004'
            y = ty - step_rate * (float)l1;
            break;

        case 6: // '\006'
            z = tz - step_rate * (float)l1;
            break;

        case 5: // '\005'
            z = tz + step_rate * (float)l1;
            break;

        default:
            throw new RuntimeException("Unknown motion");

        case 0: // '\0'
            break;
        }
    }

    private static final int STILL = 0;
    private static final int ROTXP = 1;
    private static final int ROTXM = 2;
    private static final int ROTYP = 3;
    private static final int ROTYM = 4;
    private static final int ROTZP = 5;
    private static final int ROTZM = 6;
    private int mode;
    protected float x;
    protected float y;
    protected float z;
    protected float tx;
    protected float ty;
    protected float tz;
    private Button XP;
    private Button XM;
    private Button YP;
    private Button YM;
    private Button ZP;
    private Button ZM;
    private InputDevice device;
    private float step_rate;
    private long time_last_state_change;
}
