/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   VirtualInputDevice.java

package ncsa.devices.virtual;

import java.awt.*;
import javax.media.j3d.*;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ncsa.devices.*;

// Referenced classes of package ncsa.devices.virtual:
//            ButtonButtonControls, ButtonPositionControls, ButtonRotationControls, PositionControls

public class VirtualInputDevice extends NCSAInputDevice
    implements AdjustableInterface, ValuesWithRotation
{

    public VirtualInputDevice()
    {
        this("VirtualInputDevice", 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F);
    }

    public VirtualInputDevice(String s, float f, float f1, float f2, float f3, float f4, float f5)
    {
        data = new float[6];
        vector = new Vector3f();
        working = new Transform3D();
        temp = new Transform3D();
        _x = f;
        _y = f1;
        _z = f2;
        _xr = f3;
        _yr = f4;
        _zr = f5;
    }

    public AdjustmentInterface getAdjustmentInterface()
    {
        return adjust;
    }

    public float getX(int i)
    {
        return ((Tuple3f) (vector)).x;
    }

    public float getXR(int i)
    {
        return xrot;
    }

    public float getY(int i)
    {
        return ((Tuple3f) (vector)).y;
    }

    public float getYR(int i)
    {
        return yrot;
    }

    public float getZ(int i)
    {
        return ((Tuple3f) (vector)).z;
    }

    public float getZR(int i)
    {
        return zrot;
    }

    public void pollAndProcessInput()
    {
        rotationControls.update();
        positionControls.getPosition(vector);
        vector.x *= adjust.getPositionScale();
        vector.x = adjust.getInversion(0, 0) ? -((Tuple3f) (vector)).x : ((Tuple3f) (vector)).x;
        vector.x += adjust.getOffset(0, 0);
        vector.y *= adjust.getPositionScale();
        vector.y = adjust.getInversion(0, 1) ? -((Tuple3f) (vector)).y : ((Tuple3f) (vector)).y;
        vector.y += adjust.getOffset(0, 1);
        vector.z *= adjust.getPositionScale();
        vector.z = adjust.getInversion(0, 2) ? -((Tuple3f) (vector)).z : ((Tuple3f) (vector)).z;
        vector.z += adjust.getOffset(0, 2);
        temp.set(vector);
        xrot = rotationControls.getXAngle();
        xrot = adjust.getInversion(0, 3) ? -xrot : xrot;
        xrot = xrot * adjust.getRotationScale() + adjust.getOffset(0, 3);
        working.rotX(xrot);
        temp.mul(working);
        yrot = rotationControls.getYAngle();
        yrot = adjust.getInversion(0, 4) ? -yrot : yrot;
        yrot = yrot * adjust.getRotationScale() + adjust.getOffset(0, 4);
        working.rotY(yrot);
        temp.mul(working);
        zrot = rotationControls.getZAngle();
        zrot = adjust.getInversion(0, 5) ? -zrot : zrot;
        zrot = zrot * adjust.getRotationScale() + adjust.getOffset(0, 5);
        working.rotZ(zrot);
        temp.mul(working);
        super.sensorReads[0].setTime(System.currentTimeMillis());
        super.sensorReads[0].set(temp);
        super.sensors[0].setNextSensorRead(super.sensorReads[0]);
    }

    public void portfolioDeviceInitializing()
    {
        Frame frame = new Frame();
        frame.setTitle(super.name);
        ButtonPositionControls buttonpositioncontrols = new ButtonPositionControls(_x, _y, _z);
        rotationControls = new ButtonRotationControls(_xr, _yr, _zr);
        buttonpositioncontrols.setDevice(this);
        buttonControls = new ButtonButtonControls(super.buttons[0].length, super.sensorReads[0]);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("East", buttonpositioncontrols);
        panel.add("West", rotationControls);
        panel.add("North", buttonControls);
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
        adjust = new AdjustmentValues(super.name, getSensorCount());
        positionControls = buttonpositioncontrols;
    }

    private PositionControls positionControls;
    private ButtonRotationControls rotationControls;
    private ButtonButtonControls buttonControls;
    float data[];
    Vector3f vector;
    float xrot;
    float yrot;
    float zrot;
    Transform3D working;
    Transform3D temp;
    AdjustmentValues adjust;
    float _x;
    float _y;
    float _z;
    float _xr;
    float _yr;
    float _zr;
}
