/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   WheelControls.java

package ncsa.devices.virtual;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.AffineTransform;
import java.util.EventObject;

// Referenced classes of package ncsa.devices.virtual:
//            RotationControls

public class WheelControls extends Canvas
    implements RotationControls, MouseMotionListener, MouseListener
{

    public WheelControls()
    {
        this(0.0F, 0.0F, 0.0F);
    }

    public WheelControls(float f, float f1, float f2)
    {
        mode = 0;
        oldMousePos = new Point();
        yAngle = 0.0F;
        xAngle = 0.0F;
        zAngle = 0.0F;
        angleStep = 0.1047198F;
        size = new Dimension(200, 200);
        xAngle = constrainAngle(f);
        yAngle = constrainAngle(f1);
        zAngle = constrainAngle(f2);
        yOrigAngle = yAngle;
        xOrigAngle = xAngle;
        zOrigAngle = zAngle;
        setSizes();
        yPip = new Polygon();
        yPip.addPoint(0, 0);
        yPip.addPoint(-pipSize / 2, pipSize);
        yPip.addPoint(pipSize / 2, pipSize);
        xPip = new Polygon();
        xPip.addPoint(0, 0);
        xPip.addPoint(pipSize, -pipSize / 2);
        xPip.addPoint(pipSize, pipSize / 2);
        zPip = new Polygon();
        zPip.addPoint(diameter / 2, pipOffset);
        zPip.addPoint(diameter / 2 - pipSize / 2, pipOffset - pipSize);
        zPip.addPoint(diameter / 2 + pipSize / 2, pipOffset - pipSize);
        addMouseListener(this);
        addMouseMotionListener(this);
    }

    private float constrainAngle(float f)
    {
        if(f > 6.283185F)
            return f - 6.283185F;
        if(f < 0.0F)
            return f + 6.283185F;
        else
            return f;
    }

    private void drawXPip(Graphics2D graphics2d, float f)
    {
        AffineTransform affinetransform = new AffineTransform();
        int j = margin + diameter + space;
        int k = margin;
        Color color = graphics2d.getColor();
        int i;
        if((double)f <= 3.1415926535897931D)
            i = (k + diameter) - (int)(((Math.abs((double)f - 1.5707963267948966D) / 1.5707963267948966D) * (double)diameter) / 2D);
        else
            i = k + (int)(((Math.abs((double)f - 4.7123889803846897D) / 1.5707963267948966D) * (double)diameter) / 2D);
        if((double)f < 1.5707963267948966D || (double)f > 4.7123889803846897D)
        {
            graphics2d.setColor(Color.red);
        } else
        {
            graphics2d.setColor(Color.black);
            graphics2d.setClip(xBackClip);
        }
        graphics2d.setXORMode(getBackground());
        affinetransform.setToTranslation(j + pipOffset, i);
        graphics2d.setTransform(affinetransform);
        graphics2d.fillPolygon(xPip);
        affinetransform.setToIdentity();
        graphics2d.setTransform(affinetransform);
        graphics2d.setColor(color);
        graphics2d.setPaintMode();
    }

    private void drawYPip(Graphics2D graphics2d, float f)
    {
        AffineTransform affinetransform = new AffineTransform();
        int j = margin;
        int k = margin + diameter + space;
        Color color = graphics2d.getColor();
        int i;
        if((double)f <= 3.1415926535897931D)
            i = (j + diameter) - (int)(((Math.abs((double)f - 1.5707963267948966D) / 1.5707963267948966D) * (double)diameter) / 2D);
        else
            i = j + (int)(((Math.abs((double)f - 4.7123889803846897D) / 1.5707963267948966D) * (double)diameter) / 2D);
        if((double)f < 1.5707963267948966D || (double)f > 4.7123889803846897D)
        {
            graphics2d.setColor(Color.red);
        } else
        {
            graphics2d.setColor(Color.black);
            graphics2d.setClip(yBackClip);
        }
        graphics2d.setXORMode(getBackground());
        affinetransform.setToTranslation(i, k + pipOffset);
        graphics2d.setTransform(affinetransform);
        graphics2d.fillPolygon(yPip);
        affinetransform.setToIdentity();
        graphics2d.setTransform(affinetransform);
        graphics2d.setColor(color);
        graphics2d.setPaintMode();
    }

    private void drawZPip(Graphics2D graphics2d, float f)
    {
        AffineTransform affinetransform = new AffineTransform();
        Color color = graphics2d.getColor();
        affinetransform.translate(margin, margin);
        affinetransform.rotate(f, diameter / 2, diameter / 2);
        graphics2d.setXORMode(getBackground());
        graphics2d.setTransform(affinetransform);
        graphics2d.setColor(Color.red);
        graphics2d.fillPolygon(zPip);
        affinetransform.setToIdentity();
        graphics2d.setTransform(affinetransform);
        graphics2d.setColor(color);
        graphics2d.setPaintMode();
    }

    public Dimension getPreferredSize()
    {
        return size;
    }

    public float getXAngle()
    {
        return xAngle;
    }

    public float getYAngle()
    {
        return yAngle;
    }

    public float getZAngle()
    {
        return zAngle;
    }

    public void mouseClicked(MouseEvent mouseevent)
    {
    }

    public void mouseDragged(MouseEvent mouseevent)
    {
        Point point = mouseevent.getPoint();
        int i = point.x - oldMousePos.x;
        int j = point.y - oldMousePos.y;
        switch(mode)
        {
        case 0: // '\0'
            break;

        case 1: // '\001'
            drawYPip((Graphics2D)((Canvas)mouseevent.getSource()).getGraphics(), yAngle);
            if(i < 0)
                yAngle -= angleStep;
            else
            if(i > 0)
                yAngle += angleStep;
            yAngle = constrainAngle(yAngle);
            drawYPip((Graphics2D)((Canvas)mouseevent.getSource()).getGraphics(), yAngle);
            oldMousePos = point;
            break;

        case 2: // '\002'
            drawXPip((Graphics2D)((Canvas)mouseevent.getSource()).getGraphics(), xAngle);
            if(j < 0)
                xAngle -= angleStep;
            else
            if(j > 0)
                xAngle += angleStep;
            xAngle = constrainAngle(xAngle);
            drawXPip((Graphics2D)((Canvas)mouseevent.getSource()).getGraphics(), xAngle);
            oldMousePos = point;
            break;

        case 3: // '\003'
            drawZPip((Graphics2D)((Canvas)mouseevent.getSource()).getGraphics(), zAngle);
            if(i < 0)
                zAngle -= angleStep;
            else
            if(i > 0)
                zAngle += angleStep;
            zAngle = constrainAngle(zAngle);
            drawZPip((Graphics2D)((Canvas)mouseevent.getSource()).getGraphics(), zAngle);
            oldMousePos = point;
            break;

        default:
            throw new RuntimeException("Internal Error");
        }
    }

    public void mouseEntered(MouseEvent mouseevent)
    {
    }

    public void mouseExited(MouseEvent mouseevent)
    {
    }

    public void mouseMoved(MouseEvent mouseevent)
    {
    }

    public void mousePressed(MouseEvent mouseevent)
    {
        if(yArea.contains(mouseevent.getPoint()))
        {
            mode = 1;
            oldMousePos = mouseevent.getPoint();
        } else
        if(xArea.contains(mouseevent.getPoint()))
        {
            mode = 2;
            oldMousePos = mouseevent.getPoint();
        } else
        if(zArea.contains(mouseevent.getPoint()))
        {
            mode = 3;
            oldMousePos = mouseevent.getPoint();
        }
    }

    public void mouseReleased(MouseEvent mouseevent)
    {
        mode = 0;
    }

    public void paint(Graphics g)
    {
        Graphics2D graphics2d = (Graphics2D)g;
        g.drawOval(margin, margin, diameter, diameter);
        zArea = new Rectangle(margin, margin, diameter, diameter);
        drawZPip(graphics2d, zAngle);
        g.drawRect(margin, margin + diameter + space, diameter, thickness);
        yArea = new Rectangle(margin, margin + diameter + space, margin + diameter, thickness + pipOffset);
        yBackClip = new Rectangle(margin - thickness, margin + diameter + space + thickness, margin + diameter + thickness * 2, thickness);
        drawYPip(graphics2d, yAngle);
        g.drawRect(margin + diameter + space, margin, thickness, diameter);
        xArea = new Rectangle(margin + diameter + space, margin, thickness + pipOffset, margin + diameter);
        xBackClip = new Rectangle(margin + diameter + space + thickness, margin - thickness, thickness, margin + diameter + thickness * 2);
        drawXPip(graphics2d, xAngle);
    }

    public void reset()
    {
        drawYPip((Graphics2D)getGraphics(), yAngle);
        yAngle = yOrigAngle;
        drawYPip((Graphics2D)getGraphics(), yAngle);
        drawXPip((Graphics2D)getGraphics(), xAngle);
        xAngle = xOrigAngle;
        drawXPip((Graphics2D)getGraphics(), xAngle);
        drawZPip((Graphics2D)getGraphics(), zAngle);
        zAngle = zOrigAngle;
        drawZPip((Graphics2D)getGraphics(), zAngle);
        oldMousePos.setLocation(0, 0);
    }

    public void setSize(Dimension dimension)
    {
        if(dimension.width < dimension.height)
            size.width = size.height = dimension.width;
        else
            size.width = size.height = dimension.height;
        setSizes();
    }

    private void setSizes()
    {
        margin = 10;
        int i = size.width - margin * 2;
        thickness = (i * 7) / 100;
        diameter = (i * 70) / 100;
        space = (i * 10) / 100;
        pipSize = (i * 7) / 100;
        pipOffset = thickness / 2;
    }

    private static final int NONE = 0;
    private static final int SLIDE_Y = 1;
    private static final int SLIDE_X = 2;
    private static final int SLIDE_Z = 3;
    private int mode;
    private Dimension size;
    private int thickness;
    private int diameter;
    private int space;
    private int pipSize;
    private int pipOffset;
    private int margin;
    private Polygon yPip;
    private Rectangle yBackClip;
    private Polygon xPip;
    private Rectangle xBackClip;
    private Polygon zPip;
    private Rectangle yArea;
    private Rectangle xArea;
    private Rectangle zArea;
    private Point oldMousePos;
    float yAngle;
    float xAngle;
    float zAngle;
    float yOrigAngle;
    float xOrigAngle;
    float zOrigAngle;
    float angleStep;
}
