/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   WandDriver.java

package ncsa.devices.wand;

import java.io.*;
import java.util.*;
import javax.comm.*;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.ui.PortfolioProperties;

// Referenced classes of package ncsa.devices.wand:
//            WandDevice

public class WandDriver extends NCSAInputDevice
    implements SerialPortEventListener
{

    public WandDriver()
    {
        b = new byte[1];
        BUTTONS = 3;
        VALUATORS = 2;
        numBytes = 0;
        buffer = new byte[30];
        serialPort = null;
        inputStream = null;
    }

    public int button(int i)
    {
        return buttons[i];
    }

    protected CommPortIdentifier getPortId(String s)
    {
        if(s == null)
            return null;
        for(Enumeration enumeration = CommPortIdentifier.getPortIdentifiers(); enumeration.hasMoreElements();)
        {
            CommPortIdentifier commportidentifier = (CommPortIdentifier)enumeration.nextElement();
            if(commportidentifier.getPortType() == 1 && commportidentifier.getName().equals(s))
                return commportidentifier;
        }

        return null;
    }

    public static void main(String args[])
    {
        WandDevice wanddevice = new WandDevice();
        wanddevice.initializePortfolioDevice("WandDriver");
        do
        {
            try
            {
                Thread.sleep(0L);
            }
            catch(Exception _ex) { }
            wanddevice.pollAndProcessInput();
            System.out.print("\r" + wanddevice.button(0) + " " + wanddevice.button(1) + " " + wanddevice.button(2) + " " + wanddevice.valuator(0) + " " + wanddevice.valuator(1) + " " + "                          ");
        } while(true);
    }

    public void portfolioDeviceInitializing()
    {
        buttons = new int[BUTTONS];
        valuators = new float[VALUATORS];
        CommPortIdentifier commportidentifier = getPortId(PortfolioProperties.instance().getProperty(super.name + ".Port"));
        setup(commportidentifier);
    }

    public void process(byte byte0)
    {
        if(numBytes > 0)
        {
            buffer[numBytes++] = byte0;
            if(numBytes == 3)
            {
                valuators[buffer[0] & 7] = (float)((buffer[2] & 0x80) == 0 ? ((double)buffer[2] - 127.5D) / 127.5D : ((double)buffer[2] + 127.5D) / 126.5D);
                numBytes = 0;
            }
        } else
        if(byte0 >= 48 && byte0 <= 56)
        {
            buffer[0] = byte0;
            numBytes = 1;
        } else
        if(byte0 >= -40 && byte0 <= -32)
            buttons[byte0 & 7] = 1;
        else
        if(byte0 >= -8 && byte0 <= 0)
            buttons[byte0 & 7] = 0;
    }

    public void serialEvent(SerialPortEvent serialportevent)
    {
        switch(serialportevent.getEventType())
        {
        default:
            break;

        case 1: // '\001'
            try
            {
                for(; inputStream.available() > 0; process(b[0]))
                    inputStream.read(b);

                break;
            }
            catch(IOException ioexception)
            {
                System.out.println("WandDriver.serialEvent");
                System.out.println(ioexception);
            }
            break;
        }
    }

    protected void setup(CommPortIdentifier commportidentifier)
    {
        try
        {
            serialPort = (SerialPort)commportidentifier.open("WandDriver", 2000);
            inputStream = serialPort.getInputStream();
            serialPort.addEventListener(this);
            serialPort.notifyOnDataAvailable(true);
            serialPort.setSerialPortParams(9600, 8, 1, 0);
        }
        catch(IOException ioexception)
        {
            System.out.println("WandDriver.setup(CommPortIdentifier)");
            System.out.println(ioexception);
        }
        catch(PortInUseException portinuseexception)
        {
            System.out.println("WandDriver.setup PORT IN USE");
            System.out.println(portinuseexception);
        }
        catch(UnsupportedCommOperationException unsupportedcommoperationexception)
        {
            System.out.println("WandDriver.setup");
            System.out.println(unsupportedcommoperationexception);
        }
        catch(TooManyListenersException toomanylistenersexception)
        {
            System.out.println("WandDriver.setup");
            System.out.println(toomanylistenersexception);
        }
    }

    public float valuator(int i)
    {
        return valuators[i];
    }

    protected int buttons[];
    protected float valuators[];
    protected byte b[];
    public int BUTTONS;
    public int VALUATORS;
    int numBytes;
    byte buffer[];
    SerialPort serialPort;
    InputStream inputStream;
}
