/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   CollidableTransformGroup.java

package ncsa.j3d;

import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Vector3f;
import ncsa.j3d.ui.events.CollisionEvent;
import ncsa.j3d.ui.events.PortfolioEventReceiver;

// Referenced classes of package ncsa.j3d:
//            PickableTransformGroup, CollisionDetector

public class CollidableTransformGroup extends PickableTransformGroup
{

    public CollidableTransformGroup(Vector3f vector3f, PortfolioEventReceiver portfolioeventreceiver, String s)
    {
        super(vector3f);
        colsetup(portfolioeventreceiver, s);
    }

    public CollidableTransformGroup(PortfolioEventReceiver portfolioeventreceiver)
    {
        colsetup(portfolioeventreceiver, null);
    }

    public CollidableTransformGroup(PortfolioEventReceiver portfolioeventreceiver, String s)
    {
        colsetup(portfolioeventreceiver, s);
    }

    protected void colsetup(PortfolioEventReceiver portfolioeventreceiver, String s)
    {
        setCapability(0);
        receiver = portfolioeventreceiver;
        description = s;
        cdEnter = new CollisionDetector(this, 1);
        cdExit = new CollisionDetector(this, 3);
    }

    public String getDescription()
    {
        return description;
    }

    public void setDescription(String s)
    {
        description = s;
    }

    public boolean setReceiver(Object obj)
    {
        if(obj instanceof PortfolioEventReceiver)
            receiver = (PortfolioEventReceiver)obj;
        else
            return false;
        return true;
    }

    public void signal(int i)
    {
        if(receiver != null)
            receiver.notify(new CollisionEvent(this, i));
    }

    protected PortfolioEventReceiver receiver;
    protected CollisionDetector cdEnter;
    protected CollisionDetector cdMove;
    protected CollisionDetector cdExit;
    protected String description;
}
