/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MulticastTransformGroup.java

package ncsa.j3d;

import java.io.*;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;
import ncsa.net.MulticastHandler;

// Referenced classes of package ncsa.j3d:
//            PickableTransformGroup, TransformGroupCustomer

public class MulticastTransformGroup extends PickableTransformGroup
{

    public MulticastTransformGroup()
    {
        multiHandler = null;
        transform = new Transform3D();
    }

    public MulticastTransformGroup(Vector3f vector3f)
    {
        super(vector3f);
        multiHandler = null;
        transform = new Transform3D();
    }

    public void apply()
    {
        double ad[] = new double[16];
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        try
        {
            getTransform(transform);
            transform.get(ad);
            for(int i = 0; i < 16; i++)
                dataoutputstream.writeDouble(ad[i]);

            byte abyte0[] = bytearrayoutputstream.toByteArray();
            multiHandler.transmit(abyte0, abyte0.length);
        }
        catch(IOException ioexception)
        {
            System.out.println(ioexception);
            return;
        }
    }

    public void endMulticast()
    {
        if(multiHandler != null)
            multiHandler.end();
        multiHandler = null;
    }

    public void startMulticast(String s, int i)
    {
        TransformGroupCustomer transformgroupcustomer = new TransformGroupCustomer(this);
        multiHandler = new MulticastHandler(s, i, transformgroupcustomer);
        multiHandler.begin();
    }

    MulticastHandler multiHandler;
    Transform3D transform;
}
