/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SimpleTransformGroup.java

package ncsa.j3d;

import javax.media.j3d.*;
import javax.vecmath.*;

public class SimpleTransformGroup extends TransformGroup
{

    public SimpleTransformGroup()
    {
        initial = new Vector3f();
        TRANSLATION = 0.05F;
        ROTATION = 0.0087266462599716477D;
        SCALE = 0.01D;
        temp = new Transform3D();
        transform = new Transform3D();
        vector = new Vector3d();
        zero = new Vector3d();
        common();
    }

    public SimpleTransformGroup(Vector3f vector3f)
    {
        initial = new Vector3f();
        TRANSLATION = 0.05F;
        ROTATION = 0.0087266462599716477D;
        SCALE = 0.01D;
        temp = new Transform3D();
        transform = new Transform3D();
        vector = new Vector3d();
        zero = new Vector3d();
        initial = new Vector3f(vector3f);
        common();
    }

    protected void common()
    {
        setCapability(18);
        setCapability(17);
        reset();
    }

    public Vector3d get()
    {
        Vector3d vector3d = new Vector3d();
        get(transform);
        transform.get(vector3d);
        return vector3d;
    }

    public void get(Transform3D transform3d)
    {
        getTransform(transform3d);
    }

    public void get(double ad[])
    {
        get(transform);
        transform.get(ad);
    }

    public void move(Vector3d vector3d)
    {
        get(transform);
        transform.get(vector);
        vector.add(vector3d);
        transform.setTranslation(vector);
        updateTransform(transform);
    }

    public void move(Vector3f vector3f)
    {
        move(new Vector3d(vector3f));
    }

    public void reset()
    {
        transform.set(initial);
        updateTransform(transform);
    }

    public void rotX(double d)
    {
        get(transform);
        temp.setIdentity();
        temp.rotX(d);
        transform.get(vector);
        transform.setTranslation(zero);
        transform.mul(temp, transform);
        transform.setTranslation(vector);
        updateTransform(transform);
    }

    public void rotY(double d)
    {
        get(transform);
        temp.setIdentity();
        temp.rotY(d);
        transform.get(vector);
        transform.setTranslation(zero);
        transform.mul(temp, transform);
        transform.setTranslation(vector);
        updateTransform(transform);
    }

    public void rotZ(double d)
    {
        get(transform);
        temp.setIdentity();
        temp.rotZ(d);
        transform.get(vector);
        transform.setTranslation(zero);
        transform.mul(temp, transform);
        transform.setTranslation(vector);
        updateTransform(transform);
    }

    public void scale(double d)
    {
        get(transform);
        temp.setIdentity();
        temp.set(d);
        transform.get(vector);
        transform.setTranslation(zero);
        transform.mul(temp, transform);
        transform.setTranslation(vector);
        updateTransform(transform);
    }

    public void scale(Vector3d vector3d)
    {
        getTransform(transform);
        temp.setIdentity();
        temp.setScale(vector3d);
        transform.get(vector);
        transform.setTranslation(zero);
        transform.mul(temp, transform);
        transform.setTranslation(vector);
        updateTransform(transform);
    }

    public void set(Transform3D transform3d)
    {
        updateTransform(transform3d);
    }

    public void set(Vector3d vector3d)
    {
        get(transform);
        transform.setTranslation(vector3d);
        updateTransform(transform);
    }

    public void set(Vector3d vector3d, double d, double d1, double d2)
    {
        transform.setIdentity();
        temp.setIdentity();
        temp.rotX(d);
        transform.mul(temp, transform);
        temp.setIdentity();
        temp.rotY(d1);
        transform.mul(temp, transform);
        temp.setIdentity();
        temp.rotZ(d2);
        transform.mul(temp, transform);
        transform.setTranslation(vector3d);
        updateTransform(transform);
    }

    public void set(SimpleTransformGroup simpletransformgroup)
    {
        simpletransformgroup.get(transform);
        updateTransform(transform);
    }

    public void set(double ad[])
    {
        if(ad.length != 16)
        {
            return;
        } else
        {
            transform.set(ad);
            updateTransform(transform);
            return;
        }
    }

    protected void updateTransform(Transform3D transform3d)
    {
        setTransform(transform3d);
    }

    Vector3f initial;
    protected float TRANSLATION;
    protected double ROTATION;
    protected double SCALE;
    protected Transform3D temp;
    protected Transform3D transform;
    protected Vector3d vector;
    protected Vector3d zero;
}
