/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PortfolioApplication.java

package ncsa.j3d.application;

import com.sun.j3d.utils.universe.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.util.Properties;
import javax.media.j3d.*;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.events.EventManager;
import ncsa.j3d.ui.tools.ToolManager;
import ncsa.j3d.ui.widgets.WidgetManager;

public class PortfolioApplication
{

    public PortfolioApplication()
    {
        frame = null;
        canvas = null;
        widgetManager = null;
    }

    public void configure(Canvas3D canvas3d, BranchGroup branchgroup, TransformGroup transformgroup)
    {
        widgetManager = new WidgetManager(canvas3d);
        ToolManager toolmanager = ToolManager.instance();
        EventManager eventmanager = EventManager.instance();
        if(canvas3d != null)
        {
            toolmanager.setCanvas(canvas3d);
            widgetManager.setCanvas(canvas3d);
        }
        if(branchgroup != null)
        {
            toolmanager.setBranchGroup(branchgroup);
            widgetManager.setBranchGroup(branchgroup);
            eventmanager.setBranchGroup(branchgroup);
        }
        if(transformgroup != null)
            toolmanager.setViewTransform(transformgroup);
        EventManager.instance().addEventReceiver(ToolManager.instance());
        EventManager.instance().loadInputSources();
        EventManager.instance().loadInputDevices();
        toolmanager.loadTools();
    }

    public void configureStereo(View view)
    {
        String s = PortfolioProperties.instance().getProperty("Stereo");
        if(s != null && s.equalsIgnoreCase("true"))
        {
            PhysicalBody physicalbody = new PhysicalBody();
            physicalbody.setRightEyePosition(new Point3d(-0.010135999999999999D, 0.0D, 0.0D));
            physicalbody.setLeftEyePosition(new Point3d(-0.0074320000000000002D, 0.0D, 0.0D));
            PhysicalEnvironment physicalenvironment = new PhysicalEnvironment();
            view.setPhysicalBody(physicalbody);
            view.setPhysicalEnvironment(physicalenvironment);
            String s1 = PortfolioProperties.instance().getProperty("Verbose");
            if(s1 != null && s1.equalsIgnoreCase("true"))
                System.out.println("Stero on.");
        }
    }

    protected Node getGeometry()
    {
        return null;
    }

    public void launchFrame()
    {
        frame = new Frame("Portfolio");
        WindowAdapter windowadapter = new WindowAdapter() {

            public void windowClosing(WindowEvent windowevent)
            {
                System.exit(0);
            }

        };
        frame.addWindowListener(windowadapter);
        canvas = new Canvas3D(null);
        SimpleUniverse simpleuniverse = new SimpleUniverse(canvas);
        View view = simpleuniverse.getViewer().getView();
        PhysicalEnvironment physicalenvironment = view.getPhysicalEnvironment();
        physicalenvironment.setSensorCount(100);
        view.setPhysicalEnvironment(physicalenvironment);
        configureStereo(view);
        view.setBackClipDistance(1000000D);
        ViewingPlatform viewingplatform = simpleuniverse.getViewingPlatform();
        TransformGroup transformgroup = viewingplatform.getViewPlatformTransform();
        Transform3D transform3d = new Transform3D();
        Vector3d vector3d = new Vector3d(5D, 0.0D, 30D);
        transform3d.setTranslation(vector3d);
        transformgroup.setTransform(transform3d);
        BranchGroup branchgroup = new BranchGroup();
        branchgroup.setCapability(13);
        branchgroup.setCapability(14);
        configure(canvas, branchgroup, transformgroup);
        Node node = getGeometry();
        if(node != null)
            branchgroup.addChild(node);
        simpleuniverse.addBranchGraph(branchgroup);
        canvas.setSize(300, 300);
        frame.add(canvas);
        frame.setSize(frame.getPreferredSize());
        frame.setVisible(true);
    }

    protected Frame frame;
    public Canvas3D canvas;
    public WidgetManager widgetManager;
}
