/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ModelLoader.java

package ncsa.j3d.loaders;

import com.sun.j3d.loaders.*;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

// Referenced classes of package ncsa.j3d.loaders:
//            BasicLoader

public class ModelLoader extends LoaderBase
{

    public ModelLoader()
    {
        setFlags(-1);
    }

    private static String extension(String s)
    {
        int i = s.lastIndexOf('.');
        i++;
        String s1 = s.substring(i);
        if(s1 == null)
            return null;
        else
            return s1.toUpperCase();
    }

    private String getBaseName(String s)
    {
        Properties properties = System.getProperties();
        String s1 = properties.getProperty("file.separator");
        int i = s.lastIndexOf(s1) + 1;
        if(i == -1)
        {
            return "";
        } else
        {
            String s2 = s.substring(0, i);
            return s2;
        }
    }

    public Scene load(Reader reader)
    {
        System.out.println("This method is not implemented in ModelLoader");
        System.out.println("Use load(Reader reader, String ext) instead.");
        return null;
    }

    public Scene load(Reader reader, String s)
        throws FileNotFoundException
    {
        BasicLoader basicloader = null;
        if(reader == null)
            return null;
        if(s == null)
            return null;
        String s1 = s.toUpperCase();
        try
        {
            basicloader = (BasicLoader)Class.forName(LoaderPackage + LoaderPrefix + s1).newInstance();
        }
        catch(Exception _ex)
        {
            System.out.println("Can't open files of type " + s);
            throw new FileNotFoundException();
        }
        basicloader.setBasePath(super.basePath);
        basicloader.setBaseUrl(super.baseUrl);
        basicloader.setFlags(super.loadFlags);
        return basicloader.load(reader);
    }

    public Scene load(String s)
        throws FileNotFoundException
    {
        String s1 = extension(s);
        setBasePath(getBaseName(s));
        Object obj = null;
        File file = null;
        try
        {
            file = new File(s);
        }
        catch(Exception exception)
        {
            System.out.println(exception);
            return null;
        }
        if(file.exists())
        {
            BufferedReader bufferedreader;
            try
            {
                FileInputStream fileinputstream = new FileInputStream(file);
                InputStreamReader inputstreamreader = new InputStreamReader(fileinputstream, "ISO8859_1");
                bufferedreader = new BufferedReader(inputstreamreader, 8192);
            }
            catch(Exception exception1)
            {
                System.out.println(exception1);
                return null;
            }
            return load(((Reader) (bufferedreader)), s1);
        } else
        {
            System.out.println("File " + s + " could not be found.");
            return null;
        }
    }

    public Scene load(URL url)
        throws FileNotFoundException
    {
        String s = getBaseName(url.toString());
        try
        {
            setBaseUrl(new URL(s));
        }
        catch(MalformedURLException malformedurlexception)
        {
            System.out.println(malformedurlexception);
            Thread.dumpStack();
            return null;
        }
        String s1 = url.getFile();
        String s2 = extension(s1);
        BufferedReader bufferedreader = null;
        try
        {
            java.io.InputStream inputstream = url.openStream();
            InputStreamReader inputstreamreader = new InputStreamReader(inputstream, "ISO8859_1");
            bufferedreader = new BufferedReader(inputstreamreader, 8192);
        }
        catch(Exception exception)
        {
            if(exception.getClass().isInstance(new FileNotFoundException()))
                System.out.println("URL not found: " + url);
            else
                System.out.println(exception);
            return null;
        }
        return load(((Reader) (bufferedreader)), s2);
    }

    protected static String LoaderPackage = "ncsa.j3d.loaders.";
    protected static String LoaderPrefix = "Loader_";

}
