/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   DEM.java

package ncsa.j3d.loaders.dem;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.io.PrintStream;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.util.ReaderTokenizer;

public class DEM
{
    class HeaderData
    {

        int col;

        public HeaderData()
        {
        }
    }


    public DEM()
    {
        app = new Appearance();
        app.setCapability(15);
        Color3f color3f = new Color3f(0.0F, 0.0F, 0.0F);
        Color3f color3f1 = new Color3f(0.0F, 0.0F, 0.0F);
        Color3f color3f2 = new Color3f(1.0F, 1.0F, 1.0F);
        Material material = new Material(color3f1, color3f, color3f, color3f2, 0.6F);
        material.setCapability(1);
        app.setMaterial(material);
        PolygonAttributes polygonattributes = new PolygonAttributes();
        polygonattributes.setCapability(7);
        polygonattributes.setPolygonMode(2);
        app.setPolygonAttributes(polygonattributes);
    }

    public BranchGroup LoadDEM(ReaderTokenizer readertokenizer, boolean flag)
    {
        HeaderData headerdata = readHeader(readertokenizer, flag);
        int i = -2;
        int j = headerdata.col;
        byte byte0 = 6;
        byte byte1 = 6;
        int ai[][] = new int[j][];
        for(int k = 0; k < j; k++)
        {
            if(flag)
                System.err.print(k + " ");
            if(k % byte0 == 0)
                ai[k] = readRow(readertokenizer, i);
            else
                readRow(readertokenizer, 0);
        }

        i = ai[0].length;
        Point3f apoint3f[] = new Point3f[((i - 1) / byte0) * ((j - 1) / byte1) * 6];
        int l = 0;
        float f = ai[0][0];
        for(int i1 = 0; i1 < (j - 1) / byte1; i1++)
        {
            if(flag)
                System.err.print(i1 + ":");
            for(int j1 = 0; j1 < (i - 1) / byte0; j1++)
            {
                apoint3f[l + 5] = new Point3f((j1 + 1) * byte0, (i1 + 1) * byte1, ai[(i1 + 1) * byte1][(j1 + 1) * byte0]);
                if((j1 / byte0 + i1 / byte1) % 2 == 1)
                {
                    if(j1 > 0 && i1 > 0)
                    {
                        apoint3f[l] = apoint3f[(l - ((i - 1) / byte0 + 1) * 6) + 5];
                        apoint3f[l + 1] = apoint3f[(l - ((i - 1) / byte0) * 6) + 5];
                        apoint3f[l + 2] = apoint3f[(l - 6) + 5];
                    } else
                    if(j1 > 0)
                    {
                        apoint3f[l] = new Point3f(j1 * byte0, i1 * byte1, ai[i1 * byte1][j1 * byte0]);
                        apoint3f[l + 1] = new Point3f((j1 + 1) * byte0, i1 * byte1, ai[i1 * byte1][(j1 + 1) * byte0]);
                        apoint3f[l + 2] = apoint3f[(l - 6) + 5];
                    } else
                    if(i1 > 0)
                    {
                        apoint3f[l] = new Point3f(j1 * byte0, i1 * byte1, ai[i1 * byte1][j1 * byte0]);
                        apoint3f[l + 1] = apoint3f[(l - ((i - 1) / byte0) * 6) + 5];
                        apoint3f[l + 2] = new Point3f(j1 * byte0, (i1 + 1) * byte1, ai[(i1 + 1) * byte1][j1 * byte0]);
                    } else
                    {
                        apoint3f[l] = new Point3f(j1 * byte0, i1 * byte1, ai[i1 * byte1][j1 * byte0]);
                        apoint3f[l + 1] = new Point3f((j1 + 1) * byte0, i1 * byte1, ai[i1 * byte1][(j1 + 1) * byte0]);
                        apoint3f[l + 2] = new Point3f(j1 * byte0, (i1 + 1) * byte1, ai[(i1 + 1) * byte1][j1 * byte0]);
                    }
                    apoint3f[l + 3] = apoint3f[l + 2];
                    apoint3f[l + 4] = apoint3f[l + 1];
                    f = min(f, ((Tuple3f) (apoint3f[l])).z, ((Tuple3f) (apoint3f[l + 1])).z, ((Tuple3f) (apoint3f[l + 2])).z, ((Tuple3f) (apoint3f[l + 5])).z);
                } else
                {
                    if(j1 > 0 && i1 > 0)
                    {
                        apoint3f[l] = apoint3f[(l - ((i - 1) / byte0 + 1) * 6) + 5];
                        apoint3f[l + 1] = apoint3f[(l - ((i - 1) / byte0) * 6) + 5];
                        apoint3f[l + 3] = apoint3f[(l - 6) + 5];
                    } else
                    if(j1 > 0)
                    {
                        apoint3f[l] = new Point3f(j1 * byte0, i1 * byte1, ai[i1 * byte1][j1 * byte0]);
                        apoint3f[l + 1] = new Point3f((j1 + 1) * byte0, i1 * byte1, ai[i1 * byte1][(j1 + 1) * byte0]);
                        apoint3f[l + 3] = apoint3f[(l - 6) + 5];
                    } else
                    if(i1 > 0)
                    {
                        apoint3f[l] = new Point3f(j1 * byte0, i1 * byte1, ai[i1 * byte1][j1 * byte0]);
                        apoint3f[l + 1] = apoint3f[(l - ((i - 1) / byte0) * 6) + 5];
                        apoint3f[l + 3] = new Point3f(j1 * byte0, (i1 + 1) * byte1, ai[(i1 + 1) * byte1][j1 * byte0]);
                    } else
                    {
                        apoint3f[l] = new Point3f(j1 * byte0, i1 * byte1, ai[i1 * byte1][j1 * byte0]);
                        apoint3f[l + 1] = new Point3f((j1 + 1) * byte0, i1 * byte1, ai[i1 * byte1][(j1 + 1) * byte0]);
                        apoint3f[l + 3] = new Point3f(j1 * byte0, (i1 + 1) * byte1, ai[(i1 + 1) * byte1][j1 * byte0]);
                    }
                    apoint3f[l + 4] = apoint3f[l];
                    apoint3f[l + 2] = apoint3f[l + 5];
                    f = min(f, ((Tuple3f) (apoint3f[l])).z, ((Tuple3f) (apoint3f[l + 1])).z, ((Tuple3f) (apoint3f[l + 3])).z, ((Tuple3f) (apoint3f[l + 5])).z);
                }
                l += 6;
            }

            ai[i1 * byte1] = null;
        }

        if(flag)
            System.err.print("Ending...");
        GeometryInfo geometryinfo = new GeometryInfo(1);
        geometryinfo.setCoordinates(apoint3f);
        apoint3f = null;
        NormalGenerator normalgenerator = new NormalGenerator();
        normalgenerator.setCreaseAngle(3.1415926535897931D);
        normalgenerator.generateNormals(geometryinfo);
        BranchGroup branchgroup = new BranchGroup();
        Transform3D transform3d = new Transform3D();
        transform3d.setTranslation(new Vector3f(0.0F, 0.0F, -(f + 150F)));
        TransformGroup transformgroup = new TransformGroup(transform3d);
        transformgroup.addChild(new Shape3D(geometryinfo.getGeometryArray(), app));
        branchgroup.addChild(transformgroup);
        if(flag)
            System.err.println("...Done");
        return branchgroup;
    }

    public Appearance getAppearance()
    {
        return app;
    }

    private float min(float f, float f1)
    {
        return f1 >= f ? f : f1;
    }

    private float min(float f, float f1, float f2, float f3, float f4)
    {
        return min(min(min(f, f1), min(f2, f3)), f4);
    }

    private String readBytes(ReaderTokenizer readertokenizer, int i)
    {
        String s = new String();
        boolean flag = false;
        for(int j = 0; j < i; j++)
        {
            char c = readertokenizer.read();
            if(c == '\n')
                return s;
            if(c != ' ')
            {
                if(!flag)
                    flag = true;
                s = s + c;
            }
        }

        if(!flag)
            return null;
        else
            return s;
    }

    private HeaderData readHeader(ReaderTokenizer readertokenizer, boolean flag)
    {
        HeaderData headerdata = new HeaderData();
        readBytes(readertokenizer, 858);
        headerdata.col = Integer.parseInt(readBytes(readertokenizer, 6));
        readBytes(readertokenizer, 160);
        return headerdata;
    }

    public int[] readRow(ReaderTokenizer readertokenizer, int i)
    {
        readertokenizer.nextToken();
        readBytes(readertokenizer, 6);
        int j = Integer.parseInt(readBytes(readertokenizer, 6));
        int k = Integer.parseInt(readBytes(readertokenizer, 6));
        readBytes(readertokenizer, 119);
        int l = i >= 0 ? i : j;
        int ai[] = new int[l];
        for(int i1 = 0; i1 < j; i1++)
        {
            String s = readBytes(readertokenizer, 6);
            if(s == null)
                s = readBytes(readertokenizer, 4);
            if(i1 < l)
            {
                int j1;
                if(s != null)
                    j1 = Integer.parseInt(s) - 140;
                else
                    j1 = ai[i1 - 1 >= 0 ? i1 - 1 : 100];
                ai[i1] = j1;
            }
        }

        return ai;
    }

    Appearance app;
}
