/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ColorObj.java

package ncsa.j3d.loaders.dxf;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

// Referenced classes of package ncsa.j3d.loaders.dxf:
//            ColorTable

class ColorObj
{

    ColorObj()
    {
    }

    public static Color3f ColorList(int i)
    {
        switch(i)
        {
        case -1: 
            return new Color3f(0.7F, 0.7F, 0.7F);
        }
        return ColorTable.lookup(i);
    }

    public static Appearance getColor(int i, float f, boolean flag)
    {
        if(!flag)
        {
            Appearance appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(ColorList(i), 1));
            return appearance;
        } else
        {
            return makeAppearance(ColorList(i), f);
        }
    }

    public static Appearance getColor(Appearance appearance, boolean flag)
    {
        Color3f color3f = new Color3f();
        appearance.getColoringAttributes().getColor(color3f);
        if(!flag)
        {
            Appearance appearance1 = new Appearance();
            appearance1.setColoringAttributes(new ColoringAttributes(color3f, 1));
            return appearance1;
        } else
        {
            Color3f color3f1 = new Color3f();
            appearance.getMaterial().getAmbientColor(color3f1);
            float f = ((Tuple3f) (color3f1)).x / ((Tuple3f) (color3f)).x;
            return makeAppearance(color3f, f);
        }
    }

    public static boolean is3D(Appearance appearance)
    {
        return appearance.getMaterial() != null;
    }

    private static Appearance makeAppearance(Color3f color3f, float f)
    {
        Appearance appearance = new Appearance();
        float f1 = ((Tuple3f) (color3f)).x;
        float f2 = ((Tuple3f) (color3f)).y;
        float f3 = ((Tuple3f) (color3f)).z;
        Material material = new Material();
        material.setEmissiveColor(0.0F, 0.0F, 0.0F);
        material.setAmbientColor(f1 * f * f, f2 * f * f, f3 * f * f);
        material.setDiffuseColor(f1 * f, f2 * f, f3 * f);
        material.setSpecularColor(f1, f2, f3);
        material.setCapability(0);
        appearance.setCapability(0);
        appearance.setMaterial(material);
        return appearance;
    }
}
