/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   DXFLoader.java

package ncsa.j3d.loaders.dxf;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.io.*;
import java.util.Vector;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.util.ReaderTokenizer;

// Referenced classes of package ncsa.j3d.loaders.dxf:
//            ColorObj, LayerList, NodeList, PointList

public class DXFLoader
{

    public DXFLoader()
    {
        progress = false;
        watchFile = false;
        EOF = false;
        forceReadNextTokenAsInt = false;
        angdir = true;
        dimaunit = 0;
        shadedif = 0.7F;
    }

    private void CleanDXFLayers()
    {
        if(progress)
            System.out.print(":");
        for(String s = al.Start(); s != null; s = al.Next())
        {
            int i = al.getSize() + 1;
            if(progress)
                System.out.print("[" + s + "," + i);
            if(al.getType() == 0)
            {
                Shape3D shape3d = al.getShape();
                TriangleFanArray trianglefanarray = (TriangleFanArray)shape3d.getGeometry();
                int j = al.getColor();
                if(i > 1)
                {
                    int ai[] = new int[i];
                    for(int k = 0; k < i; k++)
                        ai[k] = 4;

                    TriangleFanArray trianglefanarray1 = new TriangleFanArray(i * 4, 3, ai);
                    Point3f apoint3f[] = new Point3f[i * 4];
                    PointList pointlist = new PointList();
                    for(int l = 0; l < i * 4; l++)
                    {
                        apoint3f[l] = new Point3f();
                        Point3f point3f = new Point3f();
                        Vector3f vector3f = new Vector3f();
                        trianglefanarray.getCoordinate(l, apoint3f[l]);
                        trianglefanarray.getNormal(l, vector3f);
                        pointlist.addPoint(apoint3f[l], vector3f);
                        if(l % 400 == 0 && progress)
                            System.out.print(".");
                    }

                    if(progress)
                        System.out.print("^");
                    pointlist.Done();
                    for(int i1 = 0; i1 < i * 4; i1++)
                    {
                        Point3f point3f1 = new Point3f();
                        Vector3f vector3f1 = new Vector3f();
                        point3f1 = pointlist.getPoint(apoint3f[i1]);
                        vector3f1 = pointlist.getNormal(point3f1);
                        trianglefanarray1.setCoordinate(i1, point3f1);
                        trianglefanarray1.setNormal(i1, vector3f1);
                        if(i1 % 400 == 0 && progress)
                            System.out.print(".");
                    }

                    bg.addChild(new Shape3D(trianglefanarray1, itemAppearance(null, j, true)));
                }
            } else
            {
                bg.addChild(al.getShape());
            }
            if(progress)
                System.out.print("]");
        }

        if(progress)
            System.out.print(":");
    }

    private void FileError(String s)
    {
        System.err.println("Error with the .DXF file.  Does not conform to given DXF specs.");
        if(s != null)
            System.err.println(s);
        System.exit(1);
    }

    private void GoToNextData()
    {
        int i = readInt(fis);
        for(String s = getLine(fis); (i != 0 || s == null || s.compareTo("ENDSEC") != 0) && !EOF; s = getLine(fis))
            i = readInt(fis);

    }

    public BranchGroup LoadDXF(Reader reader)
    {
        bg = new BranchGroup();
        bg.setCapability(3);
        fis = new ReaderTokenizer(reader);
        fis.ordinaryChar(35);
        fis.wordChars(34, 34);
        LoadDXFWaiting();
        return bg;
    }

    public BranchGroup LoadDXF(Reader reader, boolean flag)
    {
        progress = flag;
        bg = new BranchGroup();
        bg.setCapability(3);
        fis = new ReaderTokenizer(reader);
        fis.ordinaryChar(35);
        fis.wordChars(34, 34);
        LoadDXFWaiting();
        bg.compile();
        return bg;
    }

    private String LoadDXF3DFace(BranchGroup branchgroup)
    {
        float af[] = new float[12];
        boolean flag = false;
        String s = null;
        int i = -1;
        int j = readInt(fis);
        String s1 = null;
        for(; j != 0; j = readInt(fis))
            switch(j)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 11: // '\013'
            case 12: // '\f'
            case 13: // '\r'
            case 20: // '\024'
            case 21: // '\025'
            case 22: // '\026'
            case 23: // '\027'
            case 30: // '\036'
            case 31: // '\037'
            case 32: // ' '
            case 33: // '!'
                af[(j / 10 + (j % 10) * 3) - 1] = readFloat(fis);
                if(j % 10 == 3)
                    flag = true;
                break;

            case 62: // '>'
                i = readInt(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }

        s1 = getLine(fis);
        if(!flag)
        {
            af[9] = af[6];
            af[10] = af[7];
            af[11] = af[8];
        } else
        if(af[9] == af[6] && af[10] == af[7] && af[11] == af[8])
            flag = false;
        Shape3D shape3d = null;
        boolean flag1 = false;
        int k;
        if(al.Find(s) != null)
        {
            shape3d = al.getChild(s);
            al.addSize(s, 1);
            k = al.getSize(s);
        } else
        {
            int ai[] = new int[1];
            ai[0] = 4;
            TriangleFanArray trianglefanarray = new TriangleFanArray(4, 31, ai);
            shape3d = new Shape3D(trianglefanarray, itemAppearance(null, i, true));
            k = 0;
        }
        GeometryArray geometryarray = (GeometryArray)shape3d.getGeometry();
        TriangleFanArray trianglefanarray1 = (TriangleFanArray)geometryarray;
        if(geometryarray.getVertexCount() / 4 <= k)
        {
            int ai1[] = new int[k * 2];
            Point3f apoint3f[] = new Point3f[k * 8];
            Vector3f avector3f[] = new Vector3f[k * 8];
            for(int l = 0; l < k; l++)
            {
                ai1[l] = 4;
                ai1[k + l] = 4;
            }

            for(int i1 = 0; i1 < k; i1++)
            {
                for(int j1 = 0; j1 < 4; j1++)
                {
                    apoint3f[4 * i1 + j1] = new Point3f();
                    apoint3f[4 * (i1 + k) + j1] = new Point3f();
                    geometryarray.getCoordinate(4 * i1 + j1, apoint3f[4 * i1 + j1]);
                    avector3f[4 * i1 + j1] = new Vector3f();
                    avector3f[4 * (i1 + k) + j1] = new Vector3f();
                    geometryarray.getNormal(4 * i1 + j1, avector3f[4 * i1 + j1]);
                }

            }

            trianglefanarray1 = new TriangleFanArray(k * 2 * 4, 31, ai1);
            trianglefanarray1.setCoordinates(0, apoint3f);
            trianglefanarray1.setNormals(0, avector3f);
        }
        Vector3f vector3f = new Vector3f(af[3] - af[0], af[4] - af[1], af[5] - af[2]);
        Vector3f vector3f1 = new Vector3f(af[6] - af[3], af[7] - af[4], af[8] - af[5]);
        Vector3f vector3f2 = new Vector3f(af[9] - af[6], af[10] - af[7], af[11] - af[8]);
        Vector3f vector3f3 = new Vector3f(af[0] - af[9], af[1] - af[10], af[2] - af[11]);
        Vector3f vector3f4 = new Vector3f(af[6] - af[0], af[7] - af[1], af[8] - af[2]);
        if(flag)
        {
            trianglefanarray1.setNormal(k * 4, vNormalize(vAdd(vCross(vNeg(vector3f), vNeg(vector3f4)), vCross(vNeg(vector3f4), vector3f3))));
            trianglefanarray1.setNormal(k * 4 + 2, vNormalize(vAdd(vCross(vector3f1, vNeg(vector3f4)), vCross(vNeg(vector3f4), vNeg(vector3f2)))));
            trianglefanarray1.setNormal(k * 4 + 3, vNormalize(vCross(vNeg(vector3f3), vector3f2)));
        } else
        {
            trianglefanarray1.setNormal(k * 4, vNormalize(vCross(vNeg(vector3f), vNeg(vector3f4))));
            trianglefanarray1.setNormal(k * 4 + 2, vNeg(vNormalize(vCross(vector3f1, vector3f4))));
            trianglefanarray1.setNormal(k * 4 + 3, new Vector3f(0.0F, 0.0F, 0.0F));
        }
        trianglefanarray1.setNormal(k * 4 + 1, vNeg(vNormalize(vCross(vector3f, vNeg(vector3f1)))));
        for(int k1 = 0; k1 < 4; k1++)
        {
            Point3f point3f = new Point3f(af[3 * k1], af[3 * k1 + 1], af[3 * k1 + 2]);
            trianglefanarray1.setCoordinate(k * 4 + k1, point3f);
        }

        shape3d.setGeometry(trianglefanarray1);
        if(al.Find(s) == null)
            branchgroup.addChild(shape3d);
        return s1;
    }

    private String LoadDXFArc(BranchGroup branchgroup)
    {
        float af[] = new float[3];
        float af1[] = new float[3];
        float f = 1.0F;
        float af2[] = new float[2];
        af1[0] = 0.0F;
        af1[1] = 0.0F;
        af1[2] = 1.0F;
        int i = -1;
        String s = null;
        int j = readInt(fis);
        String s1 = null;
        for(; j != 0; j = readInt(fis))
            switch(j)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[j / 10 - 1] = readFloat(fis);
                break;

            case 40: // '('
                f = readFloat(fis);
                break;

            case 50: // '2'
                af2[0] = convAngle(readFloat(fis));
                break;

            case 51: // '3'
                af2[1] = convAngle(readFloat(fis));
                break;

            case 62: // '>'
                i = readInt(fis);
                break;

            case 210: 
            case 220: 
            case 230: 
                af1[(j - 200) / 10 - 1] = readFloat(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }

        s1 = getLine(fis);
        if(af2[0] > af2[1])
            af2[0] -= 6.283185F;
        float f1 = af2[0];
        af2[0] = angdir ? af2[0] : af2[1];
        af2[1] = angdir ? af2[1] : f1;
        float f2 = af2[1] - af2[0];
        int ai[] = new int[1];
        ai[0] = 51;
        LineStripArray linestriparray = new LineStripArray(51, 1, ai);
        float af3[] = new float[3];
        af3[0] = (float)(Math.cos(af2[0]) * (double)f);
        af3[1] = (float)(Math.sin(af2[0]) * (double)f);
        af3[2] = 0.0F;
        Point3f point3f = new Point3f(af[0] + af1[0] * af3[2] + (af1[1] + af1[2]) * af3[0], af[1] + (af1[0] + af1[2]) * af3[1] + af1[1] * af3[2], af[2] + af1[0] * -af3[0] + af1[1] * -af3[1] + af1[2] * af3[2]);
        linestriparray.setCoordinate(0, point3f);
        for(int k = 1; k <= 50; k++)
        {
            float f3 = af2[0] + ((float)k * f2) / 50F;
            af3[0] = (float)(Math.cos(f3) * (double)f);
            af3[1] = (float)(Math.sin(f3) * (double)f);
            af3[2] = 0.0F;
            Point3f point3f1 = new Point3f(af[0] + af1[0] * af3[2] + (af1[1] + af1[2]) * af3[0], af[1] + (af1[0] + af1[2]) * af3[1] + af1[1] * af3[2], af[2] + af1[0] * -af3[0] + af1[1] * -af3[1] + af1[2] * af3[2]);
            linestriparray.setCoordinate(k, point3f1);
        }

        Appearance appearance = itemAppearance(s, i, false);
        branchgroup.addChild(new Shape3D(linestriparray, appearance));
        return s1;
    }

    private void LoadDXFBlock(NodeList nodelist)
    {
        BranchGroup branchgroup = new BranchGroup();
        branchgroup.setCapability(3);
        SharedGroup sharedgroup = new SharedGroup();
        float af[] = new float[3];
        String s = null;
        int i = readInt(fis);
        String s1 = null;
        for(; i != 0; i = readInt(fis))
            switch(i)
            {
            case 2: // '\002'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[i / 10 - 1] = readFloat(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }

        s1 = getLine(fis);
        if(progress)
            System.out.print("<");
        LoadDXFData(branchgroup, "ENDBLK", s1);
        if(progress)
            System.out.print(">");
        sharedgroup.addChild(branchgroup);
        nodelist.addChild(sharedgroup, s);
    }

    private void LoadDXFBlocks()
    {
        nl = new NodeList();
        int i = readInt(fis);
        for(String s = readString(fis); s == null || s.compareTo("ENDSEC") != 0; s = UseNextData())
            if(s.compareTo("BLOCK") == 0)
                LoadDXFBlock(nl);

    }

    private String LoadDXFCircle(BranchGroup branchgroup)
    {
        float af[] = new float[3];
        float af1[] = new float[3];
        float f = 1.0F;
        af1[0] = 0.0F;
        af1[1] = 0.0F;
        af1[2] = 1.0F;
        int i = -1;
        String s = null;
        int j = readInt(fis);
        String s1 = null;
        for(; j != 0; j = readInt(fis))
            switch(j)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[j / 10 - 1] = readFloat(fis);
                break;

            case 40: // '('
                f = readFloat(fis);
                break;

            case 62: // '>'
                i = readInt(fis);
                break;

            case 210: 
            case 220: 
            case 230: 
                af1[(j - 200) / 10 - 1] = readFloat(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }

        s1 = getLine(fis);
        int ai[] = new int[1];
        ai[0] = 51;
        LineStripArray linestriparray = new LineStripArray(51, 1, ai);
        float f1 = 0.0F;
        float af2[] = new float[3];
        af2[0] = (float)(Math.cos(0.0D) * (double)f);
        af2[1] = (float)(Math.sin(0.0D) * (double)f);
        af2[2] = 0.0F;
        Point3f point3f = new Point3f(af[0] + af1[0] * af2[2] + (af1[1] + af1[2]) * af2[0], af[1] + (af1[0] + af1[2]) * af2[1] + af1[1] * af2[2], af[2] + af1[0] * -af2[0] + af1[1] * -af2[1] + af1[2] * af2[2]);
        linestriparray.setCoordinate(0, point3f);
        for(int k = 1; k <= 50; k++)
        {
            float f2 = (float)(((double)k * 6.2831853071795862D) / 50D);
            af2[0] = (float)(Math.cos(f2) * (double)f);
            af2[1] = (float)(Math.sin(f2) * (double)f);
            af2[2] = 0.0F;
            Point3f point3f1 = new Point3f(af[0] + af1[0] * af2[2] + (af1[1] + af1[2]) * af2[0], af[1] + (af1[0] + af1[2]) * af2[1] + af1[1] * af2[2], af[2] + af1[0] * -af2[0] + af1[1] * -af2[1] + af1[2] * af2[2]);
            linestriparray.setCoordinate(k, point3f1);
        }

        Appearance appearance = itemAppearance(s, i, false);
        branchgroup.addChild(new Shape3D(linestriparray, appearance));
        return s1;
    }

    private void LoadDXFData(BranchGroup branchgroup, String s, String s1)
    {
        int i;
        String s2;
        if(s1 == null)
        {
            i = readInt(fis);
            s2 = getLine(fis);
        } else
        {
            i = 0;
            s2 = new String(s1);
        }
        for(; i != 0 || s2.compareTo(s) != 0; i = 0)
        {
            if(progress)
                System.out.print(".");
            switch(s2.charAt(0))
            {
            case 51: // '3'
                if(s2.compareTo("3DFACE") == 0)
                    s2 = LoadDXF3DFace(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 65: // 'A'
                if(s2.compareTo("ARC") == 0)
                    s2 = LoadDXFArc(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 67: // 'C'
                if(s2.compareTo("CIRCLE") == 0)
                    s2 = LoadDXFCircle(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 69: // 'E'
                if(s2.compareTo("ELLIPSE") == 0)
                    s2 = LoadDXFEllipse(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 73: // 'I'
                if(s2.compareTo("INSERT") == 0)
                    s2 = LoadDXFInsert(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 76: // 'L'
                if(s2.compareTo("LINE") == 0)
                    s2 = LoadDXFLine(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 80: // 'P'
                if(s2.compareTo("POINT") == 0)
                {
                    s2 = LoadDXFPoint(branchgroup);
                    break;
                }
                if(s2.compareTo("POLYLINE") == 0)
                    s2 = LoadDXFPolyline(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 83: // 'S'
                if(s2.compareTo("SHAPE") == 0)
                {
                    s2 = LoadDXFInsert(branchgroup);
                    break;
                }
                if(s2.compareTo("SOLID") == 0)
                    s2 = LoadDXFSolid(branchgroup);
                else
                    s2 = UseNextData();
                break;

            case 84: // 'T'
                if(s2.compareTo("TEXT") == 0)
                    s2 = LoadDXFText(branchgroup);
                else
                    s2 = UseNextData();
                break;

            default:
                s2 = UseNextData();
                break;
            }
        }

    }

    private String LoadDXFEllipse(BranchGroup branchgroup)
    {
        float af[] = new float[3];
        float af1[] = new float[3];
        float f = 1.0F;
        float af2[] = new float[2];
        float af3[] = new float[3];
        af2[0] = 0.0F;
        af2[1] = 6.283185F;
        af3[0] = 0.0F;
        af3[1] = 0.0F;
        af3[2] = 1.0F;
        int i = -1;
        String s = null;
        int j = readInt(fis);
        String s1 = null;
        for(; j != 0; j = readInt(fis))
            switch(j)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[j / 10 - 1] = readFloat(fis);
                break;

            case 11: // '\013'
            case 21: // '\025'
            case 31: // '\037'
                af1[j / 10 - 1] = readFloat(fis);
                break;

            case 40: // '('
                f = readFloat(fis);
                break;

            case 41: // ')'
                af2[0] = convAngle(readFloat(fis));
                break;

            case 42: // '*'
                af2[1] = convAngle(readFloat(fis));
                break;

            case 62: // '>'
                i = readInt(fis);
                break;

            case 210: 
            case 220: 
            case 230: 
                af3[(j - 200) / 10 - 1] = readFloat(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }

        s1 = getLine(fis);
        float f1 = (float)Math.pow(Math.pow(af1[0], 2D) + Math.pow(af1[1], 2D) + Math.pow(af1[2], 2D), 0.5D);
        int ai[] = new int[1];
        ai[0] = 51;
        LineStripArray linestriparray = new LineStripArray(51, 1, ai);
        float af4[] = new float[3];
        af4[0] = f1;
        af4[1] = 0.0F;
        af4[2] = 0.0F;
        float af5[] = new float[3];
        af5[0] = (af4[0] * af1[0] + af4[1] * -af1[1] + af4[2] * -af1[2]) / f1;
        af5[1] = ((af4[0] + af4[2]) * af1[1] + af4[1] * af1[0]) / f1;
        af5[2] = ((af4[0] + af4[1]) * af1[2] + af4[2] * af1[0]) / f1;
        Point3f point3f = new Point3f(af[0] + af3[0] * af5[2] + (af3[1] + af3[2]) * af5[0], af[1] + (af3[0] + af3[2]) * af5[1] + af3[1] * af5[2], af[2] + af3[0] * -af5[0] + af3[1] * -af5[1] + af3[2] * af5[2]);
        linestriparray.setCoordinate(0, point3f);
        float f2 = af2[1] - af2[0];
        for(int k = 1; k <= 50; k++)
        {
            float f3 = af2[0] + ((float)k * f2) / 50F;
            af4[0] = (float)(Math.cos(f3) * (double)f1);
            af4[1] = (float)(Math.sin(f3) * (double)f * (double)f1);
            af4[2] = 0.0F;
            af5[0] = (af4[0] * af1[0] + af4[1] * -af1[1] + af4[2] * -af1[2]) / f1;
            af5[1] = ((af4[0] + af4[2]) * af1[1] + af4[1] * af1[0]) / f1;
            af5[2] = ((af4[0] + af4[1]) * af1[2] + af4[2] * af1[0]) / f1;
            Point3f point3f1 = new Point3f(af[0] + af3[0] * af5[2] + (af3[1] + af3[2]) * af5[0], af[1] + (af3[0] + af3[2]) * af5[1] + af3[1] * af5[2], af[2] + af3[0] * -af5[0] + af3[1] * -af5[1] + af3[2] * af5[2]);
            linestriparray.setCoordinate(k, point3f1);
        }

        Appearance appearance = itemAppearance(s, i, false);
        branchgroup.addChild(new Shape3D(linestriparray, appearance));
        return s1;
    }

    private void LoadDXFEntities()
    {
        LoadDXFData(bg, "ENDSEC", null);
    }

    private void LoadDXFHeader()
    {
        int i = readInt(fis);
        for(String s = readString(fis); i != 0 || s.compareTo("ENDSEC") != 0; s = readString(fis))
        {
            if(s.length() >= 2)
                switch(s.charAt(1))
                {
                default:
                    break;

                case 65: // 'A'
                    if(s.compareTo("$ANGDIR") == 0)
                    {
                        nextLine(fis);
                        angdir = readInt(fis) != 0;
                    }
                    break;

                case 68: // 'D'
                    if(s.compareTo("$DIMAUNIT") == 0)
                    {
                        nextLine(fis);
                        dimaunit = readInt(fis);
                    }
                    break;

                case 83: // 'S'
                    if(s.compareTo("$SHADEDIF") == 0)
                    {
                        nextLine(fis);
                        shadedif = readFloat(fis);
                    }
                    break;
                }
            i = readInt(fis);
        }

    }

    private String LoadDXFInsert(BranchGroup branchgroup)
    {
        String s = null;
        float af[] = new float[3];
        af[0] = 0.0F;
        af[1] = 0.0F;
        af[2] = 0.0F;
        double ad[] = new double[3];
        ad[0] = 1.0D;
        ad[1] = 1.0D;
        ad[2] = 1.0D;
        float f = 0.0F;
        float af1[] = new float[3];
        af1[0] = 0.0F;
        af1[1] = 0.0F;
        af1[2] = 1.0F;
        int i = readInt(fis);
        String s1 = null;
        for(; i != 0; i = readInt(fis))
        {
            float f1;
            switch(i)
            {
            case 2: // '\002'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[i / 10 - 1] = readFloat(fis);
                break;

            case 41: // ')'
            case 42: // '*'
            case 43: // '+'
                ad[i - 41] = readFloat(fis);
                break;

            case 50: // '2'
                f1 = convAngle(readFloat(fis));
                break;

            case 210: 
            case 220: 
            case 230: 
                af1[(i - 200) / 10 - 1] = readFloat(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }
        }

        s1 = getLine(fis);
        javax.media.j3d.Link link = nl.getChild(s);
        TransformGroup transformgroup = new TransformGroup();
        Transform3D transform3d = new Transform3D();
        transform3d.setScale(new Vector3d(ad));
        transform3d.setTranslation(new Vector3f(af));
        transform3d.setRotation(new Matrix3f(af1[2], af1[0], af1[0], af1[1], af1[2], af1[1], -af1[0], -af1[1], af1[2]));
        transformgroup.addChild(link);
        transformgroup.setTransform(transform3d);
        branchgroup.addChild(transformgroup);
        return s1;
    }

    private void LoadDXFLayerTable(LayerList layerlist)
    {
        String s = null;
        int j = -1;
        String s1 = null;
        while(s == null || s.compareTo("ENDTAB") != 0) 
        {
            int i = readInt(fis);
            switch(i)
            {
            case 0: // '\0'
                s = getLine(fis);
                if(s.compareTo("ENDTAB") != 0 && progress)
                    System.out.print("[");
                break;

            case 2: // '\002'
                s1 = getLine(fis);
                if(progress)
                    System.out.print("n" + s1);
                break;

            case 6: // '\006'
                s = getLine(fis);
                int ai[] = new int[1];
                ai[0] = 4;
                TriangleFanArray trianglefanarray = new TriangleFanArray(4, 31, ai);
                Shape3D shape3d = new Shape3D(trianglefanarray, itemAppearance(null, j, true));
                shape3d.setCapability(13);
                layerlist.addChild(shape3d, s1, j, 0, 0);
                if(progress)
                    System.out.print("]");
                break;

            case 62: // '>'
                j = readInt(fis);
                if(progress)
                    System.out.print("a");
                break;

            default:
                s = getLine(fis);
                break;
            }
        }
    }

    private String LoadDXFLine(BranchGroup branchgroup)
    {
        float af[] = new float[6];
        int i = -1;
        String s = null;
        int j = readInt(fis);
        String s1 = null;
        for(; j != 0; j = readInt(fis))
        {
            float f;
            switch(j)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 11: // '\013'
            case 20: // '\024'
            case 21: // '\025'
            case 30: // '\036'
            case 31: // '\037'
                af[(j / 10 + 3 * (j % 10)) - 1] = readFloat(fis);
                break;

            case 39: // '\''
                f = readFloat(fis);
                break;

            case 62: // '>'
                i = readInt(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }
        }

        s1 = getLine(fis);
        Appearance appearance = itemAppearance(s, i, false);
        if(s == null || al.getType(s) == 0 && al.getSize(s) > 0 || al.getChild(s) == null)
        {
            LineArray linearray = new LineArray(2, 1);
            linearray.setCoordinate(0, new Point3f(af[0], af[1], af[2]));
            linearray.setCoordinate(1, new Point3f(af[3], af[4], af[5]));
            branchgroup.addChild(new Shape3D(linearray, appearance));
        } else
        {
            LineArray linearray1 = null;
            Shape3D shape3d = null;
            shape3d = al.getChild(s);
            int k = 0;
            if(al.getSize(s) == 0)
            {
                linearray1 = new LineArray(2, 9);
                al.Find(s);
                al.replaceChild(new Shape3D(linearray1, itemAppearance(null, al.getColor(), false)), s, al.getColor(), 0, 1);
            } else
            {
                shape3d = al.getChild(s);
                linearray1 = (LineArray)shape3d.getGeometry();
                k = al.getSize(s);
            }
            if(linearray1.getVertexCount() / 2 <= k)
            {
                int l = linearray1.getVertexCount() / 2;
                int ai[] = new int[l * 2];
                Point3f apoint3f[] = new Point3f[l * 4];
                for(int i1 = 0; i1 < 2 * k; i1++)
                {
                    apoint3f[i1] = new Point3f();
                    linearray1.getCoordinate(i1, apoint3f[i1]);
                }

                linearray1 = new LineArray(k * 2 * 2, 9);
                for(int j1 = 0; j1 < k * 2; j1++)
                    linearray1.setCoordinate(j1, apoint3f[j1]);

                shape3d.setGeometry(linearray1);
            }
            linearray1.setCoordinate(2 * k, new Point3f(af[0], af[1], af[2]));
            linearray1.setCoordinate(2 * k + 1, new Point3f(af[3], af[4], af[5]));
            al.addSize(s, 1);
        }
        return s1;
    }

    private String LoadDXFPoint(BranchGroup branchgroup)
    {
        float af[] = new float[3];
        int i = -1;
        String s = null;
        int j = readInt(fis);
        String s1 = null;
        for(; j != 0; j = readInt(fis))
            switch(j)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[j / 10 - 1] = readFloat(fis);
                break;

            case 62: // '>'
                i = readInt(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }

        s1 = getLine(fis);
        Appearance appearance = itemAppearance(s, i, false);
        PointArray pointarray = new PointArray(1, 1);
        pointarray.setCoordinate(0, new Point3f(af));
        branchgroup.addChild(new Shape3D(pointarray, appearance));
        return s1;
    }

    private String LoadDXFPolyline(BranchGroup branchgroup)
    {
        if(progress)
            System.out.print("/");
        int i = 0;
        float af[] = new float[3];
        boolean flag = false;
        boolean flag1 = false;
        String s = null;
        int l = 0;
        Vector vector = new Vector();
        Vector vector1 = new Vector();
        int i1 = readInt(fis);
        Object obj = null;
        for(; i1 != 0; i1 = readInt(fis))
        {
            int j;
            int k;
            String s1;
            switch(i1)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[i1 / 10 - 1] = readFloat(fis);
                break;

            case 62: // '>'
                l = readInt(fis);
                break;

            case 70: // 'F'
                i = readInt(fis);
                break;

            case 71: // 'G'
                j = readInt(fis);
                break;

            case 72: // 'H'
                k = readInt(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }
        }

        for(String s2 = getLine(fis); i1 != 0 || s2 == null || s2.compareTo("SEQEND") != 0;)
        {
            if(progress)
                System.out.print("^");
            i1 = readInt(fis);
            float af1[] = new float[3];
            int ai[] = new int[4];
            for(int j1 = 0; j1 < 4; j1++)
                ai[j1] = -1;

            int l1 = 0;
            for(; i1 != 0; i1 = readInt(fis))
                switch(i1)
                {
                case 10: // '\n'
                case 20: // '\024'
                case 30: // '\036'
                    af1[i1 / 10 - 1] = readFloat(fis);
                    break;

                case 70: // 'F'
                    l1 = readInt(fis);
                    break;

                case 71: // 'G'
                case 72: // 'H'
                case 73: // 'I'
                case 74: // 'J'
                    ai[i1 - 71] = readInt(fis);
                    if(ai[i1 - 71] < 0)
                        ai[i1 - 71] *= -1;
                    break;

                default:
                    s2 = getLine(fis);
                    break;
                }

            s2 = getLine(fis);
            if((i & 0x40) > 0 && (l1 & 0xc0) == 128)
            {
                if(ai[3] <= 0)
                    ai[3] = ai[2];
                for(int i2 = 0; i2 < 4; i2++)
                {
                    ai[i2]--;
                    vector1.add(new Integer(ai[i2]));
                }

            } else
            {
                vector.add(new Point3f(af1));
            }
        }

        Object obj1;
        if((i & 0x40) == 0)
        {
            int ai1[] = new int[1];
            ai1[0] = vector.size();
            obj1 = new LineStripArray(ai1[0], 1, ai1);
            for(int k1 = 0; k1 < ai1[0]; k1++)
                ((GeometryArray) (obj1)).setCoordinate(k1, (Point3f)vector.elementAt(k1));

        } else
        {
            GeometryInfo geometryinfo = new GeometryInfo(3);
            NormalGenerator normalgenerator = new NormalGenerator();
            int ai2[] = new int[vector1.size() / 4];
            for(int j2 = 0; j2 < ai2.length; j2++)
                ai2[j2] = 4;

            geometryinfo.setStripCounts(ai2);
            Point3f apoint3f[] = new Point3f[vector1.size()];
            for(int k2 = 0; k2 < vector1.size(); k2++)
            {
                int l2 = ((Integer)vector1.elementAt(k2)).intValue();
                if(l2 == -1)
                    l2 = ((Integer)vector1.elementAt(k2 - 1)).intValue();
                apoint3f[k2] = (Point3f)vector.elementAt(l2);
            }

            geometryinfo.setCoordinates(apoint3f);
            normalgenerator.generateNormals(geometryinfo);
            obj1 = geometryinfo.getGeometryArray();
        }
        Appearance appearance = itemAppearance(s, l, (i & 0x40) > 0);
        branchgroup.addChild(new Shape3D(((javax.media.j3d.Geometry) (obj1)), appearance));
        if(progress)
            System.out.print("\\");
        return UseNextData();
    }

    private void LoadDXFSection()
    {
        int i = readInt(fis);
        String s = readString(fis);
        if(progress)
            System.out.print("{" + s);
        if(i == 2)
            switch(s.charAt(0))
            {
            case 66: // 'B'
                if(s.compareTo("BLOCKS") == 0)
                    LoadDXFBlocks();
                else
                    GoToNextData();
                break;

            case 69: // 'E'
                if(s.compareTo("ENTITIES") == 0)
                {
                    LoadDXFEntities();
                    CleanDXFLayers();
                } else
                {
                    GoToNextData();
                }
                break;

            case 72: // 'H'
                if(s.compareTo("HEADER") == 0)
                    LoadDXFHeader();
                else
                    GoToNextData();
                break;

            case 84: // 'T'
                if(s.compareTo("TABLES") == 0)
                    LoadDXFTables();
                else
                    GoToNextData();
                break;

            default:
                GoToNextData();
                break;
            }
        if(progress)
            System.out.print("}");
    }

    private String LoadDXFSolid(BranchGroup branchgroup)
    {
        float af[] = new float[12];
        boolean flag = false;
        int i = -1;
        String s = null;
        int j = readInt(fis);
        String s1 = null;
        for(; j != 0; j = readInt(fis))
            switch(j)
            {
            case 8: // '\b'
                s = getLine(fis);
                break;

            case 10: // '\n'
            case 11: // '\013'
            case 12: // '\f'
            case 13: // '\r'
            case 20: // '\024'
            case 21: // '\025'
            case 22: // '\026'
            case 23: // '\027'
            case 30: // '\036'
            case 31: // '\037'
            case 32: // ' '
            case 33: // '!'
                af[(j / 10 + (j % 10) * 3) - 1] = readFloat(fis);
                if(j % 10 == 3)
                    flag = true;
                break;

            case 62: // '>'
                i = readInt(fis);
                break;

            default:
                s1 = getLine(fis);
                break;
            }

        s1 = getLine(fis);
        int ai[] = new int[3];
        ai[0] = 8;
        TriangleStripArray trianglestriparray = new TriangleStripArray(8, 1, ai);
        if(!flag)
        {
            af[9] = af[6];
            af[10] = af[7];
            af[11] = af[8];
        } else
        if(af[9] == af[6] && af[10] == af[7] && af[11] == af[8])
            flag = false;
        for(int k = 0; k < 4; k++)
        {
            Point3f point3f = new Point3f(af[3 * k], af[3 * k + 1], af[3 * k + 2]);
            trianglestriparray.setCoordinate(k, point3f);
            trianglestriparray.setCoordinate(4 + k, point3f);
        }

        Appearance appearance = itemAppearance(s, i, false);
        branchgroup.addChild(new Shape3D(trianglestriparray, appearance));
        return s1;
    }

    private void LoadDXFTable(LayerList layerlist)
    {
        int i = readInt(fis);
        String s = readString(fis);
        switch(s.charAt(0))
        {
        case 76: // 'L'
            if(s.compareTo("LAYER") == 0)
            {
                int j = readInt(fis);
                s = readString(fis);
                LoadDXFLayerTable(layerlist);
            }
            break;

        default:
            for(; s.compareTo("ENDTAB") != 0; s = UseNextData());
            break;
        }
    }

    private void LoadDXFTables()
    {
        int i = readInt(fis);
        for(String s = readString(fis); s.compareTo("ENDSEC") != 0; s = UseNextData())
            if(s.compareTo("TABLE") == 0)
                LoadDXFTable(al);

    }

    private String LoadDXFText(BranchGroup branchgroup)
    {
        String s = new String("*&^%$#@!");
        float af[] = new float[3];
        float f = 1.0F;
        float f2 = 0.0F;
        float f4 = 1.0F;
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        byte byte0 = -1;
        Object obj = null;
        int i1 = readInt(fis);
        String s3 = null;
        for(; i1 != 0; i1 = readInt(fis))
        {
            String s1;
            float f1;
            float f3;
            float f5;
            int i;
            int j;
            int k;
            int l;
            String s2;
            switch(i1)
            {
            case 1: // '\001'
                s1 = getLine(fis);
                break;

            case 8: // '\b'
                s2 = getLine(fis);
                break;

            case 10: // '\n'
            case 20: // '\024'
            case 30: // '\036'
                af[i1 / 10 - 1] = readFloat(fis);
                break;

            case 40: // '('
                f1 = readFloat(fis);
                break;

            case 41: // ')'
                f5 = readFloat(fis);
                break;

            case 50: // '2'
                f3 = convAngle(readFloat(fis));
                break;

            case 62: // '>'
                l = readInt(fis);
                break;

            case 71: // 'G'
                i = readInt(fis);
                break;

            case 72: // 'H'
                j = readInt(fis);
                break;

            case 73: // 'I'
                k = readInt(fis);
                break;

            default:
                s3 = getLine(fis);
                break;
            }
        }

        s3 = getLine(fis);
        return s3;
    }

    private void LoadDXFWaiting()
    {
        al = new LayerList();
        for(boolean flag = false; !flag;)
        {
            int i = readInt(fis);
            String s = readString(fis);
            switch(i)
            {
            case 0: // '\0'
                if(s.compareTo("SECTION") == 0)
                    LoadDXFSection();
                else
                if(s.compareTo("EOF") == 0)
                    flag = true;
                else
                    FileError("Section Expected");
                break;
            }
            if(EOF)
                flag = true;
        }

    }

    private String UseNextData()
    {
        int i = readInt(fis);
        String s;
        for(s = getLine(fis); i != 0; s = getLine(fis))
            i = readInt(fis);

        return s;
    }

    private float convAngle(float f)
    {
        float f1 = 0.0F;
        switch(dimaunit)
        {
        case 0: // '\0'
            f1 = (float)((double)(f / 180F) * 3.1415926535897931D);
            break;

        case 1: // '\001'
            f1 = (float)((double)(f / 180F) * 3.1415926535897931D);
            break;

        case 2: // '\002'
            f1 = (float)((double)(f / 200F) * 3.1415926535897931D);
            break;

        case 3: // '\003'
            f1 = f;
            break;

        case 4: // '\004'
            f1 = (float)((double)(f / 200F) * 3.1415926535897931D);
            break;

        default:
            f1 = f;
            break;
        }
        return f1;
    }

    private String getLine(ReaderTokenizer readertokenizer)
    {
        readertokenizer.parseNumbersAsWords();
        readertokenizer.wordChars(32, 32);
        readertokenizer.wordChars(9, 9);
        int i = readertokenizer.lineno;
        nextLine(readertokenizer);
        String s = readertokenizer.sval;
        readertokenizer.whitespaceChar(9);
        readertokenizer.whitespaceChar(32);
        readertokenizer.parseNumbers();
        if(readertokenizer.lineno > i + 1)
        {
            readertokenizer.pushBack();
            s = "";
            forceReadNextTokenAsInt = true;
        }
        return s;
    }

    private Appearance itemAppearance(String s, int i, boolean flag)
    {
        Appearance appearance = null;
        if(s != null && i == -1)
        {
            appearance = al.getChild(s).getAppearance();
            appearance = ColorObj.getColor(appearance, flag);
        } else
        {
            if(i == -1)
                i = 255;
            appearance = ColorObj.getColor(i, shadedif, flag);
        }
        PolygonAttributes polygonattributes = new PolygonAttributes();
        polygonattributes.setCapability(7);
        polygonattributes.setCullFace(0);
        polygonattributes.setBackFaceNormalFlip(true);
        if(appearance != null)
            appearance.setPolygonAttributes(polygonattributes);
        return appearance;
    }

    public static void main(String args[])
    {
        try
        {
            FileReader filereader = new FileReader(args[0]);
            DXFLoader dxfloader = new DXFLoader();
            BranchGroup branchgroup = dxfloader.LoadDXF(filereader);
        }
        catch(Exception exception)
        {
            System.out.println(exception);
        }
    }

    private void nextLine(ReaderTokenizer readertokenizer)
    {
        readertokenizer.nextToken();
        if(readertokenizer.ttype == -103)
            EOF = true;
        if(watchFile)
        {
            if(readertokenizer.ttype == -101)
                System.out.print("    word  ");
            else
            if(readertokenizer.ttype == -102)
                System.out.print("    number");
            else
                System.out.print("    not a word or number");
            System.out.println("    token: " + readertokenizer.nval + "   " + readertokenizer.sval + "  line " + readertokenizer.lineno);
        }
    }

    private float readFloat(ReaderTokenizer readertokenizer)
    {
        int i = readertokenizer.lineno;
        float f = (float)readertokenizer.nval;
        nextLine(readertokenizer);
        float f1 = (float)readertokenizer.nval;
        if(readertokenizer.lineno > i + 1)
        {
            readertokenizer.pushBack();
            f1 = f;
        }
        return f1;
    }

    private int readInt(ReaderTokenizer readertokenizer)
    {
        int i = readertokenizer.lineno;
        int j = (int)readertokenizer.nval;
        nextLine(readertokenizer);
        int k = (int)readertokenizer.nval;
        if(forceReadNextTokenAsInt)
        {
            forceReadNextTokenAsInt = false;
            if(readertokenizer.ttype == -101)
                try
                {
                    k = Integer.valueOf(readertokenizer.sval.trim()).intValue();
                }
                catch(NumberFormatException _ex) { }
        }
        if(readertokenizer.lineno > i + 1)
        {
            readertokenizer.pushBack();
            k = j;
        }
        return k;
    }

    private String readString(ReaderTokenizer readertokenizer)
    {
        int i = readertokenizer.lineno;
        nextLine(readertokenizer);
        String s = readertokenizer.sval;
        if(readertokenizer.lineno > i + 1)
        {
            readertokenizer.pushBack();
            s = "";
        }
        return s;
    }

    private Vector3f vAdd(Vector3f vector3f, Vector3f vector3f1)
    {
        return new Vector3f(((Tuple3f) (vector3f)).x + ((Tuple3f) (vector3f1)).x, ((Tuple3f) (vector3f)).y + ((Tuple3f) (vector3f1)).y, ((Tuple3f) (vector3f)).z + ((Tuple3f) (vector3f1)).z);
    }

    private Vector3f vCross(Vector3f vector3f, Vector3f vector3f1)
    {
        Vector3f vector3f2 = new Vector3f();
        vector3f2.cross(vector3f, vector3f1);
        return vector3f2;
    }

    private Vector3f vNeg(Vector3f vector3f)
    {
        return new Vector3f(-((Tuple3f) (vector3f)).x, -((Tuple3f) (vector3f)).y, -((Tuple3f) (vector3f)).z);
    }

    private Vector3f vNormalize(Vector3f vector3f)
    {
        Vector3f vector3f1 = new Vector3f();
        vector3f1.normalize(vector3f);
        return vector3f1;
    }

    private ReaderTokenizer fis;
    private BranchGroup bg;
    private NodeList nl;
    private LayerList al;
    private boolean progress;
    private boolean watchFile;
    private boolean EOF;
    private boolean forceReadNextTokenAsInt;
    private final int divisions = 50;
    private final boolean t3d = false;
    private boolean angdir;
    private int dimaunit;
    private float shadedif;
}
