/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   LayerList.java

package ncsa.j3d.loaders.dxf;

import javax.media.j3d.Shape3D;

class LayerList
{
    class Nodes
    {

        public String Name;
        public Nodes Next;
        public Shape3D thisShape;
        public int color;
        public int shapes;
        public int type;

        public Nodes(String s, Nodes nodes, Shape3D shape3d, int i, int j, int k)
        {
            Name = s;
            Next = nodes;
            thisShape = shape3d;
            color = i;
            shapes = j;
            type = k;
        }
    }


    public LayerList()
    {
        Head = null;
    }

    public String Find(String s)
    {
        Current = findNode(s);
        if(Current == null)
            return null;
        else
            return Current.Name;
    }

    public String Next()
    {
        if(Current == null)
            return null;
        Current = Current.Next;
        if(Current == null)
            return null;
        else
            return Current.Name;
    }

    public String Start()
    {
        Current = Head;
        if(Current == null)
            return null;
        else
            return Current.Name;
    }

    public void addChild(Shape3D shape3d, String s, int i, int j, int k)
    {
        Head = new Nodes(s, Head, shape3d, i, j, k);
    }

    public int addSize(String s, int i)
    {
        Nodes nodes = findNode(s);
        if(nodes == null)
            return -1;
        if(nodes.Name.compareTo(s) != 0)
        {
            return -1;
        } else
        {
            nodes.shapes += i;
            return nodes.shapes;
        }
    }

    private Nodes findNode(String s)
    {
        if(s == null)
            return null;
        Nodes nodes;
        for(nodes = Head; nodes != null && nodes.Next != null && nodes.Name.compareTo(s) != 0; nodes = nodes.Next);
        if(nodes == null || nodes.Name.compareTo(s) != 0)
            return null;
        else
            return nodes;
    }

    public Shape3D getChild(String s)
    {
        Nodes nodes = findNode(s);
        if(nodes == null)
            return null;
        if(nodes.Name.compareTo(s) != 0)
            return null;
        else
            return nodes.thisShape;
    }

    public int getColor()
    {
        if(Current == null)
            return -1;
        else
            return Current.color;
    }

    public int getColor(String s)
    {
        Nodes nodes = findNode(s);
        if(nodes == null)
            return -1;
        if(nodes.Name.compareTo(s) != 0)
            return -1;
        else
            return nodes.color;
    }

    public Shape3D getShape()
    {
        if(Current == null)
            return null;
        else
            return Current.thisShape;
    }

    public int getSize()
    {
        if(Current == null)
            return -1;
        else
            return Current.shapes;
    }

    public int getSize(String s)
    {
        Nodes nodes = findNode(s);
        if(nodes == null)
            return -1;
        if(nodes.Name.compareTo(s) != 0)
            return -1;
        else
            return nodes.shapes;
    }

    public int getType()
    {
        if(Current == null)
            return -1;
        else
            return Current.type;
    }

    public int getType(String s)
    {
        Nodes nodes = findNode(s);
        if(nodes == null)
            return -1;
        if(nodes.Name.compareTo(s) != 0)
            return -1;
        else
            return nodes.type;
    }

    public void replaceChild(Shape3D shape3d, String s, int i, int j, int k)
    {
        Nodes nodes = findNode(s);
        if(nodes == null)
            addChild(shape3d, s, i, j, k);
        else
        if(nodes.Name.compareTo(s) == 0)
        {
            nodes.thisShape = shape3d;
            nodes.color = i;
            nodes.shapes = j;
            nodes.type = k;
        }
    }

    public int setType(String s, int i)
    {
        Nodes nodes = findNode(s);
        if(nodes == null)
            return -1;
        if(nodes.Name.compareTo(s) != 0)
        {
            return -1;
        } else
        {
            nodes.type = i;
            return nodes.type;
        }
    }

    Nodes Head;
    Nodes Current;
}
