/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PointList.java

package ncsa.j3d.loaders.dxf;

import javax.vecmath.*;

class PointList
{
    class Nodes
    {

        Point3f point;
        Vector3f norm;
        Nodes Left;
        Nodes Right;

        public Nodes(Point3f point3f, Vector3f vector3f, Nodes nodes, Nodes nodes1)
        {
            point = point3f;
            norm = vector3f;
            Left = nodes;
            Right = nodes1;
        }
    }


    public PointList()
    {
        Head = null;
        node = null;
    }

    public void Done()
    {
        DoneHelper(Head);
    }

    private void DoneHelper(Nodes nodes)
    {
        if(nodes != null)
        {
            nodes.norm.normalize(nodes.norm);
            DoneHelper(nodes.Left);
            DoneHelper(nodes.Right);
        }
    }

    public void addPoint(Point3f point3f, Vector3f vector3f)
    {
        if(addPointHelper(Head, point3f, vector3f) == null)
            Head = new Nodes(point3f, vector3f, null, null);
    }

    private Nodes addPointHelper(Nodes nodes, Point3f point3f, Vector3f vector3f)
    {
        if(nodes != null)
            switch(pCompare(point3f, nodes.point))
            {
            default:
                break;

            case 0: // '\0'
                nodes.norm = vAdd(nodes.norm, vector3f);
                break;

            case -1: 
                if(addPointHelper(nodes.Left, point3f, vector3f) == null)
                    nodes.Left = new Nodes(point3f, vector3f, null, null);
                break;

            case 1: // '\001'
                if(addPointHelper(nodes.Right, point3f, vector3f) == null)
                    nodes.Right = new Nodes(point3f, vector3f, null, null);
                break;
            }
        return nodes;
    }

    private Nodes findPoint(Point3f point3f, Nodes nodes)
    {
        if(nodes == null)
            return null;
        switch(pCompare(point3f, nodes.point))
        {
        case -1: 
            return findPoint(point3f, nodes.Left);

        case 0: // '\0'
            return nodes;

        case 1: // '\001'
            return findPoint(point3f, nodes.Right);
        }
        return null;
    }

    public Vector3f getNormal(Point3f point3f)
    {
        if(node != null && pCompare(node.point, point3f) == 0)
            return node.norm;
        if(Head == null)
            return null;
        node = findPoint(point3f, Head);
        if(node != null)
            return node.norm;
        else
            return null;
    }

    public Point3f getPoint(Point3f point3f)
    {
        if(node != null && pCompare(node.point, point3f) == 0)
            return node.point;
        if(Head == null)
            return null;
        node = findPoint(point3f, Head);
        if(node != null)
            return node.point;
        else
            return null;
    }

    private int pCompare(Point3f point3f, Point3f point3f1)
    {
        if(((Tuple3f) (point3f)).x < ((Tuple3f) (point3f1)).x)
            return -1;
        if(((Tuple3f) (point3f1)).x < ((Tuple3f) (point3f)).x)
            return 1;
        if(((Tuple3f) (point3f)).y < ((Tuple3f) (point3f1)).y)
            return -1;
        if(((Tuple3f) (point3f1)).y < ((Tuple3f) (point3f)).y)
            return 1;
        if(((Tuple3f) (point3f)).z < ((Tuple3f) (point3f1)).z)
            return -1;
        return ((Tuple3f) (point3f1)).z >= ((Tuple3f) (point3f)).z ? 0 : 1;
    }

    private Vector3f vAdd(Vector3f vector3f, Vector3f vector3f1)
    {
        Vector3f vector3f2 = new Vector3f();
        vector3f2.x = ((Tuple3f) (vector3f)).x + ((Tuple3f) (vector3f1)).x;
        vector3f2.y = ((Tuple3f) (vector3f)).y + ((Tuple3f) (vector3f1)).y;
        vector3f2.z = ((Tuple3f) (vector3f)).z + ((Tuple3f) (vector3f1)).z;
        return vector3f2;
    }

    private Nodes Head;
    Nodes node;
}
