/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   AppearanceList.java

package ncsa.j3d.loaders.load3ds;

import java.io.PrintStream;
import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

class AppearanceList
{
    class Nodes
    {

        public Appearance app;
        public String name;
        public Nodes next;

        Nodes(Appearance appearance, String s, Nodes nodes)
        {
            app = appearance;
            name = s;
            next = nodes;
        }
    }


    public AppearanceList()
    {
        Head = null;
        Current = null;
    }

    private Nodes FindName(String s)
    {
        if(s == null)
            s = new String("");
        if(Current != null && s.compareTo(Current.name) == 0)
            return Current;
        s = s + '\0';
        for(Current = Head; Current != null && s.compareTo(Current.name) != 0; Current = Current.next);
        if(Current == null)
            addAppearance(s);
        return Current;
    }

    public void PrintAppearance(String s)
    {
        Color3f color3f = new Color3f();
        Nodes nodes = FindName(s);
        System.out.print("\n" + nodes.name);
        Material material = nodes.app.getMaterial();
        material.getSpecularColor(color3f);
        System.out.print("\n (" + ((Tuple3f) (color3f)).x + ", " + ((Tuple3f) (color3f)).y + ", " + ((Tuple3f) (color3f)).z + ")");
        material.getAmbientColor(color3f);
        System.out.print("\n (" + ((Tuple3f) (color3f)).x + ", " + ((Tuple3f) (color3f)).y + ", " + ((Tuple3f) (color3f)).z + ")");
        material.getDiffuseColor(color3f);
        System.out.print("\n (" + ((Tuple3f) (color3f)).x + ", " + ((Tuple3f) (color3f)).y + ", " + ((Tuple3f) (color3f)).z + ")");
        material.getEmissiveColor(color3f);
        System.out.print("\n (" + ((Tuple3f) (color3f)).x + ", " + ((Tuple3f) (color3f)).y + ", " + ((Tuple3f) (color3f)).z + ")");
        System.out.print("\n " + material.getShininess() + " ---- " + nodes.app.getTransparencyAttributes().getTransparency());
        System.out.println();
    }

    public void PrintAppearanceList()
    {
        Color3f color3f = new Color3f();
        for(Nodes nodes = Head; nodes != null; nodes = nodes.next)
            PrintAppearance(nodes.name);

    }

    public Appearance addAppearance(String s)
    {
        Material material = new Material(LTGRY, BLACK, DKGRY, WHITE, 0.6F);
        material.setCapability(1);
        TransparencyAttributes transparencyattributes = new TransparencyAttributes(4, 0.0F);
        transparencyattributes.setCapability(3);
        PolygonAttributes polygonattributes = new PolygonAttributes();
        polygonattributes.setCapability(7);
        polygonattributes.setCullFace(0);
        polygonattributes.setBackFaceNormalFlip(true);
        Appearance appearance = new Appearance();
        appearance.setCapability(15);
        appearance.setMaterial(material);
        appearance.setPolygonAttributes(polygonattributes);
        appearance.setTransparencyAttributes(transparencyattributes);
        Head = new Nodes(appearance, s, Head);
        Current = Head;
        return Current.app;
    }

    public Appearance getAppearance(String s)
    {
        return FindName(s).app;
    }

    public Appearance setAmbient(String s, Color3f color3f)
    {
        FindName(s).app.getMaterial().setAmbientColor(color3f);
        return Current.app;
    }

    public Appearance setDiffuse(String s, Color3f color3f)
    {
        FindName(s).app.getMaterial().setDiffuseColor(color3f);
        return Current.app;
    }

    public Appearance setEmissive(String s, Color3f color3f)
    {
        FindName(s).app.getMaterial().setEmissiveColor(color3f);
        return Current.app;
    }

    public Appearance setShininess(String s, float f)
    {
        FindName(s).app.getMaterial().setShininess(f);
        return Current.app;
    }

    public Appearance setSpecular(String s, Color3f color3f)
    {
        FindName(s).app.getMaterial().setSpecularColor(color3f);
        return Current.app;
    }

    public Appearance setTransparency(String s, float f)
    {
        FindName(s).app.getTransparencyAttributes().setTransparency(f);
        return Current.app;
    }

    public Appearance setTwoSided(String s, boolean flag)
    {
        FindName(s).app.getPolygonAttributes().setCullFace(flag ? 0 : 2);
        if(flag)
            FindName(s).app.getPolygonAttributes().setBackFaceNormalFlip(true);
        return Current.app;
    }

    private Nodes Head;
    private Nodes Current;
    private final Color3f WHITE = new Color3f(1.0F, 1.0F, 1.0F);
    private final Color3f LTGRY = new Color3f(0.7F, 0.7F, 0.7F);
    private final Color3f DKGRY = new Color3f(0.3F, 0.3F, 0.3F);
    private final Color3f BLACK = new Color3f(0.0F, 0.0F, 0.0F);
}
