/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Loader3ds.java

package ncsa.j3d.loaders.load3ds;

import java.io.*;
import javax.media.j3d.BranchGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

// Referenced classes of package ncsa.j3d.loaders.load3ds:
//            AppearanceList, Chunk, Face, Mesh, 
//            ObjectList

public class Loader3ds
{

    public Loader3ds()
    {
        progress = false;
    }

    public BranchGroup Load3ds(Reader reader, boolean flag)
    {
        progress = flag;
        al = new AppearanceList();
        ol = new ObjectList();
        Chunk chunk = readChunk(reader);
        if(chunk.id == 19789)
            Load3dsMain(reader, flag, chunk.length - 6);
        BranchGroup branchgroup = ol.createBranchGroup(al, progress);
        if(progress)
            System.err.println();
        return branchgroup;
    }

    private void Load3dsFaceArray(Reader reader, boolean flag, int i, String s)
    {
        if(progress)
            System.out.print(":");
        int j = readBytes(reader, 2);
        int k = i - 2;
        ol.setNFaces(s, j);
        Face aface[] = new Face[j];
        for(int l = 0; l < j; l++)
        {
            aface[l] = new Face();
            aface[l].vertex[0] = readBytes(reader, 2);
            aface[l].vertex[1] = readBytes(reader, 2);
            aface[l].vertex[2] = readBytes(reader, 2);
            aface[l].flags = readBytes(reader, 2);
            k -= 8;
        }

        boolean flag1 = false;
        if(k > 0)
        {
            Chunk chunk = readChunk(reader);
            k -= 6;
            switch(chunk.id)
            {
            case 16688: 
                String s1 = readString(reader);
                boolean flag2 = true;
                ol.setMaterial(s, s1);
                skipBytes(reader, k - s1.length() - 1);
                break;

            default:
                skipBytes(reader, k);
                break;
            }
        }
        ol.setFaces(s, aface);
        if(progress)
            System.out.print(":");
    }

    private void Load3dsMData(Reader reader, boolean flag, int i)
    {
        if(progress)
            System.out.print("[");
        Chunk chunk;
        for(int j = i; j > 0; j -= chunk.length)
        {
            chunk = readChunk(reader);
            switch(chunk.id)
            {
            case 16384: 
                Load3dsObject(reader, flag, chunk.length - 6);
                break;

            case 45055: 
                Load3dsMaterial(reader, flag, chunk.length - 6);
                break;

            default:
                skipBytes(reader, chunk.length - 6);
                break;
            }
        }

        if(progress)
            System.out.print("]");
    }

    private void Load3dsMain(Reader reader, boolean flag, int i)
    {
        int j = i;
        if(progress)
            System.out.print("{");
        Chunk chunk;
        for(; j > 0; j -= chunk.length)
        {
            chunk = readChunk(reader);
            switch(chunk.id)
            {
            case 15677: 
                Load3dsMData(reader, flag, chunk.length - 6);
                break;

            default:
                skipBytes(reader, chunk.length - 6);
                break;
            }
        }

        if(progress)
            System.out.println("}");
    }

    private void Load3dsMaterial(Reader reader, boolean flag, int i)
    {
        if(progress)
            System.out.print("(");
        int j = i;
        String s = null;
        Chunk chunk;
        for(; j > 0; j -= chunk.length)
        {
            chunk = readChunk(reader);
            switch(chunk.id)
            {
            case 40960: 
                s = readString(reader, chunk.length - 6);
                al.addAppearance(s);
                break;

            case 40976: 
                al.setAmbient(s, getColor(reader, chunk.length - 6));
                break;

            case 40992: 
                al.setDiffuse(s, getColor(reader, chunk.length - 6));
                break;

            case 41008: 
                al.setSpecular(s, getColor(reader, chunk.length - 6));
                break;

            case 41024: 
                al.setShininess(s, getPercent(reader, chunk.length - 6));
                break;

            case 41040: 
                al.setTransparency(s, getPercent(reader, chunk.length - 6));
                break;

            case 41089: 
                al.setTwoSided(s, true);
                skipBytes(reader, chunk.length - 6);
                break;

            default:
                skipBytes(reader, chunk.length - 6);
                break;
            }
        }

        if(progress)
            System.out.print(")");
    }

    private void Load3dsMeshMatrix(Reader reader, boolean flag, int i, String s)
    {
        if(progress)
            System.out.print(":");
        int j = i;
        Mesh mesh = new Mesh();
        for(int k = 0; k < 4; k++)
        {
            for(int l = 0; l < 3; l++)
                mesh.matrix[k][l] = readFloat(reader);

        }

        j -= 48;
        ol.setMesh(s, mesh);
        if(progress)
            System.out.print(":");
    }

    private void Load3dsObject(Reader reader, boolean flag, int i)
    {
        if(progress)
            System.out.print("<");
        int j = i;
        String s = readString(reader);
        Chunk chunk;
        for(j -= s.length() + 1; j > 0; j -= chunk.length)
        {
            chunk = readChunk(reader);
            switch(chunk.id)
            {
            case 16640: 
                Load3dsTriangleObject(reader, flag, chunk.length - 6, s);
                break;

            default:
                skipBytes(reader, chunk.length - 6);
                break;
            }
        }

        if(progress)
            System.out.print(">");
    }

    private void Load3dsPointArray(Reader reader, boolean flag, int i, String s)
    {
        if(progress)
            System.out.print(":");
        int j = readBytes(reader, 2);
        Point3f apoint3f[] = new Point3f[j];
        for(int k = 0; k < j; k++)
        {
            Point3f point3f = new Point3f(readFloat(reader), readFloat(reader), readFloat(reader));
            apoint3f[k] = point3f;
        }

        ol.setPoint(s, apoint3f);
        if(progress)
            System.out.print(":");
    }

    private void Load3dsPointFlagArray(Reader reader, boolean flag, int i, String s)
    {
        if(progress)
            System.out.print(":");
        int j = readBytes(reader, 2);
        int k = i - 2;
        int ai[] = new int[j];
        for(int l = 0; l < j; l++)
        {
            ai[l] = readBytes(reader, 2);
            k -= 2;
        }

        ol.setFlags(s, ai);
        if(progress)
            System.out.print(":");
    }

    private void Load3dsTriangleObject(Reader reader, boolean flag, int i, String s)
    {
        if(progress)
            System.out.print("/");
        Chunk chunk;
        for(int j = i; j > 0; j -= chunk.length)
        {
            chunk = readChunk(reader);
            switch(chunk.id)
            {
            case 16656: 
                Load3dsPointArray(reader, flag, chunk.length - 6, s);
                break;

            case 16657: 
                Load3dsPointFlagArray(reader, flag, chunk.length - 6, s);
                break;

            case 16672: 
                Load3dsFaceArray(reader, flag, chunk.length - 6, s);
                break;

            case 16736: 
                Load3dsMeshMatrix(reader, flag, chunk.length - 6, s);
                break;

            default:
                skipBytes(reader, chunk.length - 6);
                break;
            }
        }

        if(progress)
            System.out.print("\\");
    }

    private void PrintChunk(Chunk chunk, boolean flag)
    {
        int i = Integer.toHexString(chunk.id).length();
        System.out.print(" 0x");
        for(int j = 0; j < 4 - i; j++)
            System.out.print("0");

        System.out.print(Integer.toHexString(chunk.id) + ":" + chunk.length + (flag ? "\n" : " "));
    }

    private Color3f getColor(Reader reader, int i)
    {
        float af[] = new float[3];
        Chunk chunk = readChunk(reader);
        switch(chunk.id)
        {
        case 16: // '\020'
        case 18: // '\022'
            af[0] = readFloat(reader);
            af[1] = readFloat(reader);
            af[2] = readFloat(reader);
            readBytes(reader, chunk.length - 6 - 12);
            break;

        case 17: // '\021'
        case 19: // '\023'
            af[0] = (float)readBytes(reader, 1) / 255F;
            af[1] = (float)readBytes(reader, 1) / 255F;
            af[2] = (float)readBytes(reader, 1) / 255F;
            readBytes(reader, chunk.length - 6 - 3);
            break;

        default:
            af[0] = 0.0F;
            af[1] = 0.0F;
            af[2] = 0.0F;
            readBytes(reader, i - 6);
            break;
        }
        return new Color3f(af[0], af[1], af[2]);
    }

    private float getPercent(Reader reader, int i)
    {
        float f = 0.0F;
        Chunk chunk = readChunk(reader);
        switch(chunk.id)
        {
        case 48: // '0'
            f = (float)readBytes(reader, 2) / 4095F;
            break;

        case 49: // '1'
            f = readFloat(reader);
            break;

        default:
            readBytes(reader, i - 6);
            break;
        }
        return f;
    }

    private Chunk printChunk(Chunk chunk)
    {
        System.out.print(Integer.toHexString(chunk.id) + " -- " + chunk.length + ":");
        return chunk;
    }

    private int readBytes(Reader reader, int i)
    {
        int j = 0;
        for(int k = 0; k < i; k++)
            try
            {
                j += reader.read() << 8 * k;
            }
            catch(IOException ioexception)
            {
                System.err.println("Error with file.\n" + ioexception.toString());
                System.exit(1);
            }

        return j;
    }

    private char readChar(Reader reader)
    {
        return (char)readBytes(reader, 1);
    }

    private Chunk readChunk(Reader reader)
    {
        int i = readBytes(reader, 2);
        int j = readBytes(reader, 4);
        return new Chunk(i, j);
    }

    private float readFloat(Reader reader)
    {
        return Float.intBitsToFloat(readBytes(reader, 4));
    }

    private String readString(Reader reader)
    {
        String s = new String();
        for(int i = readChar(reader); i > 0; i = readChar(reader))
            s = s + (char)i;

        return s;
    }

    private String readString(Reader reader, int i)
    {
        String s = new String();
        for(int j = 0; j < i; j++)
            s = s + readChar(reader);

        return s;
    }

    private void skipBytes(Reader reader, int i)
    {
        for(int j = 0; j < i; j++)
            try
            {
                reader.read();
            }
            catch(IOException ioexception)
            {
                System.err.println("Error with file.\n" + ioexception.toString());
                System.exit(1);
            }

    }

    private AppearanceList al;
    private ObjectList ol;
    private boolean progress;
}
