/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ObjectList.java

package ncsa.j3d.loaders.load3ds;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.io.PrintStream;
import javax.media.j3d.*;
import javax.vecmath.Point3f;

// Referenced classes of package ncsa.j3d.loaders.load3ds:
//            AppearanceList, Face, Mesh

class ObjectList
{
    class Nodes
    {

        public String material;
        public Point3f point[];
        public int flags[];
        public Mesh mesh;
        public Face faceArray[];
        public int nfaces;
        public String name;
        public Nodes next;

        Nodes(Point3f apoint3f[], int ai[], Mesh mesh1, Face aface[], String s, Nodes nodes, 
                int i)
        {
            point = apoint3f;
            flags = ai;
            mesh = mesh1;
            faceArray = aface;
            name = s;
            next = nodes;
            material = null;
            nfaces = i;
        }
    }


    public ObjectList()
    {
        Head = null;
        Current = null;
    }

    private Nodes FindName(String s)
    {
        if(s == null)
            s = new String("");
        if(Current != null && s.compareTo(Current.name) == 0)
            return Current;
        for(Current = Head; Current != null && s.compareTo(Current.name) != 0; Current = Current.next);
        if(Current == null)
            addObject(s);
        return Current;
    }

    public String addObject(String s)
    {
        Head = new Nodes(null, null, null, null, s, Head, 0);
        Current = Head;
        return Current.name;
    }

    public BranchGroup createBranchGroup(AppearanceList appearancelist, boolean flag)
    {
        if(flag)
            System.out.print("[");
        AppearanceList appearancelist1 = appearancelist;
        BranchGroup branchgroup = new BranchGroup();
        for(Nodes nodes = Head; nodes != null; nodes = nodes.next)
        {
            if(flag)
                System.out.print("(" + nodes.name + ", " + nodes.point.length + ")");
            Shape3D shape3d = createBranchGroup(nodes, appearancelist1);
            if(shape3d != null)
                branchgroup.addChild(shape3d);
        }

        if(flag)
            System.out.print("]");
        return branchgroup;
    }

    private Shape3D createBranchGroup(Nodes nodes, AppearanceList appearancelist)
    {
        AppearanceList appearancelist1 = appearancelist;
        if(nodes.faceArray.length >= 3)
        {
            GeometryInfo geometryinfo = new GeometryInfo(5);
            geometryinfo.setCoordinates(nodes.point);
            int ai[] = new int[nodes.faceArray.length * 3];
            int ai1[] = new int[nodes.faceArray.length];
            for(int i = 0; i < nodes.faceArray.length; i++)
            {
                ai[3 * i] = nodes.faceArray[i].vertex[0];
                ai[3 * i + 1] = nodes.faceArray[i].vertex[1];
                ai[3 * i + 2] = nodes.faceArray[i].vertex[2];
                ai1[i] = 3;
            }

            geometryinfo.setCoordinateIndices(ai);
            geometryinfo.setStripCounts(ai1);
            NormalGenerator normalgenerator = new NormalGenerator();
            normalgenerator.generateNormals(geometryinfo);
            return new Shape3D(geometryinfo.getGeometryArray(), appearancelist1.getAppearance(nodes.material));
        } else
        {
            return null;
        }
    }

    public Face[] getFaces(String s)
    {
        return FindName(s).faceArray;
    }

    public int[] getFlags(String s)
    {
        return FindName(s).flags;
    }

    public Mesh getMesh(String s)
    {
        return FindName(s).mesh;
    }

    public int getNFaces(String s)
    {
        return FindName(s).nfaces;
    }

    public Point3f[] getPoint(String s)
    {
        return FindName(s).point;
    }

    public String setFaces(String s, Face aface[])
    {
        FindName(s).faceArray = aface;
        return Current.name;
    }

    public String setFlags(String s, int ai[])
    {
        FindName(s).flags = ai;
        return Current.name;
    }

    public String setMaterial(String s, String s1)
    {
        FindName(s).material = s1;
        return Current.name;
    }

    public String setMesh(String s, Mesh mesh)
    {
        FindName(s).mesh = mesh;
        return Current.name;
    }

    public String setNFaces(String s, int i)
    {
        FindName(s).nfaces = i;
        return Current.name;
    }

    public String setPoint(String s, Point3f apoint3f[])
    {
        FindName(s).point = apoint3f;
        return Current.name;
    }

    private Nodes Head;
    private Nodes Current;
}
