/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   AppearanceList.java

package ncsa.j3d.loaders.loadCOB;

import javax.media.j3d.*;
import javax.vecmath.Color3f;

class AppearanceList
{
    class Nodes
    {

        public Appearance app;
        public int id;
        public Nodes next;

        Nodes(Appearance appearance, int i, Nodes nodes)
        {
            app = appearance;
            id = i;
            next = nodes;
        }
    }


    public AppearanceList()
    {
        Head = null;
        Current = null;
    }

    private Nodes FindName(int i)
    {
        if(Current != null && i == Current.id)
            return Current;
        for(Current = Head; Current != null && i != Current.id; Current = Current.next);
        if(Current == null)
            addAppearance(i);
        return Current;
    }

    public Appearance addAppearance(int i)
    {
        Material material = new Material(LTGRY, BLACK, DKGRY, WHITE, 0.6F);
        material.setCapability(1);
        TransparencyAttributes transparencyattributes = new TransparencyAttributes(4, 0.0F);
        transparencyattributes.setCapability(3);
        PolygonAttributes polygonattributes = new PolygonAttributes();
        polygonattributes.setCapability(7);
        polygonattributes.setCullFace(0);
        polygonattributes.setBackFaceNormalFlip(true);
        Appearance appearance = new Appearance();
        appearance.setCapability(15);
        appearance.setMaterial(material);
        appearance.setPolygonAttributes(polygonattributes);
        appearance.setTransparencyAttributes(transparencyattributes);
        Head = new Nodes(appearance, i, Head);
        Current = Head;
        return Current.app;
    }

    public Appearance getAppearance(int i)
    {
        return FindName(i).app;
    }

    public Appearance setAmbient(int i, Color3f color3f)
    {
        FindName(i).app.getMaterial().setAmbientColor(color3f);
        return Current.app;
    }

    public Appearance setDiffuse(int i, Color3f color3f)
    {
        FindName(i).app.getMaterial().setDiffuseColor(color3f);
        return Current.app;
    }

    public Appearance setEmissive(int i, Color3f color3f)
    {
        FindName(i).app.getMaterial().setEmissiveColor(color3f);
        return Current.app;
    }

    public Appearance setShininess(int i, float f)
    {
        FindName(i).app.getMaterial().setShininess(f);
        return Current.app;
    }

    public Appearance setSpecular(int i, Color3f color3f)
    {
        FindName(i).app.getMaterial().setSpecularColor(color3f);
        return Current.app;
    }

    public Appearance setTransparency(int i, float f)
    {
        FindName(i).app.getTransparencyAttributes().setTransparency(f);
        return Current.app;
    }

    public Appearance setTwoSided(int i, boolean flag)
    {
        FindName(i).app.getPolygonAttributes().setCullFace(flag ? 0 : 2);
        return Current.app;
    }

    private Nodes Head;
    private Nodes Current;
    public final Color3f WHITE = new Color3f(1.0F, 1.0F, 1.0F);
    public final Color3f LTGRY = new Color3f(0.7F, 0.7F, 0.7F);
    public final Color3f DKGRY = new Color3f(0.3F, 0.3F, 0.3F);
    public final Color3f BLACK = new Color3f(0.0F, 0.0F, 0.0F);
}
