/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   FileReader.java

package ncsa.j3d.loaders.loadCOB;

import java.io.*;
import javax.vecmath.*;

// Referenced classes of package ncsa.j3d.loaders.loadCOB:
//            AppearanceList, Chunk, Poly

public class FileReader
{

    public FileReader(Reader reader1)
    {
        reader = reader1;
    }

    public float ToFloat(String s)
    {
        return Float.valueOf(s).floatValue();
    }

    public int ToInt(String s)
    {
        return Integer.parseInt(s);
    }

    public int readBytes(int i)
    {
        int j = 0;
        for(int k = 0; k < i; k++)
            try
            {
                j += reader.read() << 8 * k;
            }
            catch(IOException ioexception)
            {
                System.err.println("Error with file.\n" + ioexception.toString());
                System.exit(1);
            }

        return j;
    }

    public char readChar()
    {
        return (char)readBytes(1);
    }

    public Chunk readChunk(boolean flag)
    {
        Chunk chunk = new Chunk();
        if(flag)
        {
            chunk.type = readString(4);
            skipBytes(4);
            chunk.id = readBytes(4);
            chunk.pid = readBytes(4);
            chunk.length = readBytes(4);
        } else
        {
            chunk.type = readString(4);
            readString();
            readString();
            chunk.id = readStringToInt();
            readString();
            chunk.pid = readStringToInt();
            readString();
            chunk.length = readStringToInt();
        }
        return chunk;
    }

    public float readFloat()
    {
        return Float.intBitsToFloat(readBytes(4));
    }

    public AppearanceList readMaterial(AppearanceList appearancelist, boolean flag, int i, int j)
    {
        AppearanceList appearancelist1 = appearancelist;
        float f;
        float f1;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        int k;
        if(flag)
        {
            k = readBytes(2) + i;
            skipBytes(3);
            f = readFloat();
            f1 = readFloat();
            f2 = readFloat();
            f3 = readFloat();
            f4 = readFloat();
            f5 = readFloat();
            f6 = readFloat();
            skipBytes(j - 33);
        } else
        {
            int l = 61;
            readString();
            String s = readString();
            l += s.length();
            k = ToInt(s) + i;
            readString();
            l += readString().length();
            readString();
            l += readString().length();
            readString();
            s = readToChar(',', false);
            l += s.length();
            f = ToFloat(s);
            s = readToChar(',', false);
            l += s.length();
            f1 = ToFloat(s);
            s = readToChar(',', false);
            l += s.length();
            f2 = ToFloat(s);
            readString();
            s = readString();
            l += s.length();
            f3 = ToFloat(s);
            readString();
            s = readString();
            l += s.length();
            f4 = ToFloat(s);
            readString();
            s = readString();
            l += s.length();
            f5 = ToFloat(s);
            readString();
            s = readString();
            l += s.length();
            f6 = ToFloat(s);
            readString();
            l += readString().length();
            skipBytes(j - l);
        }
        appearancelist1.addAppearance(k);
        appearancelist1.setTransparency(k, f3);
        appearancelist1.setAmbient(k, new Color3f(f * f4, f1 * f4, f2 * f4));
        appearancelist1.setDiffuse(k, new Color3f(f, f1, f2));
        appearancelist1.setSpecular(k, new Color3f(f * f5, f1 * f5, f2 * f5));
        appearancelist1.setShininess(k, f6);
        return appearancelist1;
    }

    public Poly readPolH(boolean flag)
    {
        Poly poly = new Poly();
        if(flag)
        {
            poly.dupCount = readBytes(2);
            poly.name = readString(readBytes(2));
            poly.center = new Point3f(readFloat(), readFloat(), readFloat());
            poly.Axes[0] = new Vector3f(readFloat(), readFloat(), readFloat());
            poly.Axes[1] = new Vector3f(readFloat(), readFloat(), readFloat());
            poly.Axes[2] = new Vector3f(readFloat(), readFloat(), readFloat());
            poly.currentPos = new Matrix4f(readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), readFloat(), 0.0F, 0.0F, 0.0F, 1.0F);
            int i = readBytes(4);
            poly.Verticies = new Point3f[i];
            for(int j = 0; j < i; j++)
                poly.Verticies[j] = new Point3f(readFloat(), readFloat(), readFloat());

            i = readBytes(4);
            for(int l = 0; l < i; l++)
                skipBytes(8);

            i = readBytes(4);
            poly.Faces = new int[i][];
            for(int j1 = 0; j1 < i; j1++)
            {
                int l1 = readBytes(1);
                if((l1 & 8) != 8)
                {
                    int j2 = readBytes(2);
                    poly.Material = readBytes(2);
                    poly.Faces[j1] = new int[j2];
                    for(int j3 = 0; j3 < j2; j3++)
                    {
                        poly.Faces[j1][j3] = readBytes(4);
                        if(poly.Faces[j1][j3] < 0)
                        {
                            poly.Faces[j1] = null;
                            return poly;
                        }
                        skipBytes(4);
                    }

                } else
                {
                    int k2 = readBytes(2);
                    for(int k3 = 0; k3 < k2; k3++)
                        skipBytes(8);

                }
            }

        } else
        {
            readString();
            String s;
            for(s = readToChar(',', true); s.charAt(s.length() - 1) == ' '; s = s + readToChar(',', true));
            if(s.charAt(s.length() - 1) == ',')
                poly.dupCount = readStringToInt();
            poly.name = s.substring(0, s.length() - 1);
            readString();
            poly.center = new Point3f(readStringToFloat(), readStringToFloat(), readStringToFloat());
            readString();
            readString();
            poly.Axes[0] = new Vector3f(readStringToFloat(), readStringToFloat(), readStringToFloat());
            readString();
            readString();
            poly.Axes[1] = new Vector3f(readStringToFloat(), readStringToFloat(), readStringToFloat());
            readString();
            readString();
            poly.Axes[2] = new Vector3f(readStringToFloat(), readStringToFloat(), readStringToFloat());
            readString();
            poly.currentPos = new Matrix4f(readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat(), readStringToFloat());
            readString();
            readString();
            int k = readStringToInt();
            poly.Verticies = new Point3f[k];
            for(int i1 = 0; i1 < k; i1++)
                poly.Verticies[i1] = new Point3f(readStringToFloat(), readStringToFloat(), readStringToFloat());

            readString();
            readString();
            k = readStringToInt();
            for(int k1 = 0; k1 < k; k1++)
            {
                readString();
                readString();
            }

            readString();
            k = readStringToInt();
            poly.Faces = new int[k][];
            for(int i2 = 0; i2 < k; i2++)
                if(readString().compareTo("Face") == 0)
                {
                    readString();
                    int l2 = readStringToInt();
                    readString();
                    int l3 = readStringToInt();
                    readString();
                    poly.Material = readStringToInt();
                    poly.Faces[i2] = new int[l2];
                    for(int j4 = 0; j4 < l2; j4++)
                    {
                        readToChar('<', false);
                        poly.Faces[i2][j4] = Integer.parseInt(readToChar(',', false));
                        readString();
                    }

                } else
                {
                    readString();
                    int i3 = readStringToInt();
                    for(int i4 = 0; i4 < i3; i4++)
                        readString();

                }

            skipBytes(1);
        }
        return poly;
    }

    public String readString()
    {
        String s = new String();
        int i;
        for(i = readChar(); i <= 32; i = readChar());
        for(; i > 32 && i < 256; i = readChar())
            s = s + (char)i;

        return s;
    }

    public String readString(int i)
    {
        String s = new String();
        for(int j = 0; j < i; j++)
            s = s + readChar();

        s = s;
        return s;
    }

    public float readStringToFloat()
    {
        return Float.valueOf(readString()).floatValue();
    }

    public float readStringToFloat(char c)
    {
        return Float.valueOf(readToChar(c, false)).floatValue();
    }

    public int readStringToInt()
    {
        return Integer.parseInt(readString());
    }

    public String readToChar(char c, boolean flag)
    {
        String s = new String();
        int i;
        for(i = readChar(); i <= 32; i = readChar());
        for(; i > 32 && i < 256 && i != c; i = readChar())
            s = s + (char)i;

        if(flag)
            s = s + (char)i;
        return s;
    }

    public void skipBytes(int i)
    {
        for(int j = 0; j < i; j++)
            try
            {
                reader.read();
            }
            catch(IOException ioexception)
            {
                System.err.println("Error with file.\n" + ioexception.toString());
                System.exit(1);
            }

    }

    private Reader reader;
}
