/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   LoaderCOB.java

package ncsa.j3d.loaders.loadCOB;

import com.sun.j3d.utils.geometry.*;
import java.io.Reader;
import javax.media.j3d.*;

// Referenced classes of package ncsa.j3d.loaders.loadCOB:
//            AppearanceList, Chunk, FileReader, ObjectList, 
//            Poly

public class LoaderCOB
{

    public LoaderCOB()
    {
    }

    public BranchGroup CreateBranchGroup(ObjectList objectlist, AppearanceList appearancelist)
    {
        BranchGroup branchgroup = new BranchGroup();
        for(Poly poly = objectlist.Start(); !objectlist.isDone(); poly = objectlist.Next())
            branchgroup.addChild(CreateBranchGroup(poly, appearancelist, objectlist.CurrentId()));

        return branchgroup;
    }

    public TransformGroup CreateBranchGroup(Poly poly, AppearanceList appearancelist, int i)
    {
        GeometryInfo geometryinfo = new GeometryInfo(5);
        geometryinfo.setCoordinates(poly.Verticies);
        int j = 0;
        int k = 0;
        for(int l = 0; l < poly.Faces.length; l++)
            if(poly.Faces[l] != null)
            {
                j++;
                k += poly.Faces[l].length;
            }

        int ai[] = new int[j];
        int ai1[] = new int[k];
        int i1 = 0;
        int j1 = 0;
        for(int k1 = 0; k1 < poly.Faces.length; k1++)
            if(poly.Faces[k1] != null)
            {
                ai[i1] = poly.Faces[k1].length;
                i1++;
                for(int l1 = 0; l1 < poly.Faces[k1].length; l1++)
                {
                    ai1[j1] = poly.Faces[k1][poly.Faces[k1].length - (l1 + 1)];
                    j1++;
                }

            }

        geometryinfo.setCoordinateIndices(ai1);
        geometryinfo.setStripCounts(ai);
        Triangulator triangulator = new Triangulator();
        triangulator.triangulate(geometryinfo);
        NormalGenerator normalgenerator = new NormalGenerator();
        normalgenerator.generateNormals(geometryinfo);
        BranchGroup branchgroup = new BranchGroup();
        Transform3D transform3d = new Transform3D(poly.currentPos);
        TransformGroup transformgroup = new TransformGroup(transform3d);
        transformgroup.addChild(branchgroup);
        javax.media.j3d.Appearance appearance = appearancelist.getAppearance(i + poly.Material);
        branchgroup.addChild(new Shape3D(geometryinfo.getGeometryArray(), appearance));
        return transformgroup;
    }

    public BranchGroup LoadCOB(Reader reader)
    {
        FileReader filereader = new FileReader(reader);
        AppearanceList appearancelist = new AppearanceList();
        ObjectList objectlist = new ObjectList();
        boolean flag = readHeader(filereader);
        for(Chunk chunk = filereader.readChunk(flag); chunk.type.compareTo("END ") != 0 && chunk.id >= 0; chunk = filereader.readChunk(flag))
            if(chunk.type.compareTo("PolH") == 0)
                objectlist.setPoly(chunk.id, filereader.readPolH(flag));
            else
            if(chunk.type.compareTo("Mat1") == 0)
                appearancelist = filereader.readMaterial(appearancelist, flag, chunk.pid, chunk.length);
            else
                filereader.skipBytes(flag ? chunk.length : chunk.length - 1);

        BranchGroup branchgroup = CreateBranchGroup(objectlist, appearancelist);
        return branchgroup;
    }

    private boolean readHeader(FileReader filereader)
    {
        filereader.readBytes(15);
        boolean flag = filereader.readChar() == 'B';
        filereader.readBytes(16);
        return flag;
    }
}
