/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ObjectList.java

package ncsa.j3d.loaders.loadCOB;

import javax.vecmath.*;

// Referenced classes of package ncsa.j3d.loaders.loadCOB:
//            Poly

class ObjectList
{
    class Nodes
    {

        public Poly pgon;
        public int id;
        public Nodes next;

        Nodes(Poly poly, Nodes nodes, int i)
        {
            pgon = poly;
            next = nodes;
            id = i;
        }
    }


    public ObjectList()
    {
        Head = null;
        Current = null;
    }

    public Poly Current()
    {
        if(Current != null)
            return Current.pgon;
        else
            return null;
    }

    public int CurrentId()
    {
        if(Current == null)
            return -1;
        else
            return Current.id;
    }

    private Nodes FindName(int i)
    {
        if(Current != null && i == Current.id)
            return Current;
        for(Current = Head; Current != null && i != Current.id; Current = Current.next);
        if(Current == null)
            addObject(i);
        return Current;
    }

    public Poly Next()
    {
        if(Current != null)
            Current = Current.next;
        return Current();
    }

    public Poly Start()
    {
        Current = Head;
        return Current();
    }

    public int addObject(int i)
    {
        Head = new Nodes(new Poly(), Head, i);
        Current = Head;
        return Current.id;
    }

    public Vector3f[] getAxes(int i)
    {
        return FindName(i).pgon.Axes;
    }

    public Point3f getCenter(int i)
    {
        return FindName(i).pgon.center;
    }

    public Matrix4f getCurrentPos(int i)
    {
        return FindName(i).pgon.currentPos;
    }

    public int getDupCount(int i)
    {
        return FindName(i).pgon.dupCount;
    }

    public int[][] getFaces(int i)
    {
        return FindName(i).pgon.Faces;
    }

    public int getMaterial(int i)
    {
        return FindName(i).pgon.Material;
    }

    public String getName(int i)
    {
        return FindName(i).pgon.name;
    }

    public Poly getPoly(int i)
    {
        return FindName(i).pgon;
    }

    public Point3f[] getVerticies(int i)
    {
        return FindName(i).pgon.Verticies;
    }

    public boolean isDone()
    {
        return Current == null;
    }

    public int setAxes(int i, Vector3f avector3f[])
    {
        FindName(i).pgon.Axes = avector3f;
        return Current.id;
    }

    public int setCenter(int i, Point3f point3f)
    {
        FindName(i).pgon.center = point3f;
        return Current.id;
    }

    public int setCurrentPos(int i, Matrix4f matrix4f)
    {
        FindName(i).pgon.currentPos = matrix4f;
        return Current.id;
    }

    public int setDupCount(int i, int j)
    {
        FindName(i).pgon.dupCount = j;
        return Current.id;
    }

    public int setFaces(int i, int ai[][])
    {
        FindName(i).pgon.Faces = ai;
        return Current.id;
    }

    public int setMaterial(int i, int j)
    {
        FindName(i).pgon.Material = j;
        return Current.id;
    }

    public int setName(int i, String s)
    {
        FindName(i).pgon.name = s;
        return Current.id;
    }

    public int setPoly(int i, Poly poly)
    {
        FindName(i).pgon = poly;
        return Current.id;
    }

    public int setVerticies(int i, Point3f apoint3f[])
    {
        FindName(i).pgon.Verticies = apoint3f;
        return Current.id;
    }

    private Nodes Head;
    private Nodes Current;
}
