/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   LoaderIOB.java

package ncsa.j3d.loaders.loadIOB;

import java.io.*;
import javax.media.j3d.BranchGroup;
import javax.vecmath.*;

// Referenced classes of package ncsa.j3d.loaders.loadIOB:
//            AppearanceList, Chunk, ObjectList

public class LoaderIOB
{

    public LoaderIOB()
    {
    }

    public BranchGroup LoadIOB(Reader reader)
    {
        al = new AppearanceList();
        ol = new ObjectList();
        readBytes(reader, 12);
        mainCall(reader, 1);
        BranchGroup branchgroup = ol.createBranchGroup(al);
        return branchgroup;
    }

    private int descCall(Reader reader, int i, int j)
    {
        int k = i;
        al.addAppearance(j);
        ol.addObject(j);
        while(k > 0) 
        {
            Chunk chunk = readChunk(reader);
            int l = 0;
            switch(chunk.name.charAt(0))
            {
            case 67: // 'C'
                if(chunk.name.compareTo("COLR") == 0)
                {
                    Color3f color3f = readColor(reader);
                    al.setAmbient(j, new Color3f(((Tuple3f) (color3f)).x * 0.4F, ((Tuple3f) (color3f)).y * 0.4F, ((Tuple3f) (color3f)).z * 0.4F));
                    al.setDiffuse(j, new Color3f(((Tuple3f) (color3f)).x * 0.7F, ((Tuple3f) (color3f)).y * 0.7F, ((Tuple3f) (color3f)).z * 0.7F));
                    al.setEmissive(j, al.BLACK);
                    al.setSpecular(j, color3f);
                    l = chunk.length;
                }
                break;

            case 69: // 'E'
                if(chunk.name.compareTo("EDGE") == 0)
                {
                    int i1 = readBytes(reader, 2);
                    int ai[][] = new int[i1][2];
                    for(int l1 = 0; l1 < i1; l1++)
                    {
                        ai[l1][0] = readBytes(reader, 2);
                        ai[l1][1] = readBytes(reader, 2);
                    }

                    ol.setEdges(j, ai);
                    l = chunk.length;
                }
                break;

            case 70: // 'F'
                if(chunk.name.compareTo("FACE") == 0)
                {
                    int j1 = readBytes(reader, 2);
                    int ai1[][] = new int[j1][3];
                    for(int i2 = 0; i2 < j1; i2++)
                    {
                        ai1[i2][0] = readBytes(reader, 2);
                        ai1[i2][1] = readBytes(reader, 2);
                        ai1[i2][2] = readBytes(reader, 2);
                    }

                    ol.setFaces(j, ai1);
                    l = chunk.length;
                }
                break;

            case 80: // 'P'
                if(chunk.name.compareTo("PNTS") == 0)
                {
                    int k1 = readBytes(reader, 2);
                    Point3f apoint3f[] = new Point3f[k1];
                    for(int j2 = 0; j2 < k1; j2++)
                        apoint3f[j2] = readPoint(reader);

                    ol.setPoint(j, apoint3f);
                    l = chunk.length;
                }
                break;

            case 84: // 'T'
                if(chunk.name.compareTo("TRAN") == 0)
                {
                    Color3f color3f1 = readColor(reader);
                    al.setTransparency(j, ((Tuple3f) (al.getSpecular(j))).x / ((Tuple3f) (color3f1)).x);
                    l = chunk.length;
                }
                break;
            }
            if(chunk.length - l > 0)
                readBytes(reader, chunk.length - l);
            k -= chunk.length + 8;
            if(chunk.length % 2 == 1)
            {
                readBytes(reader, 1);
                k--;
            }
        }
        return k;
    }

    private int mainCall(Reader reader, int i)
    {
        int j;
        for(j = i; j > 0;)
        {
            Chunk chunk = readChunk(reader);
            if(chunk.name.compareTo("OBJ ") == 0)
                objCall(reader, chunk.length);
            else
                readBytes(reader, chunk.length);
            j -= chunk.length + 8;
            if(chunk.length % 2 == 1)
            {
                readBytes(reader, 1);
                j--;
            }
        }

        return j;
    }

    private int objCall(Reader reader, int i)
    {
        int j;
        for(j = i; j > 0;)
        {
            Chunk chunk = readChunk(reader);
            if(chunk.name.compareTo("DESC") == 0)
                descCall(reader, chunk.length, objID++);
            else
                readBytes(reader, chunk.length);
            j -= chunk.length + 8;
            if(chunk.length % 2 == 1)
            {
                readBytes(reader, 1);
                j--;
            }
        }

        return j;
    }

    private Chunk printChunk(Chunk chunk)
    {
        System.out.print(chunk.name + " -- " + chunk.length);
        return chunk;
    }

    private int readBytes(Reader reader, int i)
    {
        int j = 0;
        for(int k = 0; k < i; k++)
            try
            {
                j = reader.read() + (j << 8);
            }
            catch(IOException ioexception)
            {
                System.err.println("Error with file.\n" + ioexception.toString());
                System.exit(1);
            }

        return j;
    }

    private char readChar(Reader reader)
    {
        return (char)readBytes(reader, 1);
    }

    private Chunk readChunk(Reader reader)
    {
        String s = readString(reader, 4);
        int i = readBytes(reader, 4);
        return new Chunk(s, i);
    }

    private Color3f readColor(Reader reader)
    {
        readBytes(reader, 1);
        return new Color3f((float)readBytes(reader, 1) / 256F, (float)readBytes(reader, 1) / 256F, (float)readBytes(reader, 1) / 256F);
    }

    private float readFloat(Reader reader)
    {
        return Float.intBitsToFloat(readBytes(reader, 4));
    }

    private Point3f readPoint(Reader reader)
    {
        return new Point3f((float)readBytes(reader, 4) / 65536F, (float)readBytes(reader, 4) / 65536F, (float)readBytes(reader, 4) / 65536F);
    }

    private String readString(Reader reader)
    {
        String s = new String();
        for(int i = readChar(reader); i > 0; i = readChar(reader))
            s = s + (char)i;

        return s;
    }

    private String readString(Reader reader, int i)
    {
        String s = new String();
        for(int j = 0; j < i; j++)
            s = s + readChar(reader);

        s = s;
        return s;
    }

    private Vector3f readVector(Reader reader)
    {
        return new Vector3f((float)readBytes(reader, 4) / 65536F, (float)readBytes(reader, 4) / 65536F, (float)readBytes(reader, 4) / 65536F);
    }

    private void skipBytes(Reader reader, int i)
    {
        for(int j = 0; j < i; j++)
            try
            {
                reader.read();
            }
            catch(IOException ioexception)
            {
                System.err.println("Error with file.\n" + ioexception.toString());
                System.exit(1);
            }

    }

    private AppearanceList al;
    private ObjectList ol;
    private static int objID = 0;

}
