/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   ObjectList.java

package ncsa.j3d.loaders.loadIOB;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.*;
import javax.vecmath.Point3f;

// Referenced classes of package ncsa.j3d.loaders.loadIOB:
//            AppearanceList

class ObjectList
{
    class Nodes
    {

        public String material;
        public Point3f point[];
        public int edges[][];
        public int faces[][];
        public int nfaces;
        public int id;
        public Nodes next;

        Nodes(Point3f apoint3f[], int ai[][], int ai1[][], int i, Nodes nodes, int j)
        {
            point = apoint3f;
            edges = ai;
            faces = ai1;
            id = i;
            next = nodes;
            material = null;
            nfaces = j;
        }
    }


    public ObjectList()
    {
        Head = null;
        Current = null;
    }

    private Nodes FindName(int i)
    {
        if(Current != null && i == Current.id)
            return Current;
        for(Current = Head; Current != null && i != Current.id; Current = Current.next);
        if(Current == null)
            addObject(i);
        return Current;
    }

    public int addObject(int i)
    {
        Head = new Nodes(null, null, null, i, Head, 0);
        Current = Head;
        return Current.id;
    }

    public BranchGroup createBranchGroup(AppearanceList appearancelist)
    {
        AppearanceList appearancelist1 = appearancelist;
        BranchGroup branchgroup = new BranchGroup();
        for(Nodes nodes = Head; nodes != null; nodes = nodes.next)
        {
            Shape3D shape3d = null;
            if(nodes.point != null)
                shape3d = createBranchGroup(nodes, appearancelist1);
            if(shape3d != null)
                branchgroup.addChild(shape3d);
        }

        return branchgroup;
    }

    private Shape3D createBranchGroup(Nodes nodes, AppearanceList appearancelist)
    {
        AppearanceList appearancelist1 = appearancelist;
        if(nodes.faces != null && nodes.edges != null && nodes.faces.length > 0 && nodes.edges.length > 0)
        {
            GeometryInfo geometryinfo = new GeometryInfo(5);
            geometryinfo.setCoordinates(nodes.point);
            int ai[] = new int[nodes.faces.length * 3];
            int ai1[] = new int[nodes.faces.length];
            for(int i = 0; i < nodes.faces.length; i++)
                if(nodes.faces[i][0] < nodes.edges.length && nodes.faces[i][1] < nodes.edges.length)
                {
                    ai[3 * i] = nodes.edges[nodes.faces[i][0]][1];
                    ai[3 * i + 1] = nodes.edges[nodes.faces[i][0]][0];
                    ai[3 * i + 2] = nodes.edges[nodes.faces[i][1]][0] != nodes.edges[nodes.faces[i][0]][0] && nodes.edges[nodes.faces[i][1]][0] != nodes.edges[nodes.faces[i][0]][1] ? nodes.edges[nodes.faces[i][1]][0] : nodes.edges[nodes.faces[i][1]][1];
                    ai1[i] = 3;
                } else
                {
                    ai[3 * i] = ai[3 * i - 3];
                    ai[3 * i + 1] = ai[(3 * i - 3) + 1];
                    ai[3 * i + 2] = ai[(3 * i - 3) + 2];
                    ai1[i] = 3;
                }

            geometryinfo.setCoordinateIndices(ai);
            geometryinfo.setStripCounts(ai1);
            NormalGenerator normalgenerator = new NormalGenerator();
            normalgenerator.generateNormals(geometryinfo);
            return new Shape3D(geometryinfo.getGeometryArray(), appearancelist1.getAppearance(nodes.id));
        } else
        {
            return null;
        }
    }

    public int[][] getEdges(int i)
    {
        return FindName(i).edges;
    }

    public int[][] getFaces(int i)
    {
        return FindName(i).faces;
    }

    public int getNFaces(int i)
    {
        return FindName(i).nfaces;
    }

    public Point3f[] getPoint(int i)
    {
        return FindName(i).point;
    }

    public int setEdges(int i, int ai[][])
    {
        FindName(i).edges = ai;
        return Current.id;
    }

    public int setFaces(int i, int ai[][])
    {
        FindName(i).faces = ai;
        return Current.id;
    }

    public int setMaterial(int i, String s)
    {
        FindName(i).material = s;
        return Current.id;
    }

    public int setNFaces(int i, int j)
    {
        FindName(i).nfaces = j;
        return Current.id;
    }

    public int setPoint(int i, Point3f apoint3f[])
    {
        FindName(i).point = apoint3f;
        return Current.id;
    }

    private Nodes Head;
    private Nodes Current;
}
