/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   NFFLoader.java

package ncsa.j3d.loaders.nff;

import com.sun.j3d.utils.geometry.*;
import java.io.PrintStream;
import java.io.Reader;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.util.ReaderTokenizer;

public class NFFLoader
{

    public NFFLoader()
    {
        debug = false;
        currentApp = new Appearance();
        polygons_total = 0;
    }

    public BranchGroup LoadNFF(Reader reader)
    {
        bg = new BranchGroup();
        bg.setCapability(3);
        fis = new ReaderTokenizer(reader);
        TransformGroup transformgroup = new TransformGroup();
        bg.addChild(transformgroup);
        parseFile();
        return bg;
    }

    private void addCylinder()
    {
        Vector3f vector3f = new Vector3f();
        fis.nextToken();
        vector3f.x = (float)fis.nval;
        fis.nextToken();
        vector3f.y = (float)fis.nval;
        fis.nextToken();
        vector3f.z = (float)fis.nval;
        fis.nextToken();
        float f = (float)fis.nval;
        Vector3f vector3f1 = new Vector3f();
        fis.nextToken();
        vector3f1.x = (float)fis.nval;
        fis.nextToken();
        vector3f1.y = (float)fis.nval;
        fis.nextToken();
        vector3f1.z = (float)fis.nval;
        fis.nextToken();
        float f1 = (float)fis.nval;
        Vector3f vector3f2 = new Vector3f();
        vector3f2.x = (((Tuple3f) (vector3f1)).x - ((Tuple3f) (vector3f)).x) / 2.0F + ((Tuple3f) (vector3f)).x;
        vector3f2.y = (((Tuple3f) (vector3f1)).y - ((Tuple3f) (vector3f)).y) / 2.0F + ((Tuple3f) (vector3f)).y;
        vector3f2.z = (((Tuple3f) (vector3f1)).z - ((Tuple3f) (vector3f)).z) / 2.0F + ((Tuple3f) (vector3f)).z;
        Vector3f vector3f3 = new Vector3f();
        vector3f3.sub(vector3f1, vector3f);
        float f2 = vector3f3.length();
        vector3f3.normalize();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        Vector3f vector3f6 = new Vector3f();
        Transform3D transform3d = new Transform3D();
        vector3f5 = new Vector3f(vector3f3);
        vector3f4.cross(vector3f3, new Vector3f(0.0F, 0.0F, 1.0F));
        float f3 = vector3f4.length();
        if(f3 != 0.0F)
        {
            vector3f4.z = ((Tuple3f) (vector3f4)).z / f3;
            vector3f4.x = ((Tuple3f) (vector3f4)).x / f3;
            vector3f4.y = ((Tuple3f) (vector3f4)).y / f3;
            vector3f6.cross(vector3f4, vector3f5);
        } else
        {
            vector3f4 = new Vector3f(vector3f3);
            vector3f6.cross(vector3f3, new Vector3f(0.0F, 1.0F, 0.0F));
            float f4 = vector3f6.length();
            vector3f6.x = ((Tuple3f) (vector3f6)).x / f4;
            vector3f6.y = ((Tuple3f) (vector3f6)).y / f4;
            vector3f6.z = ((Tuple3f) (vector3f6)).z / f4;
            vector3f5.cross(vector3f6, vector3f4);
            transform3d.rotZ(1.5707963267948966D);
        }
        Transform3D transform3d1 = new Transform3D();
        Transform3D transform3d2 = new Transform3D(new Matrix4f(((Tuple3f) (vector3f4)).x, ((Tuple3f) (vector3f4)).y, ((Tuple3f) (vector3f4)).z, 0.0F, ((Tuple3f) (vector3f5)).x, ((Tuple3f) (vector3f5)).y, ((Tuple3f) (vector3f5)).z, 0.0F, ((Tuple3f) (vector3f6)).x, ((Tuple3f) (vector3f6)).y, ((Tuple3f) (vector3f6)).z, 0.0F, 0.0F, 0.0F, 0.0F, 1.0F));
        transform3d2.invert();
        transform3d1.mul(transform3d2);
        transform3d1.mul(transform3d);
        transform3d1.setTranslation(vector3f2);
        TransformGroup transformgroup = new TransformGroup(transform3d1);
        if(f == f1)
        {
            if(debug)
                System.out.println("Adding a cylinder.");
            int i = 1;
            if((double)f < 0.0D && (double)f1 < 0.0D)
                i |= 4;
            Cylinder cylinder = new Cylinder(f, f2, i, currentApp);
            transformgroup.addChild(cylinder);
            bg.addChild(transformgroup);
        } else
        {
            if(debug)
                System.out.println("Adding a cone.");
            if(debug && f1 != 0.0F)
                System.out.println("Tapered cylinder encountered; cone will be drawn instead.");
            int j = 1;
            if((double)f <= 0.0D && (double)f1 <= 0.0D)
                j |= 4;
            Cone cone = new Cone(f, f2, j, currentApp);
            transformgroup.addChild(cone);
            bg.addChild(transformgroup);
        }
    }

    private void addPolygon(boolean flag)
    {
        polygons_total++;
        fis.nextToken();
        int k = (int)fis.nval;
        if(debug)
            System.out.println("Polygon #" + polygons_total + ", number of vertices: " + k);
        if(debug && flag)
            System.out.println("Polygon patch.");
        Point3d apoint3d[] = new Point3d[k];
        Vector3f avector3f[] = new Vector3f[k];
        int ai[] = new int[k];
        int ai1[] = new int[k];
        int ai2[] = new int[1];
        ai2[0] = k;
        for(int i = 0; i < k; i++)
        {
            fis.nextToken();
            double d = fis.nval;
            fis.nextToken();
            double d2 = fis.nval;
            fis.nextToken();
            double d4 = fis.nval;
            apoint3d[i] = new Point3d(d, d2, d4);
            if(flag)
            {
                fis.nextToken();
                double d1 = fis.nval;
                fis.nextToken();
                double d3 = fis.nval;
                fis.nextToken();
                double d5 = fis.nval;
                avector3f[i] = new Vector3f((float)d1, (float)d3, (float)d5);
            }
        }

        for(int j = 0; j < k; j++)
            ai[j] = j;

        GeometryInfo geometryinfo = new GeometryInfo(5);
        geometryinfo.setCoordinates(apoint3d);
        geometryinfo.setCoordinateIndices(ai);
        geometryinfo.setStripCounts(ai2);
        if(flag)
        {
            geometryinfo.setNormals(avector3f);
            geometryinfo.setNormalIndices(ai);
            Triangulator triangulator = new Triangulator();
            triangulator.triangulate(geometryinfo);
        } else
        {
            Triangulator triangulator1 = new Triangulator();
            triangulator1.triangulate(geometryinfo);
            NormalGenerator normalgenerator = new NormalGenerator();
            normalgenerator.generateNormals(geometryinfo);
        }
        Shape3D shape3d = new Shape3D(geometryinfo.getGeometryArray(), currentApp);
        bg.addChild(shape3d);
    }

    private void addSphere()
    {
        int i = 1;
        if(debug)
            System.out.println("Adding a sphere.");
        fis.nextToken();
        float f = (float)fis.nval;
        fis.nextToken();
        float f1 = (float)fis.nval;
        fis.nextToken();
        float f2 = (float)fis.nval;
        fis.nextToken();
        float f3 = (float)fis.nval;
        Transform3D transform3d = new Transform3D();
        transform3d.setTranslation(new Vector3f(f, f1, f2));
        TransformGroup transformgroup = new TransformGroup(transform3d);
        Sphere sphere = new Sphere(f3, i, currentApp);
        transformgroup.addChild(sphere);
        bg.addChild(transformgroup);
    }

    private void parseFile()
    {
        boolean flag = false;
        boolean flag1 = false;
        if(debug)
            System.out.println("Reading file...");
        fis.nextToken();
        while(fis.ttype != -103 && !flag) 
        {
            if(fis.ttype != -101)
            {
                flag = true;
                System.out.println("Token v, p, pp, f, b, l, c, or s expected, line #" + fis.lineno() + ".");
            } else
            {
                char c = fis.sval.charAt(0);
                boolean flag2 = false;
                switch(c)
                {
                case 102: // 'f'
                    setAppearance();
                    break;

                case 98: // 'b'
                    setBackground();
                    break;

                case 108: // 'l'
                    setLightSource();
                    break;

                case 118: // 'v'
                    setView();
                    break;

                case 112: // 'p'
                    if(fis.sval.compareTo("pp") == 0)
                        addPolygon(true);
                    else
                        addPolygon(false);
                    break;

                case 115: // 's'
                    addSphere();
                    break;

                case 99: // 'c'
                    addCylinder();
                    break;

                case 100: // 'd'
                case 101: // 'e'
                case 103: // 'g'
                case 104: // 'h'
                case 105: // 'i'
                case 106: // 'j'
                case 107: // 'k'
                case 109: // 'm'
                case 110: // 'n'
                case 111: // 'o'
                case 113: // 'q'
                case 114: // 'r'
                case 116: // 't'
                case 117: // 'u'
                default:
                    System.out.println("Unrecognized token \"" + c + '"' + " encountered at line #" + fis.lineno() + ".");
                    flag = true;
                    break;
                }
            }
            fis.nextToken();
        }
        if(debug)
            System.out.println("Done.");
    }

    private void setAppearance()
    {
        fis.nextToken();
        float f = (float)fis.nval;
        fis.nextToken();
        float f1 = (float)fis.nval;
        fis.nextToken();
        float f2 = (float)fis.nval;
        fis.nextToken();
        float f3 = (float)fis.nval;
        fis.nextToken();
        float f4 = (float)fis.nval;
        fis.nextToken();
        float f5 = (float)fis.nval;
        fis.nextToken();
        float f6 = (float)fis.nval;
        fis.nextToken();
        float f7 = (float)fis.nval;
        if(((int)f3 != 0 || (int)f4 != 0 || (int)f5 != 0 || (int)f6 != 0 || (int)f7 != 0) && debug)
            System.out.println("Complex attributes encountered (at line #" + fis.lineno() + ")");
        Material material = new Material();
        if((int)f3 != 0 || (int)f4 != 0)
        {
            if(debug)
                System.out.println("Specular and diffuse components non-zero in file.");
            material.setDiffuseColor(f3 * f, f3 * f1, f3 * f2);
            material.setSpecularColor(f4 * f, f4 * f1, f4 * f2);
            material.setShininess(f5 * 128F);
            material.setEmissiveColor(f6 * f, f6 * f1, f6 * f2);
        } else
        {
            material.setDiffuseColor(0.3F * f, 0.3F * f1, 0.3F * f2);
            material.setAmbientColor(0.7F * f, 0.7F * f1, 0.7F * f2);
        }
        currentApp = new Appearance();
        currentApp.setMaterial(material);
    }

    private void setBackground()
    {
        fis.nextToken();
        float f = (float)fis.nval;
        fis.nextToken();
        float f1 = (float)fis.nval;
        fis.nextToken();
        float f2 = (float)fis.nval;
        Background background = new Background(f, f1, f2);
        bg.addChild(background);
    }

    private void setLightSource()
    {
        fis.nextToken();
        float f = (float)fis.nval;
        fis.nextToken();
        float f1 = (float)fis.nval;
        fis.nextToken();
        float f2 = (float)fis.nval;
        PointLight pointlight = new PointLight();
        pointlight.setPosition(f, f1, f2);
        fis.nextToken();
        if(fis.ttype != -102)
        {
            fis.pushBack();
        } else
        {
            float f3 = (float)fis.nval;
            fis.nextToken();
            float f4 = (float)fis.nval;
            fis.nextToken();
            float f5 = (float)fis.nval;
            pointlight.setColor(new Color3f(f3, f4, f5));
        }
        bg.addChild(pointlight);
    }

    private void setView()
    {
        fis.nextToken();
        if(fis.sval.compareTo("from") == 0)
        {
            fis.nextToken();
            float f = (float)fis.nval;
            fis.nextToken();
            float f6 = (float)fis.nval;
            fis.nextToken();
            float f10 = (float)fis.nval;
            fis.nextToken();
        }
        if(fis.sval.compareTo("at") == 0)
        {
            fis.nextToken();
            float f1 = (float)fis.nval;
            fis.nextToken();
            float f7 = (float)fis.nval;
            fis.nextToken();
            float f11 = (float)fis.nval;
            fis.nextToken();
        }
        if(fis.sval.compareTo("up") == 0)
        {
            fis.nextToken();
            float f2 = (float)fis.nval;
            fis.nextToken();
            float f8 = (float)fis.nval;
            fis.nextToken();
            float f12 = (float)fis.nval;
            fis.nextToken();
        }
        if(fis.sval.compareTo("angle") == 0)
        {
            fis.nextToken();
            float f3 = (float)fis.nval;
            fis.nextToken();
        }
        if(fis.sval.compareTo("hither") == 0)
        {
            fis.nextToken();
            float f4 = (float)fis.nval;
            fis.nextToken();
        }
        if(fis.sval.compareTo("resolution") == 0)
        {
            fis.nextToken();
            float f5 = (float)fis.nval;
            fis.nextToken();
            float f9 = (float)fis.nval;
            fis.nextToken();
        }
        fis.pushBack();
    }

    private BranchGroup bg;
    private ReaderTokenizer fis;
    private boolean debug;
    private Appearance currentApp;
    private int polygons_total;
}
