/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   AppearanceManager.java

package ncsa.j3d.loaders.pdb;

import java.io.PrintStream;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class AppearanceManager
{

    public AppearanceManager()
    {
    }

    protected static Appearance buildAppearance(Color3f color3f)
    {
        Appearance appearance = new Appearance();
        Material material = new Material();
        material.setLightingEnable(true);
        material.setShininess(25F);
        material.setDiffuseColor(color3f);
        color3f.scale(0.2F);
        material.setAmbientColor(color3f);
        color3f.scale(0.0F);
        material.setSpecularColor(color3f);
        material.setEmissiveColor(color3f);
        appearance.setMaterial(material);
        return appearance;
    }

    public static Appearance getAppearanceByElement(String s)
    {
        try
        {
            if(hashtable.containsKey(s))
            {
                return (Appearance)hashtable.get(s);
            } else
            {
                Color3f color3f = new Color3f(0.8F, 0.2F, 0.9F);
                Appearance appearance = buildAppearance(color3f);
                hashtable.put(s, appearance);
                return appearance;
            }
        }
        catch(Exception exception)
        {
            System.out.println("ncsa.j3d.loaders.pdb.AppearanceManager.getAppearanceByElement");
            System.out.println(exception);
            return null;
        }
    }

    static Hashtable hashtable;
    static String nameArray[] = {
        "C", "O", "H", "N", "S", "P", "CL", "BR", "ZN", "NA", 
        "FE", "CA"
    };
    static Color3f colorArray[] = {
        new Color3f(0.2F, 0.2F, 0.2F), new Color3f(1.0F, 0.0F, 0.0F), new Color3f(1.0F, 1.0F, 1.0F), new Color3f(0.0F, 0.6F, 1.0F), new Color3f(1.0F, 1.0F, 0.0F), new Color3f(1.0F, 0.5F, 0.0F), new Color3f(0.0F, 1.0F, 0.0F), new Color3f(0.2F, 0.1F, 0.1F), new Color3f(0.2F, 0.1F, 0.1F), new Color3f(0.0F, 0.0F, 1.0F), 
        new Color3f(0.8F, 0.0F, 1.0F), new Color3f(0.7F, 0.7F, 0.7F)
    };

    static 
    {
        hashtable = new Hashtable();
        for(int i = 0; i < nameArray.length && i < colorArray.length; i++)
            hashtable.put(nameArray[i], buildAppearance(colorArray[i]));

    }
}
