/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   PDBParser.java

package ncsa.j3d.loaders.pdb;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.*;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.*;

// Referenced classes of package ncsa.j3d.loaders.pdb:
//            Record

public class PDBParser
{

    public PDBParser()
    {
        vector = new Vector();
    }

    public Scene getGeometry()
    {
        SceneBase scenebase = new SceneBase();
        BranchGroup branchgroup = new BranchGroup();
        branchgroup.setCapability(9);
        branchgroup.setBoundsAutoCompute(true);
        for(Enumeration enumeration = vector.elements(); enumeration.hasMoreElements();)
        {
            Record record = (Record)enumeration.nextElement();
            Node node = record.getNode();
            if(node != null)
                branchgroup.addChild(node);
        }

        scenebase.setSceneGroup(branchgroup);
        scenebase.addDescription("PDB file");
        return scenebase;
    }

    public static void main(String args[])
    {
        try
        {
            FileInputStream fileinputstream = new FileInputStream(args[0]);
            InputStreamReader inputstreamreader = new InputStreamReader(fileinputstream);
            (new PDBParser()).parse(inputstreamreader);
        }
        catch(FileNotFoundException _ex)
        {
            System.out.println(args[0] + " not found.");
        }
        catch(IOException ioexception)
        {
            System.out.println("PDBParser.main");
            System.out.println(ioexception);
        }
    }

    public void parse(Reader reader)
        throws IOException
    {
        BufferedReader bufferedreader = (reader instanceof BufferedReader) ? (BufferedReader)reader : new BufferedReader(reader);
        String s;
        while((s = bufferedreader.readLine()) != null) 
            if(s.length() == 80)
            {
                Record record = Record.subtype(s);
                if(record != null)
                    vector.addElement(record);
            }
    }

    protected Vector vector;
}
