/*
NCSA Portfolio was developed by Stephen Pietrowicz and Chris Heistad
at the National Center for Supercomputing Applications, and is
Copyright 1997-1999 by the Board of Trustees of the University of Illinois.

The original source code is no longer available.  The source below is
the result of decompilation of the Java binary files.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/




// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   HETATM.java

package ncsa.j3d.loaders.pdb.records;

import javax.media.j3d.*;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.pdb.AtomManager;
import ncsa.j3d.loaders.pdb.Record;

public class HETATM extends Record
{

    public HETATM()
    {
        serial = null;
        name = null;
        altLoc = null;
        resName = null;
        chainID = null;
        resSeq = null;
        iCode = null;
        x = 0.0F;
        y = 0.0F;
        z = 0.0F;
        occupancy = null;
        tempFactor = null;
        segID = null;
        element = null;
        charge = null;
        node = null;
        count++;
    }

    protected void buildNode()
    {
        TransformGroup transformgroup = new TransformGroup();
        Transform3D transform3d = new Transform3D();
        transform3d.set(new Vector3f(getX(), getY(), getZ()));
        transformgroup.setTransform(transform3d);
        Node node1 = AtomManager.getNodeByName(getName());
        transformgroup.addChild(node1);
        node1.setCapability(9);
        node1.setBoundsAutoCompute(true);
        transformgroup.setCapability(9);
        transformgroup.setBoundsAutoCompute(true);
        node = transformgroup;
    }

    public String getAltLoc()
    {
        return altLoc;
    }

    public String getChainID()
    {
        return chainID;
    }

    public String getCharge()
    {
        return charge;
    }

    public static long getCount()
    {
        return count;
    }

    public String getElement()
    {
        return element;
    }

    public String getICode()
    {
        return iCode;
    }

    public String getName()
    {
        return name;
    }

    public Node getNode()
    {
        return node;
    }

    public String getOccupancy()
    {
        return occupancy;
    }

    public String getResName()
    {
        return resName;
    }

    public String getResSeq()
    {
        return resSeq;
    }

    public String getSegID()
    {
        return segID;
    }

    public String getSerial()
    {
        return serial;
    }

    public String getTempFactor()
    {
        return tempFactor;
    }

    public float getX()
    {
        return x;
    }

    public float getY()
    {
        return y;
    }

    public float getZ()
    {
        return z;
    }

    public void read(String s)
    {
        serial = s.substring(7, 11).trim();
        name = s.substring(12, 16).trim();
        altLoc = s.substring(16, 17).trim();
        resName = s.substring(17, 20).trim();
        chainID = s.substring(21, 22).trim();
        resSeq = s.substring(22, 26).trim();
        iCode = s.substring(26, 27).trim();
        x = Float.valueOf(s.substring(30, 38).trim()).floatValue();
        y = Float.valueOf(s.substring(38, 46).trim()).floatValue();
        z = Float.valueOf(s.substring(46, 54).trim()).floatValue();
        occupancy = s.substring(54, 60).trim();
        tempFactor = s.substring(60, 66).trim();
        segID = s.substring(72, 76).trim();
        element = s.substring(76, 78).trim();
        charge = s.substring(78, 80).trim();
        buildNode();
    }

    protected static long count = 0L;
    String serial;
    String name;
    String altLoc;
    String resName;
    String chainID;
    String resSeq;
    String iCode;
    float x;
    float y;
    float z;
    String occupancy;
    String tempFactor;
    String segID;
    String element;
    String charge;
    Node node;

}
